/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal;

import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.Immutable;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.AllProfiles;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.BasicProfile;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.ProfileStaticCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.securitytoken.ProfileCredentialsService;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.securitytoken.RoleInfo;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;

@SdkInternalApi
@Immutable
public class ProfileAssumeRoleCredentialsProvider
implements AWSCredentialsProvider {
    private final AllProfiles allProfiles;
    private final BasicProfile profile;
    private final ProfileCredentialsService profileCredentialsService;
    private final AWSCredentialsProvider assumeRoleCredentialsProvider;

    public ProfileAssumeRoleCredentialsProvider(ProfileCredentialsService profileCredentialsService, AllProfiles allProfiles, BasicProfile profile) {
        this.allProfiles = allProfiles;
        this.profile = profile;
        this.profileCredentialsService = profileCredentialsService;
        this.assumeRoleCredentialsProvider = this.fromAssumeRole();
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.assumeRoleCredentialsProvider.getCredentials();
    }

    @Override
    public void refresh() {
    }

    private AWSCredentialsProvider fromAssumeRole() {
        if (StringUtils.isNullOrEmpty(this.profile.getRoleSourceProfile())) {
            throw new SdkClientException(String.format("Unable to load credentials from profile [%s]: Source profile name is not specified", this.profile.getProfileName()));
        }
        BasicProfile sourceProfile = this.allProfiles.getProfile(this.profile.getRoleSourceProfile());
        if (sourceProfile == null) {
            throw new SdkClientException(String.format("Unable to load source profile [%s]: Source profile was not found [%s]", this.profile.getProfileName(), this.profile.getRoleSourceProfile()));
        }
        AWSCredentials sourceCredentials = new ProfileStaticCredentialsProvider(sourceProfile).getCredentials();
        String roleSessionName = this.profile.getRoleSessionName() == null ? "aws-sdk-java-" + System.currentTimeMillis() : this.profile.getRoleSessionName();
        RoleInfo roleInfo = new RoleInfo().withRoleArn(this.profile.getRoleArn()).withRoleSessionName(roleSessionName).withExternalId(this.profile.getRoleExternalId()).withLongLivedCredentials(sourceCredentials).withWebIdentityTokenFilePath(this.profile.getWebIdentityTokenFilePath());
        return this.profileCredentialsService.getAssumeRoleCredentialsProvider(roleInfo);
    }
}

