/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class IntToFixedConverter
extends AbstractArrowVectorConverter {
    protected IntVector intVector;
    protected int sfScale;
    protected ByteBuffer byteBuf = ByteBuffer.allocate(4);

    public IntToFixedConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")}), fieldVector, columnIndex, context);
        this.intVector = (IntVector)fieldVector;
    }

    @Override
    public byte[] toBytes(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        this.byteBuf.putInt(0, this.getInt(index));
        return this.byteBuf.array();
    }

    @Override
    public byte toByte(int index) throws SFException {
        int intVal = this.toInt(index);
        byte byteVal = (byte)intVal;
        if (byteVal == intVal) {
            return byteVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", intVal);
    }

    @Override
    public short toShort(int index) throws SFException {
        int intVal = this.toInt(index);
        short shortVal = (short)intVal;
        if (shortVal == intVal) {
            return shortVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "short", intVal);
    }

    protected int getInt(int index) throws SFException {
        return this.intVector.getDataBuffer().getInt(index * 4);
    }

    @Override
    public int toInt(int index) throws SFException {
        if (this.intVector.isNull(index)) {
            return 0;
        }
        return this.getInt(index);
    }

    @Override
    public long toLong(int index) throws SFException {
        return this.toInt(index);
    }

    @Override
    public float toFloat(int index) throws SFException {
        return this.toInt(index);
    }

    @Override
    public double toDouble(int index) throws SFException {
        return this.toInt(index);
    }

    @Override
    public BigDecimal toBigDecimal(int index) throws SFException {
        if (this.intVector.isNull(index)) {
            return null;
        }
        return BigDecimal.valueOf(this.getInt(index), this.sfScale);
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.isNull(index) ? null : Long.valueOf(this.getInt(index));
    }

    @Override
    public String toString(int index) throws SFException {
        return this.isNull(index) ? null : Integer.toString(this.getInt(index));
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        int val = this.toInt(index);
        if (val == 0) {
            return false;
        }
        if (val == 1) {
            return true;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "Boolean", val);
    }
}

