/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.veneer.repackaged.io.opencensus.implcore.trace.propagation;

import com.google.bigtable.veneer.repackaged.io.opencensus.trace.SpanContext;
import com.google.bigtable.veneer.repackaged.io.opencensus.trace.SpanId;
import com.google.bigtable.veneer.repackaged.io.opencensus.trace.TraceId;
import com.google.bigtable.veneer.repackaged.io.opencensus.trace.TraceOptions;
import com.google.bigtable.veneer.repackaged.io.opencensus.trace.Tracestate;
import com.google.bigtable.veneer.repackaged.io.opencensus.trace.propagation.BinaryFormat;
import com.google.bigtable.veneer.repackaged.io.opencensus.trace.propagation.SpanContextParseException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

final class BinaryFormatImpl
extends BinaryFormat {
    private static final Tracestate TRACESTATE_DEFAULT = Tracestate.builder().build();
    private static final byte VERSION_ID = 0;
    private static final int VERSION_ID_OFFSET = 0;
    private static final byte ID_SIZE = 1;
    private static final byte TRACE_ID_FIELD_ID = 0;
    @VisibleForTesting
    static final int TRACE_ID_FIELD_ID_OFFSET = 1;
    private static final int TRACE_ID_OFFSET = 2;
    private static final byte SPAN_ID_FIELD_ID = 1;
    @VisibleForTesting
    static final int SPAN_ID_FIELD_ID_OFFSET = 18;
    private static final int SPAN_ID_OFFSET = 19;
    private static final byte TRACE_OPTION_FIELD_ID = 2;
    @VisibleForTesting
    static final int TRACE_OPTION_FIELD_ID_OFFSET = 27;
    private static final int TRACE_OPTIONS_OFFSET = 28;
    private static final int REQUIRED_FORMAT_LENGTH = 27;
    private static final int ALL_FORMAT_LENGTH = 29;

    BinaryFormatImpl() {
    }

    @Override
    public byte[] toByteArray(SpanContext spanContext) {
        Preconditions.checkNotNull((Object)spanContext, (Object)"spanContext");
        byte[] bytes = new byte[29];
        bytes[0] = 0;
        bytes[1] = 0;
        spanContext.getTraceId().copyBytesTo(bytes, 2);
        bytes[18] = 1;
        spanContext.getSpanId().copyBytesTo(bytes, 19);
        bytes[27] = 2;
        spanContext.getTraceOptions().copyBytesTo(bytes, 28);
        return bytes;
    }

    @Override
    public SpanContext fromByteArray(byte[] bytes) throws SpanContextParseException {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes");
        if (bytes.length == 0 || bytes[0] != 0) {
            throw new SpanContextParseException("Unsupported version.");
        }
        if (bytes.length < 27) {
            throw new SpanContextParseException("Invalid input: truncated");
        }
        TraceOptions traceOptions = TraceOptions.DEFAULT;
        int pos = 1;
        if (bytes[pos] != 0) {
            throw new SpanContextParseException("Invalid input: expected trace ID at offset " + pos);
        }
        TraceId traceId = TraceId.fromBytes(bytes, pos + 1);
        if (bytes[pos += 17] != 1) {
            throw new SpanContextParseException("Invalid input: expected span ID at offset " + pos);
        }
        SpanId spanId = SpanId.fromBytes(bytes, pos + 1);
        if (bytes.length > (pos += 9) && bytes[pos] == 2) {
            if (bytes.length < 29) {
                throw new SpanContextParseException("Invalid input: truncated");
            }
            traceOptions = TraceOptions.fromByte(bytes[pos + 1]);
        }
        return SpanContext.create(traceId, spanId, traceOptions, TRACESTATE_DEFAULT);
    }
}

