/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.RedshiftTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class RedshiftMoney
extends RedshiftObject
implements Serializable,
Cloneable {
    public double val;

    public RedshiftMoney(double value) {
        this();
        this.val = value;
    }

    public RedshiftMoney(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public RedshiftMoney() {
        this.setType("money");
    }

    @Override
    public void setValue(String s) throws SQLException {
        try {
            boolean negative = s.charAt(0) == '(';
            String s1 = RedshiftTokenizer.removePara(s).substring(1);
            int pos = s1.indexOf(44);
            while (pos != -1) {
                s1 = s1.substring(0, pos) + s1.substring(pos + 1);
                pos = s1.indexOf(44);
            }
            this.val = Double.parseDouble(s1);
            this.val = negative ? -this.val : this.val;
        }
        catch (NumberFormatException e) {
            throw new RedshiftException(GT.tr("Conversion of money failed.", new Object[0]), RedshiftState.NUMERIC_CONSTANT_OUT_OF_RANGE, (Throwable)e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.val);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RedshiftMoney) {
            RedshiftMoney p = (RedshiftMoney)obj;
            return this.val == p.val;
        }
        return false;
    }

    @Override
    public String getValue() {
        if (this.val < 0.0) {
            return "-$" + -this.val;
        }
        return "$" + this.val;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

