/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkUserAppException;
import org.apache.spark.api.python.Py4JServer;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class PythonRunner$ {
    public static PythonRunner$ MODULE$;

    static {
        new PythonRunner$();
    }

    public void main(String[] args) {
        String pythonFile = args[0];
        String pyFiles = args[1];
        String[] otherArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).slice(2, args.length);
        SparkConf sparkConf = new SparkConf();
        String pythonExec = (String)((Option)sparkConf.get(package$.MODULE$.PYSPARK_DRIVER_PYTHON())).orElse((Function0 & Serializable & scala.Serializable)() -> (Option)sparkConf.get(package$.MODULE$.PYSPARK_PYTHON())).orElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"PYSPARK_DRIVER_PYTHON")).orElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"PYSPARK_PYTHON")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "python3");
        String formattedPythonFile = this.formatPath(pythonFile, this.formatPath$default$2());
        String[] formattedPyFiles = this.resolvePyFiles(this.formatPaths(pyFiles, this.formatPaths$default$2()));
        Py4JServer gatewayServer = new Py4JServer(sparkConf);
        Thread thread = new Thread(() -> Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> gatewayServer.start()));
        thread.setName("py4j-gateway-init");
        thread.setDaemon(true);
        thread.start();
        thread.join();
        ArrayBuffer pathElements = new ArrayBuffer();
        pathElements.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])formattedPyFiles)));
        pathElements.$plus$eq((Object)PythonUtils$.MODULE$.sparkPythonPath());
        pathElements.$plus$eq(scala.sys.package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable & scala.Serializable)() -> ""));
        String pythonPath = PythonUtils$.MODULE$.mergePythonPaths((Seq<String>)pathElements.toSeq());
        ProcessBuilder builder = new ProcessBuilder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)new .colon.colon((Object)pythonExec, (List)new .colon.colon((Object)formattedPythonFile, (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherArgs)), Seq$.MODULE$.canBuildFrom())).asJava());
        Map<String, String> env = builder.environment();
        sparkConf.getOption("spark.remote").foreach((Function1 & Serializable & scala.Serializable)url -> env.put("SPARK_REMOTE", (String)url));
        env.put("PYTHONPATH", pythonPath);
        env.put("PYTHONUNBUFFERED", "YES");
        env.put("PYSPARK_GATEWAY_PORT", String.valueOf(BoxesRunTime.boxToInteger((int)gatewayServer.getListeningPort())));
        env.put("PYSPARK_GATEWAY_SECRET", gatewayServer.secret());
        ((Option)sparkConf.get(package$.MODULE$.PYSPARK_PYTHON())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> env.put("PYSPARK_PYTHON", (String)x$1));
        scala.sys.package$.MODULE$.env().get((Object)"PYTHONHASHSEED").foreach((Function1 & Serializable & scala.Serializable)x$2 -> env.put("PYTHONHASHSEED", (String)x$2));
        if (sparkConf.getOption("spark.yarn.appMasterEnv.OMP_NUM_THREADS").isEmpty() && sparkConf.getOption("spark.mesos.driverEnv.OMP_NUM_THREADS").isEmpty() && sparkConf.getOption("spark.kubernetes.driverEnv.OMP_NUM_THREADS").isEmpty()) {
            sparkConf.getOption("spark.driver.cores").foreach((Function1 & Serializable & scala.Serializable)x$3 -> env.put("OMP_NUM_THREADS", (String)x$3));
        }
        builder.redirectErrorStream(true);
        try {
            Process process = builder.start();
            new RedirectThread(process.getInputStream(), System.out, "redirect output", RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new SparkUserAppException(exitCode);
            }
        }
        finally {
            gatewayServer.shutdown();
        }
    }

    public String formatPath(String path, boolean testWindows) {
        String formattedPath;
        block2: {
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.nonLocalPaths(path, testWindows))).nonEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(96).append("Launching Python applications through ").append("spark-submit is currently only supported for local files: ").append(path).toString());
            }
            URI uri = (URI)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new URI(path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new File(path).toURI());
            String string = uri.getScheme();
            String string2 = string == null ? path : (formattedPath = ("file".equals(string) ? true : "local".equals(string)) ? uri.getPath() : null);
            if (formattedPath == null) {
                throw new IllegalArgumentException(new StringBuilder(31).append("Python file path is malformed: ").append(path).toString());
            }
            if (!Utils$.MODULE$.isWindows() || !formattedPath.matches("/[a-zA-Z]:/.*")) break block2;
            formattedPath = new StringOps(Predef$.MODULE$.augmentString(formattedPath)).stripPrefix("/");
        }
        return formattedPath;
    }

    public boolean formatPath$default$2() {
        return false;
    }

    public String[] formatPaths(String paths, boolean testWindows) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)Option$.MODULE$.apply((Object)paths).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).split(","))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PythonRunner$.$anonfun$formatPaths$2(x$4))))).map((Function1 & Serializable & scala.Serializable)p -> MODULE$.formatPath((String)p, testWindows), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public boolean formatPaths$default$2() {
        return false;
    }

    private String[] resolvePyFiles(String[] pyFiles) {
        LazyRef dest$lzy = new LazyRef();
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pyFiles)).flatMap((Function1 & Serializable & scala.Serializable)pyFile -> {
            if (pyFile.endsWith(".py")) {
                File source = new File((String)pyFile);
                if (source.exists() && source.isFile() && source.canRead()) {
                    Files.copy(source.toPath(), new File(PythonRunner$.dest$1(dest$lzy), source.getName()).toPath(), new CopyOption[0]);
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)PythonRunner$.dest$1(dest$lzy).getAbsolutePath()));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)new Some(pyFile));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).distinct();
    }

    public static final /* synthetic */ boolean $anonfun$formatPaths$2(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    private static final /* synthetic */ File dest$lzycompute$1(LazyRef dest$lzy$1) {
        File file;
        LazyRef lazyRef = dest$lzy$1;
        synchronized (lazyRef) {
            File file2;
            if (dest$lzy$1.initialized()) {
                file2 = (File)dest$lzy$1.value();
            } else {
                String x$1 = "localPyFiles";
                String x$2 = Utils$.MODULE$.createTempDir$default$1();
                file2 = (File)dest$lzy$1.initialize((Object)Utils$.MODULE$.createTempDir(x$2, x$1));
            }
            file = file2;
        }
        return file;
    }

    private static final File dest$1(LazyRef dest$lzy$1) {
        if (dest$lzy$1.initialized()) {
            return (File)dest$lzy$1.value();
        }
        return PythonRunner$.dest$lzycompute$1(dest$lzy$1);
    }

    private PythonRunner$() {
        MODULE$ = this;
    }
}

