/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public final class InstanceOfExpression
extends UnaryExpression {
    ItemType targetType;
    int targetCardinality;

    public InstanceOfExpression(Expression expression, SequenceType sequenceType) {
        super(expression);
        this.targetType = sequenceType.getPrimaryType();
        if (this.targetType == null) {
            throw new IllegalArgumentException("Primary item type must not be null");
        }
        this.targetCardinality = sequenceType.getCardinality();
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        if (this.operand instanceof Value) {
            return (AtomicValue)this.evaluateItem(staticContext.makeEarlyEvaluationContext());
        }
        if (Cardinality.subsumes(this.targetCardinality, this.operand.getCardinality())) {
            TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
            int n = typeHierarchy.relationship(this.operand.getItemType(typeHierarchy), this.targetType);
            if (n == 0 || n == 2) {
                return BooleanValue.TRUE;
            }
            if (!(n != 4 || Cardinality.allowsZero(this.targetCardinality) && Cardinality.allowsZero(this.operand.getCardinality()))) {
                return BooleanValue.FALSE;
            }
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.optimize(optimizer, staticContext, itemType);
        if (expression != this) {
            return expression;
        }
        if (Cardinality.subsumes(this.targetCardinality, this.operand.getCardinality())) {
            TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
            int n = typeHierarchy.relationship(this.operand.getItemType(typeHierarchy), this.targetType);
            if (n == 0 || n == 2) {
                return BooleanValue.TRUE;
            }
            if (!(n != 4 || Cardinality.allowsZero(this.targetCardinality) && Cardinality.allowsZero(this.operand.getCardinality()))) {
                return BooleanValue.FALSE;
            }
        }
        return this;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.targetType == ((InstanceOfExpression)object).targetType && this.targetCardinality == ((InstanceOfExpression)object).targetCardinality;
    }

    public int computeCardinality() {
        return 16384;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        int n = 0;
        while ((item = sequenceIterator.next()) != null) {
            ++n;
            if (!this.targetType.matchesItem(item, xPathContext, false)) {
                return false;
            }
            if (n != 2 || Cardinality.allowsMany(this.targetCardinality)) continue;
            return false;
        }
        return n != 0 || (this.targetCardinality & 0x2000) != 0;
    }

    protected String displayOperator(NamePool namePool) {
        return "instance of " + this.targetType.toString(namePool) + Cardinality.getOccurrenceIndicator(this.targetCardinality);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "instance of");
        this.operand.display(n + 1, namePool, printStream);
        printStream.println(ExpressionTool.indent(n + 1) + this.targetType.toString(namePool) + Cardinality.getOccurrenceIndicator(this.targetCardinality));
    }
}

