/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import java.io.Serializable;

public class ResourceLevel
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final String V4R4M0 = "V4R4M0";
    public static final String V4R5M0 = "V4R5M0";
    public static final String V5R1M0 = "V5R1M0";
    private String minLevel_ = null;
    private String maxLevel_ = null;

    public ResourceLevel() {
    }

    public ResourceLevel(String string) {
        this.minLevel_ = string;
    }

    public ResourceLevel(String string, String string2) {
        if (string != null && string2 != null && string.compareTo(string2) < 0) {
            throw new ExtendedIllegalArgumentException("maxLevel", 2);
        }
        this.minLevel_ = string;
        this.maxLevel_ = string2;
    }

    public boolean checkLevel(int n) {
        return this.checkLevel(ResourceLevel.vrmToLevel(n));
    }

    public boolean checkLevel(String string) {
        if (string == null) {
            return true;
        }
        if (string.length() == 0) {
            return true;
        }
        if (this.minLevel_ == null) {
            if (this.maxLevel_ == null) {
                return true;
            }
            return string.compareTo(this.maxLevel_) <= 0;
        }
        if (this.maxLevel_ == null) {
            return this.minLevel_.compareTo(string) <= 0;
        }
        return this.minLevel_.compareTo(string) <= 0 && string.compareTo(this.maxLevel_) <= 0;
    }

    public String getMinLevel() {
        return this.minLevel_;
    }

    public String getMaxLevel() {
        return this.maxLevel_;
    }

    public static String vrmToLevel(int n) {
        StringBuffer stringBuffer = new StringBuffer("V");
        stringBuffer.append((n & 0xFFFF0000) >> 16);
        stringBuffer.append("R");
        stringBuffer.append((n & 0xFF00) >> 8);
        stringBuffer.append("M");
        stringBuffer.append(n & 0xFF);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        if (this.minLevel_ != null) {
            stringBuffer.append(this.minLevel_);
        }
        stringBuffer.append(',');
        if (this.maxLevel_ != null) {
            stringBuffer.append(this.maxLevel_);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

