/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class CredentialsService {
    static final String GCS_NOT_SUPPORTED_MSG = "Credentials that is stored on Google Cloud Storage is no longer supported. Download the credentials to a local file and reference the local file in the connection URL.";
    static final CredentialsService INSTANCE = new CredentialsService();

    CredentialsService() {
    }

    GoogleCredentials createCredentials(String credentialsUrl) {
        try {
            if (credentialsUrl == null) {
                return this.internalGetApplicationDefault();
            }
            return this.getCredentialsFromUrl(credentialsUrl);
        }
        catch (IOException e) {
            String msg = "Invalid credentials path specified: ";
            msg = credentialsUrl == null ? msg + "There are no credentials set in the connection string, and the default application credentials are not set or are pointing to an invalid or non-existing file.\nPlease check the GOOGLE_APPLICATION_CREDENTIALS environment variable and/or the credentials that have been set using the Google Cloud SDK gcloud auth application-default login command" : msg + credentialsUrl;
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, msg, e);
        }
    }

    GoogleCredentials decodeCredentials(String encodedCredentials) {
        byte[] decodedBytes;
        try {
            decodedBytes = BaseEncoding.base64Url().decode((CharSequence)encodedCredentials);
        }
        catch (IllegalArgumentException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "The encoded credentials could not be decoded as a base64 string. Please ensure that the provided string is a valid base64 string.", e);
        }
        try {
            return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(decodedBytes));
        }
        catch (IOException | IllegalArgumentException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "The encoded credentials do not contain a valid Google Cloud credentials JSON string.", e);
        }
    }

    @VisibleForTesting
    GoogleCredentials internalGetApplicationDefault() throws IOException {
        return GoogleCredentials.getApplicationDefault();
    }

    private GoogleCredentials getCredentialsFromUrl(String credentialsUrl) throws IOException {
        Preconditions.checkNotNull((Object)credentialsUrl);
        Preconditions.checkArgument((credentialsUrl.length() > 0 ? 1 : 0) != 0, (Object)"credentialsUrl may not be an empty string");
        if (credentialsUrl.startsWith("gs://")) {
            throw new IOException(GCS_NOT_SUPPORTED_MSG);
        }
        return this.getCredentialsFromLocalFile(credentialsUrl);
    }

    private GoogleCredentials getCredentialsFromLocalFile(String filePath) throws IOException {
        File credentialsFile = new File(filePath);
        if (!credentialsFile.isFile()) {
            throw new IOException(String.format("Error reading credential file %s: File does not exist", filePath));
        }
        try (FileInputStream credentialsStream = new FileInputStream(credentialsFile);){
            GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)credentialsStream);
            return googleCredentials;
        }
    }
}

