/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.UUID;

public class ClickHouseIpv6Value
extends ClickHouseObjectValue<Inet6Address> {
    public static final Inet6Address DEFAULT;

    public static ClickHouseIpv6Value ofNull() {
        return ClickHouseIpv6Value.ofNull(null);
    }

    public static ClickHouseIpv6Value ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseIpv6Value ? (ClickHouseIpv6Value)((ClickHouseIpv6Value)ref).set(null) : new ClickHouseIpv6Value(null);
    }

    public static ClickHouseIpv6Value of(Inet6Address value) {
        return ClickHouseIpv6Value.of(null, value);
    }

    public static ClickHouseIpv6Value of(ClickHouseValue ref, Inet6Address value) {
        return ref instanceof ClickHouseIpv6Value ? (ClickHouseIpv6Value)((ClickHouseIpv6Value)ref).set(value) : new ClickHouseIpv6Value(value);
    }

    protected ClickHouseIpv6Value(Inet6Address value) {
        super(value);
    }

    @Override
    public ClickHouseIpv6Value copy(boolean deep) {
        return new ClickHouseIpv6Value((Inet6Address)this.getValue());
    }

    @Override
    public byte asByte() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? (byte)0 : bigInt.byteValueExact();
    }

    @Override
    public short asShort() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? (short)0 : bigInt.shortValueExact();
    }

    @Override
    public int asInteger() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? 0 : bigInt.intValueExact();
    }

    @Override
    public long asLong() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? 0L : bigInt.longValueExact();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNullOrEmpty() ? null : new BigInteger(1, ((Inet6Address)this.getValue()).getAddress());
    }

    @Override
    public float asFloat() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? 0.0f : bigInt.floatValue();
    }

    @Override
    public double asDouble() {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? 0.0 : bigInt.doubleValue();
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        BigInteger bigInt = this.asBigInteger();
        return bigInt == null ? null : new BigDecimal(bigInt, scale);
    }

    @Override
    public Inet4Address asInet4Address() {
        return ClickHouseValues.convertToIpv4((Inet6Address)this.getValue());
    }

    @Override
    public Inet6Address asInet6Address() {
        return (Inet6Address)this.getValue();
    }

    @Override
    public Object asObject() {
        return this.getValue();
    }

    @Override
    public String asString(int length, Charset charset) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        String str = String.valueOf(((Inet6Address)this.getValue()).getHostAddress());
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseIpv6Value resetToDefault() {
        this.set(DEFAULT);
        return this;
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        return '\'' + ((Inet6Address)this.getValue()).getHostAddress() + '\'';
    }

    @Override
    public ClickHouseIpv6Value update(byte value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseIpv6Value update(short value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseIpv6Value update(int value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseIpv6Value update(long value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseIpv6Value update(float value) {
        return this.update(BigDecimal.valueOf(value).toBigIntegerExact());
    }

    @Override
    public ClickHouseIpv6Value update(double value) {
        return this.update(BigDecimal.valueOf(value).toBigIntegerExact());
    }

    @Override
    public ClickHouseIpv6Value update(BigInteger value) {
        this.set(ClickHouseValues.convertToIpv6(value));
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(BigDecimal value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(value.toBigIntegerExact());
        }
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(Enum<?> value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.ordinal()));
        }
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(Inet4Address value) {
        this.set(ClickHouseValues.convertToIpv6(value));
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(Inet6Address value) {
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(LocalDate value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.toEpochDay()));
        }
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(LocalTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.toSecondOfDay()));
        }
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(LocalDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.toEpochSecond(ZoneOffset.UTC)));
        }
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(String value) {
        this.set(ClickHouseValues.convertToIpv6(value));
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(UUID value) {
        BigInteger v = ClickHouseValues.convertToBigInteger(value);
        if (v == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(v);
        }
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.asInet6Address());
        }
        return this;
    }

    @Override
    public ClickHouseIpv6Value update(Object value) {
        if (value instanceof Inet6Address) {
            this.set((Inet6Address)value);
        } else if (value instanceof Inet4Address) {
            this.set(ClickHouseValues.convertToIpv6((Inet4Address)value));
        } else {
            super.update(value);
        }
        return this;
    }

    static {
        try {
            DEFAULT = (Inet6Address)InetAddress.getByAddress("::0", new byte[16]);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Failed to create default Ipv6 value", e);
        }
    }
}

