/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.expansion.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.expansion.service.ExpansionService;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ExpansionServiceSchemaTransformProvider
implements ExpansionService.TransformProvider<PCollectionRowTuple, PCollectionRowTuple> {
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SchemaTransformProvider> schemaTransformProviders = new HashMap<String, SchemaTransformProvider>();
    private static @Nullable @UnknownKeyFor @Initialized ExpansionServiceSchemaTransformProvider transformProvider = null;

    private ExpansionServiceSchemaTransformProvider() {
        try {
            for (SchemaTransformProvider schemaTransformProvider : ServiceLoader.load(SchemaTransformProvider.class)) {
                if (this.schemaTransformProviders.containsKey(schemaTransformProvider.identifier())) {
                    throw new IllegalArgumentException("Found multiple SchemaTransformProvider implementations with the same identifier " + schemaTransformProvider.identifier());
                }
                this.schemaTransformProviders.put(schemaTransformProvider.identifier(), schemaTransformProvider);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized ExpansionServiceSchemaTransformProvider of() {
        if (transformProvider == null) {
            transformProvider = new ExpansionServiceSchemaTransformProvider();
        }
        return transformProvider;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple createInput(@UnknownKeyFor @NonNull @Initialized Pipeline p, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs) {
        PCollectionRowTuple inputRowTuple = PCollectionRowTuple.empty((Pipeline)p);
        for (Map.Entry<String, PCollection<?>> entry : inputs.entrySet()) {
            inputRowTuple = inputRowTuple.and(entry.getKey(), entry.getValue());
        }
        return inputRowTuple;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> extractOutputs(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple output) {
        ImmutableMap.Builder pCollectionMap = ImmutableMap.builder();
        for (String key : output.getAll().keySet()) {
            pCollectionMap.put((Object)key, (Object)output.get(key));
        }
        return pCollectionMap.build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform getTransform(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec spec) {
        Row configRow;
        Schema configSchemaFromProvider;
        String identifier;
        ExternalTransforms.SchemaTransformPayload payload;
        try {
            payload = ExternalTransforms.SchemaTransformPayload.parseFrom((ByteString)spec.getPayload());
            identifier = payload.getIdentifier();
            if (!this.schemaTransformProviders.containsKey(identifier)) {
                throw new RuntimeException("Did not find a SchemaTransformProvider with the identifier " + identifier);
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Invalid payload type for URN " + BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ExpansionMethods.Enum.SCHEMA_TRANSFORM), e);
        }
        identifier = payload.getIdentifier();
        SchemaTransformProvider provider = this.schemaTransformProviders.get(identifier);
        if (provider == null) {
            throw new IllegalArgumentException("Could not find a SchemaTransform with identifier " + identifier);
        }
        Schema configSchemaFromRequest = SchemaTranslation.schemaFromProto((SchemaApi.Schema)payload.getConfigurationSchema());
        if (!configSchemaFromRequest.assignableTo(configSchemaFromProvider = provider.configurationSchema())) {
            throw new IllegalArgumentException(String.format("Config schema provided with the expansion request %s is not compatible with the config of the Schema transform %s.", configSchemaFromRequest, configSchemaFromProvider));
        }
        try {
            configRow = (Row)RowCoder.of((Schema)provider.configurationSchema()).decode(payload.getConfigurationRow().newInput());
        }
        catch (IOException e) {
            throw new RuntimeException("Error decoding payload", e);
        }
        return provider.from(configRow).buildTransform();
    }

    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized SchemaTransformProvider> getAllProviders() {
        return this.schemaTransformProviders.values();
    }
}

