/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.async;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.json.JsonMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import org.apache.hop.workflow.engines.local.LocalWorkflowEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebServiceServlet;
import org.apache.hop.www.async.AsyncWebService;
import org.json.simple.JSONObject;

@HopServerServlet(id="asyncRun", name="Asynchronously run a workflow")
public class AsyncRunServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final Class<?> PKG = WebServiceServlet.class;
    private static final long serialVersionUID = 3834384735363246432L;
    public static final String CONTEXT_PATH = "/hop/asyncRun";

    public AsyncRunServlet() {
    }

    public AsyncRunServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String runConfigurationName;
        String webServiceName;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"AsyncRunServlet.Log.AsyncRunRequested", (String[])new String[0]));
        }
        IVariables variables = this.pipelineMap.getHopServerConfig().getVariables();
        MultiMetadataProvider metadataProvider = new MultiMetadataProvider(Encr.getEncoder(), new ArrayList(), variables);
        metadataProvider.getProviders().add(HopMetadataUtil.getStandardHopMetadataProvider((IVariables)variables));
        String metadataFolder = this.pipelineMap.getHopServerConfig().getMetadataFolder();
        if (StringUtils.isNotEmpty((String)metadataFolder)) {
            metadataProvider.getProviders().add(new JsonMetadataProvider(Encr.getEncoder(), metadataFolder, variables));
        }
        if (StringUtils.isEmpty((String)(webServiceName = request.getParameter("service")))) {
            this.log.logError("Please specify a service parameter pointing to the name of the asynchronous webservice object");
        }
        if (StringUtils.isNotEmpty((String)(runConfigurationName = request.getParameter("runConfig")))) {
            this.log.logBasic("Running asynchronous workflow with run configuration '" + runConfigurationName + "'");
        }
        try {
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(AsyncWebService.class);
            AsyncWebService webService = (AsyncWebService)serializer.load(webServiceName);
            if (webService == null) {
                throw new HopException("Unable to find asynchronous web service '" + webServiceName + "'.  You can set option metadata_folder in the Hop server XML configuration");
            }
            if (!webService.isEnabled()) {
                throw new HopException("Asynchronous Web service '" + webServiceName + "' is disabled.");
            }
            if (StringUtils.isEmpty((String)runConfigurationName)) {
                runConfigurationName = variables.resolve(webService.getRunConfigurationName());
            }
            String filename = variables.resolve(webService.getFilename());
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String serverObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.HOP_SERVER, null);
            servletLoggingObject.setContainerObjectId(serverObjectId);
            WorkflowMeta workflowMeta = new WorkflowMeta(variables, filename, (IHopMetadataProvider)metadataProvider);
            Object workflow = StringUtils.isEmpty((String)runConfigurationName) ? new LocalWorkflowEngine(workflowMeta, (ILoggingObject)servletLoggingObject) : WorkflowEngineFactory.createWorkflowEngine((IVariables)variables, (String)runConfigurationName, (IHopMetadataProvider)metadataProvider, (WorkflowMeta)workflowMeta, (ILoggingObject)servletLoggingObject);
            workflow.setContainerId(serverObjectId);
            workflow.setMetadataProvider((IHopMetadataProvider)metadataProvider);
            workflow.setLogLevel(LogLevel.BASIC);
            workflow.initializeFrom(variables);
            workflow.setVariable("SERVER_OBJECT_ID", serverObjectId);
            String contentVariable = variables.resolve(webService.getBodyContentVariable());
            String content = "";
            if (StringUtils.isNotEmpty((String)contentVariable)) {
                try (ServletInputStream in = request.getInputStream();
                     ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = in.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, length);
                    }
                    outputStream.flush();
                    content = outputStream.toString(StandardCharsets.UTF_8);
                }
                workflow.setVariable(contentVariable, Const.NVL((String)content, (String)""));
            }
            String[] pipelineParameters = workflowMeta.listParameters();
            workflow.copyParametersFromDefinitions((INamedParameterDefinitions)workflowMeta);
            for (String requestParameter : request.getParameterMap().keySet()) {
                if ("service".equals(requestParameter)) continue;
                String requestParameterValue = request.getParameter(requestParameter);
                if (Const.indexOfString((String)requestParameter, (String[])pipelineParameters) < 0) {
                    workflow.setVariable(requestParameter, Const.NVL((String)requestParameterValue, (String)""));
                    continue;
                }
                try {
                    workflow.setParameterValue(requestParameter, Const.NVL((String)requestParameterValue, (String)""));
                }
                catch (UnknownParamException e) {
                    this.log.logError("Error running asynchronous web service", (Throwable)e);
                }
            }
            workflow.activateParameters((IVariables)workflow);
            WorkflowExecutionConfiguration workflowExecutionConfiguration = new WorkflowExecutionConfiguration();
            WorkflowConfiguration workflowConfiguration = new WorkflowConfiguration(workflowMeta, workflowExecutionConfiguration, (IHopMetadataProvider)new SerializableMetadataProvider((IHopMetadataProvider)metadataProvider));
            this.getWorkflowMap().addWorkflow(webServiceName, serverObjectId, (IWorkflowEngine)workflow, workflowConfiguration);
            ArrayBlockingQueue waitForLogChannelIdQueue = new ArrayBlockingQueue(10);
            workflow.addWorkflowStartedListener(engine -> waitForLogChannelIdQueue.add(new Object()));
            new Thread(() -> ((IWorkflowEngine)workflow).startExecution()).start();
            waitForLogChannelIdQueue.poll(30L, TimeUnit.SECONDS);
            String logChannelId = workflow.getLogChannelId();
            try (ServletOutputStream outputStream = response.getOutputStream();){
                JSONObject json = new JSONObject();
                json.put((Object)"name", (Object)workflowMeta.getName());
                json.put((Object)"id", (Object)serverObjectId);
                json.put((Object)"logChannelId", (Object)logChannelId);
                String jsonString = json.toJSONString();
                outputStream.write(jsonString.getBytes(StandardCharsets.UTF_8));
                outputStream.write("\n".getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            }
            catch (IOException e) {
                this.log.logError("Error running asynchronous web service", (Throwable)e);
            }
            response.setStatus(200);
        }
        catch (IOException | InterruptedException | HopException e) {
            this.log.logError("Error running asynchronous web service", e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            super.doPost(request, response);
        }
        catch (IOException | ServletException e) {
            this.log.logError("Error running asynchronous web service", e);
        }
    }

    public String toString() {
        return "Asynchronous Web Service Run Servlet";
    }

    public String getService() {
        return "/hop/asyncRun (" + this.toString() + ")";
    }

    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

