/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink.committables;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineage;
import org.apache.flink.streaming.runtime.operators.sink.committables.CommitRequestImpl;
import org.apache.flink.streaming.runtime.operators.sink.committables.CommitRequestState;
import org.apache.flink.util.Preconditions;

class SubtaskCommittableManager<CommT> {
    private final Deque<CommitRequestImpl<CommT>> requests;
    private int numExpectedCommittables;
    @Nullable
    private final Long checkpointId;
    private final int subtaskId;
    private int numDrained;
    private int numFailed;

    SubtaskCommittableManager(int numExpectedCommittables, int subtaskId, @Nullable Long checkpointId) {
        this(Collections.emptyList(), numExpectedCommittables, 0, 0, subtaskId, checkpointId);
    }

    SubtaskCommittableManager(Collection<CommitRequestImpl<CommT>> requests, int numExpectedCommittables, int numDrained, int numFailed, int subtaskId, @Nullable Long checkpointId) {
        this.checkpointId = checkpointId;
        this.subtaskId = subtaskId;
        this.numExpectedCommittables = numExpectedCommittables;
        this.requests = new ArrayDeque<CommitRequestImpl<CommT>>((Collection)Preconditions.checkNotNull(requests));
        this.numDrained = numDrained;
        this.numFailed = numFailed;
    }

    void add(CommittableWithLineage<CommT> committable) {
        this.add(committable.getCommittable());
    }

    void add(CommT committable) {
        Preconditions.checkState((this.requests.size() < this.numExpectedCommittables ? 1 : 0) != 0, (Object)"Already received all committables.");
        this.requests.add(new CommitRequestImpl<CommT>(committable));
    }

    boolean hasReceivedAll() {
        return this.getNumCommittables() == this.numExpectedCommittables;
    }

    int getNumCommittables() {
        return this.requests.size() + this.numDrained + this.numFailed;
    }

    int getNumPending() {
        return this.numExpectedCommittables - (this.numDrained + this.numFailed);
    }

    int getNumFailed() {
        return this.numFailed;
    }

    boolean isFinished() {
        return this.getNumPending() == 0;
    }

    Stream<CommitRequestImpl<CommT>> getPendingRequests() {
        return this.requests.stream().filter(c -> !c.isFinished());
    }

    List<CommittableWithLineage<CommT>> drainCommitted() {
        ArrayList<CommittableWithLineage<CommT>> committed = new ArrayList<CommittableWithLineage<CommT>>(this.requests.size());
        Iterator<CommitRequestImpl<CommT>> iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            CommitRequestImpl<CommT> request = iterator.next();
            if (!request.isFinished()) continue;
            if (request.getState() == CommitRequestState.FAILED) {
                ++this.numFailed;
                iterator.remove();
                continue;
            }
            committed.add(new CommittableWithLineage<CommT>(request.getCommittable(), this.checkpointId, this.subtaskId));
            iterator.remove();
        }
        this.numDrained += committed.size();
        return committed;
    }

    int getNumDrained() {
        return this.numDrained;
    }

    int getSubtaskId() {
        return this.subtaskId;
    }

    @Nullable
    @VisibleForTesting
    Long getCheckpointId() {
        return this.checkpointId;
    }

    Deque<CommitRequestImpl<CommT>> getRequests() {
        return this.requests;
    }

    SubtaskCommittableManager<CommT> merge(SubtaskCommittableManager<CommT> other) {
        Preconditions.checkArgument((other.getSubtaskId() == this.getSubtaskId() ? 1 : 0) != 0);
        this.numExpectedCommittables += other.numExpectedCommittables;
        this.requests.addAll(other.requests);
        this.numDrained += other.numDrained;
        this.numFailed += other.numFailed;
        return this;
    }

    SubtaskCommittableManager<CommT> copy() {
        return new SubtaskCommittableManager<CommT>(this.requests.stream().map(CommitRequestImpl::copy).collect(Collectors.toList()), this.numExpectedCommittables, this.numDrained, this.numFailed, this.subtaskId, this.checkpointId);
    }
}

