/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseLargeVariableWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.LargeVarCharReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.LargeVarCharHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableLargeVarCharHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.Text;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public final class LargeVarCharVector
extends BaseLargeVariableWidthVector {
    private final FieldReader reader = new LargeVarCharReaderImpl(this);

    public LargeVarCharVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.LARGEVARCHAR.getType()), allocator);
    }

    public LargeVarCharVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public LargeVarCharVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.LARGEVARCHAR;
    }

    public byte[] get(int index) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            return null;
        }
        long startOffset = this.getStartOffset(index);
        int dataLength = (int)(this.offsetBuffer.getLong((long)(index + 1) * 8L) - startOffset);
        byte[] result = new byte[dataLength];
        this.valueBuffer.getBytes(startOffset, result, 0, dataLength);
        return result;
    }

    @Override
    public Text getObject(int index) {
        byte[] b = this.get(index);
        if (b == null) {
            return null;
        }
        return new Text(b);
    }

    public void get(int index, NullableLargeVarCharHolder holder) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.start = this.getStartOffset(index);
        holder.end = this.offsetBuffer.getLong((long)(index + 1) * 8L);
        holder.buffer = this.valueBuffer;
    }

    public void set(int index, LargeVarCharHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int dataLength = (int)(holder.end - holder.start);
        long startOffset = this.getStartOffset(index);
        this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
        this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        this.lastSet = index;
    }

    public void setSafe(int index, LargeVarCharHolder holder) {
        assert (index >= 0);
        int dataLength = (int)(holder.end - holder.start);
        this.handleSafe(index, dataLength);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        long startOffset = this.getStartOffset(index);
        this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
        this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        this.lastSet = index;
    }

    public void set(int index, NullableLargeVarCharHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        long startOffset = this.getStartOffset(index);
        if (holder.isSet != 0) {
            int dataLength = (int)(holder.end - holder.start);
            this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
            this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        } else {
            this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset);
        }
        this.lastSet = index;
    }

    public void setSafe(int index, NullableLargeVarCharHolder holder) {
        assert (index >= 0);
        if (holder.isSet != 0) {
            int dataLength = (int)(holder.end - holder.start);
            this.handleSafe(index, dataLength);
            this.fillHoles(index);
            long startOffset = this.getStartOffset(index);
            this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
            this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        } else {
            this.fillHoles(index + 1);
        }
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        this.lastSet = index;
    }

    public void set(int index, Text text) {
        this.set(index, text.getBytes(), 0, text.getLength());
    }

    public void setSafe(int index, Text text) {
        this.setSafe(index, text.getBytes(), 0, text.getLength());
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((LargeVarCharVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        LargeVarCharVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new LargeVarCharVector(ref, LargeVarCharVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(LargeVarCharVector to) {
            this.to = to;
        }

        @Override
        public LargeVarCharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            LargeVarCharVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            LargeVarCharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, LargeVarCharVector.this);
        }
    }
}

