/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Internal
public abstract class WindowedValue<@UnknownKeyFor T> {
    private static final @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> GLOBAL_WINDOWS = Collections.singletonList(GlobalWindow.INSTANCE);

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> of(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
        Preconditions.checkArgument((pane != null ? 1 : 0) != 0, (Object)"WindowedValue requires PaneInfo, but it was null");
        Preconditions.checkArgument((windows.size() > 0 ? 1 : 0) != 0, (Object)"WindowedValue requires windows, but there were none");
        if (windows.size() == 1) {
            return WindowedValue.of(value, timestamp, windows.iterator().next(), pane);
        }
        return new TimestampedValueInMultipleWindows<T>(value, timestamp, windows, pane);
    }

    @Deprecated
    static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> createWithoutValidation(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
        if (windows.size() == 1) {
            return WindowedValue.of(value, timestamp, windows.iterator().next(), pane);
        }
        return new TimestampedValueInMultipleWindows<T>(value, timestamp, windows, pane);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> of(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
        Preconditions.checkArgument((pane != null ? 1 : 0) != 0, (Object)"WindowedValue requires PaneInfo, but it was null");
        boolean isGlobal = GlobalWindow.INSTANCE.equals(window);
        if (isGlobal && BoundedWindow.TIMESTAMP_MIN_VALUE.equals((Object)timestamp)) {
            return WindowedValue.valueInGlobalWindow(value, pane);
        }
        if (isGlobal) {
            return new TimestampedValueInGlobalWindow<T>(value, timestamp, pane);
        }
        return new TimestampedValueInSingleWindow<T>(value, timestamp, window, pane);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> valueInGlobalWindow(T value) {
        return new ValueInGlobalWindow<T>(value, PaneInfo.NO_FIRING);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> valueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
        return new ValueInGlobalWindow<T>(value, pane);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> timestampedValueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        if (BoundedWindow.TIMESTAMP_MIN_VALUE.equals((Object)timestamp)) {
            return WindowedValue.valueInGlobalWindow(value);
        }
        return new TimestampedValueInGlobalWindow<T>(value, timestamp, PaneInfo.NO_FIRING);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WindowedValue<T> timestampedValueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo) {
        if (paneInfo.equals(PaneInfo.NO_FIRING)) {
            return WindowedValue.timestampedValueInGlobalWindow(value, timestamp);
        }
        return new TimestampedValueInGlobalWindow<T>(value, timestamp, paneInfo);
    }

    public abstract <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT var1);

    public abstract T getValue();

    public abstract @UnknownKeyFor @NonNull @Initialized Instant getTimestamp();

    public abstract @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows();

    public abstract @UnknownKeyFor @NonNull @Initialized PaneInfo getPane();

    public @UnknownKeyFor @NonNull @Initialized boolean isSingleWindowedValue() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> explodeWindows() {
        if (this.isSingleWindowedValue()) {
            return ImmutableList.of((Object)this);
        }
        ImmutableList.Builder windowedValues = ImmutableList.builder();
        for (BoundedWindow w : this.getWindows()) {
            windowedValues.add(WindowedValue.of(this.getValue(), this.getTimestamp(), w, this.getPane()));
        }
        return windowedValues.build();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (!(other instanceof WindowedValue)) {
            return false;
        }
        WindowedValue that = (WindowedValue)other;
        return this.getTimestamp().isEqual((ReadableInstant)that.getTimestamp()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getWindows(), that.getWindows()) && Objects.equals(this.getPane(), that.getPane());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getValue(), this.getTimestamp().getMillis(), this.getWindows(), this.getPane());
    }

    @SideEffectFree
    public abstract @UnknownKeyFor @NonNull @Initialized String toString();

    public static <T> @UnknownKeyFor @NonNull @Initialized FullWindowedValueCoder<T> getFullCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
        return FullWindowedValueCoder.of(valueCoder, windowCoder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ValueOnlyWindowedValueCoder<T> getValueOnlyCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        return ValueOnlyWindowedValueCoder.of(valueCoder);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<T> getParamWindowedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        return ParamWindowedValueCoder.of(valueCoder);
    }

    public static class ParamWindowedValueCoder<@UnknownKeyFor T>
    extends FullWindowedValueCoder<T> {
        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;
        private transient @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> windowedValuePrototype;
        private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] EMPTY_BYTES = new byte[0];

        public static <T> @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            return new ParamWindowedValueCoder<T>(valueCoder, windowCoder, timestamp, windows, pane);
        }

        public static <T> @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            return ParamWindowedValueCoder.of(valueCoder, windowCoder, BoundedWindow.TIMESTAMP_MIN_VALUE, GLOBAL_WINDOWS, PaneInfo.NO_FIRING);
        }

        public static <T> @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            return ParamWindowedValueCoder.of(valueCoder, GlobalWindow.Coder.INSTANCE);
        }

        ParamWindowedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            super(valueCoder, windowCoder);
            this.windowedValuePrototype = WindowedValue.of(EMPTY_BYTES, timestamp, windows, pane);
        }

        @Override
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValueCoder<NewT> withValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<NewT> valueCoder) {
            return new ParamWindowedValueCoder<NewT>(valueCoder, this.getWindowCoder(), this.getTimestamp(), this.getWindows(), this.getPane());
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return this.windowedValuePrototype.withValue(this.valueCoder.decode(inStream, context));
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            ParamWindowedValueCoder.verifyDeterministic(this, "ParamWindowedValueCoder requires a deterministic valueCoder", this.valueCoder);
        }

        @Override
        public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.valueCoder.registerByteSizeObserver(value.getValue(), observer);
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            return this.windowedValuePrototype.getTimestamp();
        }

        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return this.windowedValuePrototype.getWindows();
        }

        public @UnknownKeyFor @NonNull @Initialized PaneInfo getPane() {
            return this.windowedValuePrototype.getPane();
        }

        public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getPayload(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> from) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            WindowedValue<byte[]> windowedValue = WindowedValue.of(EMPTY_BYTES, from.getTimestamp(), from.getWindows(), from.getPane());
            FullWindowedValueCoder<byte[]> windowedValueCoder = FullWindowedValueCoder.of(ByteArrayCoder.of(), from.getWindowCoder());
            try {
                windowedValueCoder.encode(windowedValue, (OutputStream)baos);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to encode constant members of ParamWindowedValueCoder: ", e);
            }
            return baos.toByteArray();
        }

        public static /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ParamWindowedValueCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromComponents(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> components, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload) {
            Coder<?> windowCoder = components.get(1);
            FullWindowedValueCoder<byte[]> windowedValueCoder = FullWindowedValueCoder.of(ByteArrayCoder.of(), windowCoder);
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(payload);
                Object windowedValue = windowedValueCoder.decode(bais);
                return ParamWindowedValueCoder.of(components.get(0), windowCoder, ((WindowedValue)windowedValue).getTimestamp(), ((WindowedValue)windowedValue).getWindows(), ((WindowedValue)windowedValue).getPane());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to decode constant members from payload for ParamWindowedValueCoder: ", e);
            }
        }

        private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            out.defaultWriteObject();
            out.writeObject(ParamWindowedValueCoder.getPayload(this));
        }

        private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            in.defaultReadObject();
            byte[] payload = (byte[])in.readObject();
            ParamWindowedValueCoder<?> paramWindowedValueCoder = ParamWindowedValueCoder.fromComponents(Arrays.asList(this.valueCoder, this.getWindowCoder()), payload);
            this.windowedValuePrototype = paramWindowedValueCoder.windowedValuePrototype;
        }
    }

    @Deprecated
    public static class ValueOnlyWindowedValueCoder<@UnknownKeyFor T>
    extends WindowedValueCoder<T> {
        public static <T> @UnknownKeyFor @NonNull @Initialized ValueOnlyWindowedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            return new ValueOnlyWindowedValueCoder<T>(valueCoder);
        }

        ValueOnlyWindowedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            super(valueCoder);
        }

        @Override
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValueCoder<NewT> withValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<NewT> valueCoder) {
            return new ValueOnlyWindowedValueCoder<NewT>(valueCoder);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            Object value = this.valueCoder.decode(inStream, context);
            return WindowedValue.valueInGlobalWindow(value);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            ValueOnlyWindowedValueCoder.verifyDeterministic(this, "ValueOnlyWindowedValueCoder requires a deterministic valueCoder", this.valueCoder);
        }

        @Override
        public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.valueCoder.registerByteSizeObserver(value.getValue(), observer);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.singletonList(this.valueCoder);
        }
    }

    public static class FullWindowedValueCoder<@UnknownKeyFor T>
    extends WindowedValueCoder<T> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> windowsCoder;

        public static <T> @UnknownKeyFor @NonNull @Initialized FullWindowedValueCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            return new FullWindowedValueCoder<T>(valueCoder, windowCoder);
        }

        FullWindowedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            super(valueCoder);
            this.windowCoder = (Coder)Preconditions.checkNotNull(windowCoder);
            CollectionCoder<? extends BoundedWindow> collectionCoder = CollectionCoder.of(this.windowCoder);
            this.windowsCoder = collectionCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindowCoder() {
            return this.windowCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>> getWindowsCoder() {
            return this.windowsCoder;
        }

        @Override
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValueCoder<NewT> withValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<NewT> valueCoder) {
            return new FullWindowedValueCoder<NewT>(valueCoder, this.windowCoder);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedElem, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream);
            this.windowsCoder.encode(windowedElem.getWindows(), outStream);
            PaneInfo.PaneInfoCoder.INSTANCE.encode(windowedElem.getPane(), outStream);
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            Instant timestamp = InstantCoder.of().decode(inStream);
            Collection<? extends BoundedWindow> windows = this.windowsCoder.decode(inStream);
            PaneInfo pane = PaneInfo.PaneInfoCoder.INSTANCE.decode(inStream);
            Object value = this.valueCoder.decode(inStream, context);
            return WindowedValue.createWithoutValidation(value, timestamp, windows, pane);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            FullWindowedValueCoder.verifyDeterministic(this, "FullWindowedValueCoder requires a deterministic valueCoder", this.valueCoder);
            FullWindowedValueCoder.verifyDeterministic(this, "FullWindowedValueCoder requires a deterministic windowCoder", this.windowCoder);
        }

        @Override
        public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
            InstantCoder.of().registerByteSizeObserver(value.getTimestamp(), observer);
            this.windowsCoder.registerByteSizeObserver(value.getWindows(), observer);
            PaneInfo.PaneInfoCoder.INSTANCE.registerByteSizeObserver(value.getPane(), observer);
            this.valueCoder.registerByteSizeObserver(value.getValue(), observer);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.singletonList(this.valueCoder);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getComponents() {
            return Arrays.asList(this.valueCoder, this.windowCoder);
        }
    }

    public static abstract class WindowedValueCoder<@UnknownKeyFor T>
    extends StructuredCoder<WindowedValue<T>> {
        final @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder;

        WindowedValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
            this.valueCoder = (Coder)Preconditions.checkNotNull(valueCoder);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<T> getValueCoder() {
            return this.valueCoder;
        }

        public abstract <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValueCoder<NewT> withValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<NewT> var1);
    }

    private static class TimestampedValueInMultipleWindows<@UnknownKeyFor T>
    extends TimestampedWindowedValue<T> {
        private @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows;

        public TimestampedValueInMultipleWindows(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            super(value, timestamp, pane);
            this.windows = (Collection)Preconditions.checkNotNull(windows);
        }

        @Override
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT newValue) {
            return new TimestampedValueInMultipleWindows<NewT>(newValue, this.getTimestamp(), this.windows, this.getPane());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return this.windows;
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o instanceof TimestampedValueInMultipleWindows) {
                TimestampedValueInMultipleWindows that = (TimestampedValueInMultipleWindows)o;
                if (this.getTimestamp().isEqual((ReadableInstant)that.getTimestamp()) && Objects.equals(that.getValue(), this.getValue()) && Objects.equals(that.getPane(), this.getPane())) {
                    this.ensureWindowsAreASet();
                    that.ensureWindowsAreASet();
                    return that.windows.equals(this.windows);
                }
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            this.ensureWindowsAreASet();
            return Objects.hash(this.getValue(), this.getTimestamp().getMillis(), this.getPane(), this.windows);
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("timestamp", (Object)this.getTimestamp()).add("windows", this.windows).add("pane", (Object)this.getPane()).toString();
        }

        private void ensureWindowsAreASet() {
            if (!(this.windows instanceof Set)) {
                this.windows = new LinkedHashSet<BoundedWindow>(this.windows);
            }
        }
    }

    private static class TimestampedValueInSingleWindow<@UnknownKeyFor T>
    extends TimestampedWindowedValue<T>
    implements SingleWindowedValue {
        private final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;

        public TimestampedValueInSingleWindow(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            super(value, timestamp, pane);
            this.window = (BoundedWindow)Preconditions.checkNotNull((Object)window);
        }

        @Override
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT newValue) {
            return new TimestampedValueInSingleWindow<NewT>(newValue, this.getTimestamp(), this.window, this.getPane());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return Collections.singletonList(this.window);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isSingleWindowedValue() {
            return true;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow() {
            return this.window;
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o instanceof TimestampedValueInSingleWindow) {
                TimestampedValueInSingleWindow that = (TimestampedValueInSingleWindow)o;
                return this.getTimestamp().isEqual((ReadableInstant)that.getTimestamp()) && Objects.equals(that.getValue(), this.getValue()) && Objects.equals(that.getPane(), this.getPane()) && Objects.equals(that.window, this.window);
            }
            return super.equals(o);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getValue(), this.getTimestamp().getMillis(), this.getPane(), this.window);
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("timestamp", (Object)this.getTimestamp()).add("window", (Object)this.window).add("pane", (Object)this.getPane()).toString();
        }
    }

    private static class TimestampedValueInGlobalWindow<@UnknownKeyFor T>
    extends TimestampedWindowedValue<T>
    implements SingleWindowedValue {
        public TimestampedValueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            super(value, timestamp, pane);
        }

        @Override
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT newValue) {
            return new TimestampedValueInGlobalWindow<NewT>(newValue, this.getTimestamp(), this.getPane());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return GLOBAL_WINDOWS;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isSingleWindowedValue() {
            return true;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow() {
            return GlobalWindow.INSTANCE;
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o instanceof TimestampedValueInGlobalWindow) {
                TimestampedValueInGlobalWindow that = (TimestampedValueInGlobalWindow)o;
                return this.getTimestamp().isEqual((ReadableInstant)that.getTimestamp()) && Objects.equals(that.getPane(), this.getPane()) && Objects.equals(that.getValue(), this.getValue());
            }
            return super.equals(o);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getValue(), this.getPane(), this.getTimestamp().getMillis());
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("timestamp", (Object)this.getTimestamp()).add("pane", (Object)this.getPane()).toString();
        }
    }

    private static abstract class TimestampedWindowedValue<@UnknownKeyFor T>
    extends SimpleWindowedValue<T> {
        private final @UnknownKeyFor @NonNull @Initialized Instant timestamp;

        public TimestampedWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            super(value, pane);
            this.timestamp = (Instant)Preconditions.checkNotNull((Object)timestamp);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            return this.timestamp;
        }
    }

    private static class ValueInGlobalWindow<@UnknownKeyFor T>
    extends MinTimestampWindowedValue<T>
    implements SingleWindowedValue {
        public ValueInGlobalWindow(T value, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            super(value, pane);
        }

        @Override
        public <NewT> @UnknownKeyFor @NonNull @Initialized WindowedValue<NewT> withValue(NewT newValue) {
            return new ValueInGlobalWindow<NewT>(newValue, this.getPane());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> getWindows() {
            return GLOBAL_WINDOWS;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isSingleWindowedValue() {
            return true;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow() {
            return GlobalWindow.INSTANCE;
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (o instanceof ValueInGlobalWindow) {
                ValueInGlobalWindow that = (ValueInGlobalWindow)o;
                return Objects.equals(that.getPane(), this.getPane()) && Objects.equals(that.getValue(), this.getValue());
            }
            return super.equals(o);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.getValue(), this.getPane());
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.getValue()).add("pane", (Object)this.getPane()).toString();
        }
    }

    private static abstract class MinTimestampWindowedValue<@UnknownKeyFor T>
    extends SimpleWindowedValue<T> {
        public MinTimestampWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            super(value, pane);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getTimestamp() {
            return BoundedWindow.TIMESTAMP_MIN_VALUE;
        }
    }

    private static abstract class SimpleWindowedValue<@UnknownKeyFor T>
    extends WindowedValue<T> {
        private final T value;
        private final @UnknownKeyFor @NonNull @Initialized PaneInfo pane;

        protected SimpleWindowedValue(T value, @UnknownKeyFor @NonNull @Initialized PaneInfo pane) {
            this.value = value;
            this.pane = (PaneInfo)Preconditions.checkNotNull((Object)pane);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PaneInfo getPane() {
            return this.pane;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }

    public static interface SingleWindowedValue {
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow getWindow();
    }
}

