/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.ShardedFile;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CharStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ExplicitShardedFile
implements ShardedFile {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ExplicitShardedFile.class);
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_READ_RETRIES = 4;
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_SLEEP_DURATION = Duration.standardSeconds((long)10L);
    static final @UnknownKeyFor @NonNull @Initialized FluentBackoff BACK_OFF_FACTORY = FluentBackoff.DEFAULT.withInitialBackoff(DEFAULT_SLEEP_DURATION).withMaxRetries(4);
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> files = new ArrayList<MatchResult.Metadata>();

    public ExplicitShardedFile(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> files) throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (String file : files) {
            this.files.add(FileSystems.matchSingleFileSpec(file));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readFilesWithRetries(@UnknownKeyFor @NonNull @Initialized Sleeper sleeper, @UnknownKeyFor @NonNull @Initialized BackOff backOff) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        if (this.files.isEmpty()) {
            return Collections.emptyList();
        }
        IOException lastException = null;
        while (true) {
            try {
                return this.readLines(this.files);
            }
            catch (IOException e) {
                lastException = e;
                LOG.warn("Error in file reading. Ignore and retry.");
                if (BackOffUtils.next(sleeper, backOff)) continue;
                throw new IOException(String.format("Unable to read file(s) after retrying %d times", 4), lastException);
            }
            break;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readFilesWithRetries() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        return this.readFilesWithRetries(Sleeper.DEFAULT, BACK_OFF_FACTORY.backoff());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("explicit sharded file (%s)", Joiner.on((String)", ").join(this.files));
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readLines(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> files) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList allLines = Lists.newArrayList();
        int i = 1;
        for (MatchResult.Metadata file : files) {
            try (Reader reader = Channels.newReader(FileSystems.open(file.resourceId()), StandardCharsets.UTF_8.name());){
                List lines = CharStreams.readLines((Readable)reader);
                allLines.addAll(lines);
                LOG.debug("[{} of {}] Read {} lines from file: {}", new Object[]{i, files.size(), lines.size(), file});
            }
            ++i;
        }
        return allLines;
    }
}

