/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class OffsetRangeTracker
extends RestrictionTracker<OffsetRange, Long>
implements RestrictionTracker.HasProgress {
    protected @UnknownKeyFor @NonNull @Initialized OffsetRange range;
    protected @Nullable @UnknownKeyFor @Initialized Long lastClaimedOffset = null;
    protected @Nullable @UnknownKeyFor @Initialized Long lastAttemptedOffset = null;

    public OffsetRangeTracker(@UnknownKeyFor @NonNull @Initialized OffsetRange range) {
        this.range = (OffsetRange)Preconditions.checkNotNull((Object)range);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized OffsetRange currentRestriction() {
        return this.range;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized OffsetRange> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
        BigDecimal cur = this.lastAttemptedOffset == null ? BigDecimal.valueOf(this.range.getFrom()).subtract(BigDecimal.ONE, MathContext.DECIMAL128) : BigDecimal.valueOf(this.lastAttemptedOffset);
        BigDecimal splitPos = cur.add(BigDecimal.valueOf(this.range.getTo()).subtract(cur, MathContext.DECIMAL128).multiply(BigDecimal.valueOf(fractionOfRemainder), MathContext.DECIMAL128).max(BigDecimal.ONE), MathContext.DECIMAL128);
        long split = splitPos.longValue();
        if (split >= this.range.getTo()) {
            return null;
        }
        OffsetRange res = new OffsetRange(split, this.range.getTo());
        this.range = new OffsetRange(this.range.getFrom(), split);
        return SplitResult.of(this.range, res);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized Long i) {
        Preconditions.checkArgument((this.lastAttemptedOffset == null || i > this.lastAttemptedOffset ? 1 : 0) != 0, (String)"Trying to claim offset %s while last attempted was %s", (Object)i, (Object)this.lastAttemptedOffset);
        Preconditions.checkArgument((i >= this.range.getFrom() ? 1 : 0) != 0, (String)"Trying to claim offset %s before start of the range %s", (Object)i, (Object)this.range);
        this.lastAttemptedOffset = i;
        if (i >= this.range.getTo()) {
            return false;
        }
        this.lastClaimedOffset = i;
        return true;
    }

    @Override
    public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        if (this.range.getFrom() == this.range.getTo()) {
            return;
        }
        Preconditions.checkState((this.lastAttemptedOffset != null ? 1 : 0) != 0, (String)"Last attempted offset should not be null. No work was claimed in non-empty range %s.", (Object)this.range);
        Preconditions.checkState((this.lastAttemptedOffset >= this.range.getTo() - 1L ? 1 : 0) != 0, (String)"Last attempted offset was %s in range %s, claiming work in [%s, %s) was not attempted", (Object)this.lastAttemptedOffset, (Object)this.range, (Object)(this.lastAttemptedOffset + 1L), (Object)this.range.getTo());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.BOUNDED;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("range", (Object)this.range).add("lastClaimedOffset", (Object)this.lastClaimedOffset).add("lastAttemptedOffset", (Object)this.lastAttemptedOffset).toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
        if (this.lastAttemptedOffset == null) {
            return RestrictionTracker.Progress.from(0.0, BigDecimal.valueOf(this.range.getTo()).subtract(BigDecimal.valueOf(this.range.getFrom()), MathContext.DECIMAL128).doubleValue());
        }
        BigDecimal workRemaining = BigDecimal.valueOf(this.range.getTo()).subtract(BigDecimal.valueOf(this.lastAttemptedOffset), MathContext.DECIMAL128).max(BigDecimal.ZERO);
        BigDecimal totalWork = BigDecimal.valueOf(this.range.getTo()).subtract(BigDecimal.valueOf(this.range.getFrom()), MathContext.DECIMAL128);
        return RestrictionTracker.Progress.from(totalWork.subtract(workRemaining, MathContext.DECIMAL128).doubleValue(), workRemaining.doubleValue());
    }
}

