/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.AutoValue_AddFields_Inner_AddFieldsInformation;
import org.apache.beam.sdk.schemas.transforms.AutoValue_AddFields_Inner_NewField;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimaps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AddFields {
    public static <T> @UnknownKeyFor @NonNull @Initialized Inner<T> create() {
        return new Inner();
    }

    public static class Inner<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Row>> {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewField> newFields;

        private Inner() {
            this.newFields = Collections.emptyList();
        }

        private Inner(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewField> newFields) {
            this.newFields = newFields;
        }

        public @UnknownKeyFor @NonNull @Initialized Inner<T> field(@UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
            return this.field(fieldName, fieldType.withNullable(true), null);
        }

        public @UnknownKeyFor @NonNull @Initialized Inner<T> field(@UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized Object defaultValue) {
            if (defaultValue == null) {
                Preconditions.checkArgument((boolean)fieldType.getNullable());
            }
            FieldAccessDescriptor descriptor = FieldAccessDescriptor.withFieldNames(fieldName);
            Preconditions.checkArgument((boolean)descriptor.referencesSingleField());
            ImmutableList fields = ImmutableList.builder().addAll(this.newFields).add((Object)NewField.of(descriptor, fieldType, defaultValue)).build();
            return new Inner<T>((List<NewField>)fields);
        }

        private static @UnknownKeyFor @NonNull @Initialized AddFieldsInformation getAddFieldsInformation(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized NewField> fieldsToAdd) {
            List newTopLevelFields = fieldsToAdd.stream().filter(n -> !n.getDescriptor().getFieldsAccessed().isEmpty()).collect(Collectors.toList());
            List newNestedFields = fieldsToAdd.stream().filter(n -> !n.getDescriptor().getNestedFieldsAccessed().isEmpty()).collect(Collectors.toList());
            ImmutableListMultimap newNestedFieldsMap = Multimaps.index(newNestedFields, NewField::getName);
            HashMap resolvedNestedNewValues = Maps.newHashMap();
            Schema.Builder builder = Schema.builder();
            for (int i = 0; i < inputSchema.getFieldCount(); ++i) {
                Object field = inputSchema.getField(i);
                Collection nestedFields = newNestedFieldsMap.get((Object)((Schema.Field)field).getName());
                if (!nestedFields.isEmpty()) {
                    nestedFields = nestedFields.stream().map(NewField::descend).collect(Collectors.toList());
                    AddFieldsInformation nestedInformation = Inner.getAddFieldsInformation(((Schema.Field)field).getType(), (Collection<NewField>)nestedFields);
                    field = ((Schema.Field)field).withType(nestedInformation.getOutputFieldType());
                    resolvedNestedNewValues.put(i, nestedInformation);
                }
                builder.addField((Schema.Field)field);
            }
            ArrayList<Object> newValuesThisLevel = new ArrayList<Object>(newTopLevelFields.size());
            for (NewField newField : newTopLevelFields) {
                builder.addField(newField.getName(), newField.getFieldType());
                newValuesThisLevel.add(newField.getDefaultValue());
            }
            for (Map.Entry newNested : newNestedFieldsMap.asMap().entrySet()) {
                String fieldName = (String)newNested.getKey();
                FieldAccessDescriptor.FieldDescriptor fieldDescriptor = (FieldAccessDescriptor.FieldDescriptor)Iterables.getOnlyElement((Iterable)((Collection)newNested.getValue()).stream().map(NewField::getFieldDescriptor).distinct().collect(Collectors.toList()));
                Schema.FieldType fieldType = Schema.FieldType.row(Schema.of(new Schema.Field[0])).withNullable(true);
                for (FieldAccessDescriptor.FieldDescriptor.Qualifier qualifier : fieldDescriptor.getQualifiers()) {
                    Preconditions.checkArgument((!qualifier.getKind().equals((Object)FieldAccessDescriptor.FieldDescriptor.Qualifier.Kind.MAP) ? 1 : 0) != 0, (Object)"Map qualifiers not supported here");
                    fieldType = Schema.FieldType.array(fieldType).withNullable(true);
                }
                if (inputSchema.hasField(fieldName)) continue;
                Collection nestedNewFields = ((Collection)newNested.getValue()).stream().map(NewField::descend).collect(Collectors.toList());
                AddFieldsInformation addFieldsInformation = Inner.getAddFieldsInformation(fieldType, (Collection<NewField>)nestedNewFields);
                builder.addField(fieldName, addFieldsInformation.getOutputFieldType());
                resolvedNestedNewValues.put(builder.getLastFieldId(), addFieldsInformation);
            }
            Schema schema = builder.build();
            ArrayList<Object> nestedNewValueList = new ArrayList<Object>(Collections.nCopies(schema.getFieldCount(), null));
            for (Map.Entry entry : resolvedNestedNewValues.entrySet()) {
                nestedNewValueList.set((Integer)entry.getKey(), ((AddFieldsInformation)entry.getValue()));
            }
            return AddFieldsInformation.of(Schema.FieldType.row(schema), newValuesThisLevel, nestedNewValueList);
        }

        private static @UnknownKeyFor @NonNull @Initialized AddFieldsInformation getAddFieldsInformation(@UnknownKeyFor @NonNull @Initialized Schema.FieldType inputFieldType, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized NewField> nestedFields) {
            Schema.FieldType fieldType;
            AddFieldsInformation addFieldsInformation;
            switch (inputFieldType.getTypeName()) {
                case ROW: {
                    addFieldsInformation = Inner.getAddFieldsInformation(inputFieldType.getRowSchema(), nestedFields);
                    fieldType = addFieldsInformation.getOutputFieldType();
                    break;
                }
                case ARRAY: {
                    addFieldsInformation = Inner.getAddFieldsInformation(inputFieldType.getCollectionElementType(), nestedFields);
                    fieldType = Schema.FieldType.array(addFieldsInformation.getOutputFieldType());
                    break;
                }
                case ITERABLE: {
                    addFieldsInformation = Inner.getAddFieldsInformation(inputFieldType.getCollectionElementType(), nestedFields);
                    fieldType = Schema.FieldType.iterable(addFieldsInformation.getOutputFieldType());
                    break;
                }
                case MAP: {
                    addFieldsInformation = Inner.getAddFieldsInformation(inputFieldType.getMapValueType(), nestedFields);
                    fieldType = Schema.FieldType.map(inputFieldType.getMapKeyType(), addFieldsInformation.getOutputFieldType());
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot select a subfield of a non-composite type.");
                }
            }
            fieldType = fieldType.withNullable(inputFieldType.getNullable());
            return addFieldsInformation.toBuilder().setOutputFieldType(fieldType).build();
        }

        private static @UnknownKeyFor @NonNull @Initialized Row fillNewFields(@UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized AddFieldsInformation addFieldsInformation) {
            int i;
            Schema outputSchema = (Schema)Preconditions.checkNotNull((Object)addFieldsInformation.getOutputFieldType().getRowSchema());
            ArrayList newValues = Lists.newArrayListWithCapacity((int)outputSchema.getFieldCount());
            for (i = 0; i < row.getFieldCount(); ++i) {
                AddFieldsInformation nested = addFieldsInformation.getNestedNewValues().get(i);
                if (nested != null) {
                    Object newValue = Inner.fillNewFields(row.getValue(i), nested.getOutputFieldType(), nested);
                    newValues.add(newValue);
                    continue;
                }
                newValues.add(row.getValue(i));
            }
            newValues.addAll(addFieldsInformation.getDefaultValues());
            for (i = newValues.size(); i < addFieldsInformation.getNestedNewValues().size(); ++i) {
                AddFieldsInformation newNestedField = addFieldsInformation.getNestedNewValues().get(i);
                if (newNestedField == null) continue;
                newValues.add(Inner.fillNewFields(null, newNestedField.getOutputFieldType(), newNestedField));
            }
            return Row.withSchema(outputSchema).attachValues(newValues);
        }

        private static @UnknownKeyFor @NonNull @Initialized Object fillNewFields(@UnknownKeyFor @NonNull @Initialized Object original, @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized AddFieldsInformation addFieldsInformation) {
            switch (fieldType.getTypeName()) {
                case ROW: {
                    if (original == null) {
                        original = Row.withSchema(fieldType.getRowSchema()).build();
                    }
                    return Inner.fillNewFields((Row)original, addFieldsInformation);
                }
                case ARRAY: 
                case ITERABLE: {
                    if (original == null) {
                        return Collections.emptyList();
                    }
                    Iterable iterable = (Iterable)original;
                    ArrayList<Object> filledList = new ArrayList<Object>(Iterables.size((Iterable)iterable));
                    Schema.FieldType elementType = fieldType.getCollectionElementType();
                    AddFieldsInformation elementAddFieldInformation = addFieldsInformation.toBuilder().setOutputFieldType(elementType).build();
                    for (Object element : iterable) {
                        filledList.add(Inner.fillNewFields(element, elementType, elementAddFieldInformation));
                    }
                    return filledList;
                }
                case MAP: {
                    if (original == null) {
                        return Collections.emptyMap();
                    }
                    Map originalMap = (Map)original;
                    HashMap filledMap = Maps.newHashMapWithExpectedSize((int)originalMap.size());
                    Schema.FieldType mapValueType = fieldType.getMapValueType();
                    AddFieldsInformation mapValueAddFieldInformation = addFieldsInformation.toBuilder().setOutputFieldType(mapValueType).build();
                    for (Map.Entry entry : originalMap.entrySet()) {
                        filledMap.put(entry.getKey(), Inner.fillNewFields(entry.getValue(), mapValueType, mapValueAddFieldInformation));
                    }
                    return filledMap;
                }
            }
            throw new RuntimeException("Unexpected field type");
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            final AddFieldsInformation addFieldsInformation = Inner.getAddFieldsInformation(input.getSchema(), this.newFields);
            Schema outputSchema = (Schema)Preconditions.checkNotNull((Object)addFieldsInformation.getOutputFieldType().getRowSchema());
            return ((PCollection)input.apply(ParDo.of(new DoFn<T, Row>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
                    o.output(Inner.fillNewFields(row, addFieldsInformation));
                }
            }))).setRowSchema(outputSchema);
        }

        @AutoValue
        static abstract class AddFieldsInformation
        implements Serializable {
            AddFieldsInformation() {
            }

            abstract @Nullable @UnknownKeyFor @Initialized Schema.FieldType getOutputFieldType();

            abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> getDefaultValues();

            abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AddFieldsInformation> getNestedNewValues();

            abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

            static @UnknownKeyFor @NonNull @Initialized AddFieldsInformation of(@UnknownKeyFor @NonNull @Initialized Schema.FieldType outputFieldType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> defaultValues, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AddFieldsInformation> nestedNewValues) {
                return new AutoValue_AddFields_Inner_AddFieldsInformation.Builder().setOutputFieldType(outputFieldType).setDefaultValues(defaultValues).setNestedNewValues(nestedNewValues).build();
            }

            @AutoValue.Builder
            static abstract class Builder {
                Builder() {
                }

                abstract @UnknownKeyFor @NonNull @Initialized Builder setOutputFieldType(@UnknownKeyFor @NonNull @Initialized Schema.FieldType var1);

                abstract @UnknownKeyFor @NonNull @Initialized Builder setDefaultValues(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> var1);

                abstract @UnknownKeyFor @NonNull @Initialized Builder setNestedNewValues(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AddFieldsInformation> var1);

                abstract @UnknownKeyFor @NonNull @Initialized AddFieldsInformation build();
            }
        }

        @AutoValue
        static abstract class NewField
        implements Serializable {
            NewField() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized String getName();

            abstract @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor getDescriptor();

            abstract @UnknownKeyFor @NonNull @Initialized Schema.FieldType getFieldType();

            abstract @Nullable @UnknownKeyFor @Initialized Object getDefaultValue();

            abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

            static @UnknownKeyFor @NonNull @Initialized NewField of(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized Object defaultValue) {
                return new AutoValue_AddFields_Inner_NewField.Builder().setName(NewField.getName(fieldAccessDescriptor)).setDescriptor(fieldAccessDescriptor).setFieldType(fieldType).setDefaultValue(defaultValue).build();
            }

            @UnknownKeyFor @NonNull @Initialized NewField descend() {
                FieldAccessDescriptor descriptor = (FieldAccessDescriptor)Iterables.getOnlyElement(this.getDescriptor().getNestedFieldsAccessed().values());
                return this.toBuilder().setDescriptor(descriptor).setName(NewField.getName(descriptor)).build();
            }

            static @UnknownKeyFor @NonNull @Initialized String getName(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor descriptor) {
                if (!descriptor.getFieldsAccessed().isEmpty()) {
                    return (String)Iterables.getOnlyElement(descriptor.fieldNamesAccessed());
                }
                return (String)Iterables.getOnlyElement(descriptor.nestedFieldsByName().keySet());
            }

            @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor.FieldDescriptor getFieldDescriptor() {
                if (!this.getDescriptor().getFieldsAccessed().isEmpty()) {
                    return (FieldAccessDescriptor.FieldDescriptor)Iterables.getOnlyElement(this.getDescriptor().getFieldsAccessed());
                }
                return (FieldAccessDescriptor.FieldDescriptor)Iterables.getOnlyElement(this.getDescriptor().getNestedFieldsAccessed().keySet());
            }

            @AutoValue.Builder
            static abstract class Builder {
                Builder() {
                }

                abstract @UnknownKeyFor @NonNull @Initialized Builder setName(@UnknownKeyFor @NonNull @Initialized String var1);

                abstract @UnknownKeyFor @NonNull @Initialized Builder setDescriptor(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor var1);

                abstract @UnknownKeyFor @NonNull @Initialized Builder setFieldType(@UnknownKeyFor @NonNull @Initialized Schema.FieldType var1);

                abstract @UnknownKeyFor @NonNull @Initialized Builder setDefaultValue(@Nullable @UnknownKeyFor @Initialized Object var1);

                abstract @UnknownKeyFor @NonNull @Initialized NewField build();
            }
        }
    }
}

