/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class PubsubMessages {
    private PubsubMessages() {
    }

    public static @UnknownKeyFor @NonNull @Initialized com.google.pubsub.v1.PubsubMessage toProto(@UnknownKeyFor @NonNull @Initialized PubsubMessage input) {
        String orderingKey;
        String messageId;
        Map<String, String> attributes = input.getAttributeMap();
        PubsubMessage.Builder message = com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])input.getPayload()));
        if (attributes != null) {
            message.putAllAttributes(attributes);
        }
        if ((messageId = input.getMessageId()) != null) {
            message.setMessageId(messageId);
        }
        if ((orderingKey = input.getOrderingKey()) != null) {
            message.setOrderingKey(orderingKey);
        }
        return message.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized PubsubMessage fromProto(@UnknownKeyFor @NonNull @Initialized com.google.pubsub.v1.PubsubMessage input) {
        return new PubsubMessage(input.getData().toByteArray(), input.getAttributesMap(), input.getMessageId(), input.getOrderingKey());
    }

    public static class DeserializeBytesIntoPubsubMessagePayloadOnly
    implements SerializableFunction<byte[], PubsubMessage> {
        public @UnknownKeyFor @NonNull @Initialized PubsubMessage apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value) {
            return new PubsubMessage(value, (Map<String, String>)ImmutableMap.of());
        }
    }

    public static class ParsePubsubMessageProtoAsPayload
    implements SerializableFunction<byte[], PubsubMessage> {
        public @UnknownKeyFor @NonNull @Initialized PubsubMessage apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
            try {
                com.google.pubsub.v1.PubsubMessage message = com.google.pubsub.v1.PubsubMessage.parseFrom((byte[])input);
                return PubsubMessages.fromProto(message);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Could not decode Pubsub message", e);
            }
        }
    }

    public static class ParsePayloadAsPubsubMessageProto
    implements SerializableFunction<PubsubMessage, byte[]> {
        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized PubsubMessage input) {
            return PubsubMessages.toProto(input).toByteArray();
        }
    }
}

