/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dofn;

import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.DetectNewPartitionsState;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.InitialPipelineState;
import org.apache.beam.sdk.transforms.DoFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class InitializeDoFn
extends DoFn<byte[], InitialPipelineState>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1868189906451252363L;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(InitializeDoFn.class);
    private final @UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory;
    private final @UnknownKeyFor @NonNull @Initialized String metadataTableAppProfileId;
    private @UnknownKeyFor @NonNull @Initialized Instant startTime;
    private final @UnknownKeyFor @NonNull @Initialized BigtableIO.ExistingPipelineOptions existingPipelineOptions;

    public InitializeDoFn(@UnknownKeyFor @NonNull @Initialized DaoFactory daoFactory, @UnknownKeyFor @NonNull @Initialized String metadataTableAppProfileId, @UnknownKeyFor @NonNull @Initialized Instant startTime, @UnknownKeyFor @NonNull @Initialized BigtableIO.ExistingPipelineOptions existingPipelineOptions) {
        this.daoFactory = daoFactory;
        this.metadataTableAppProfileId = metadataTableAppProfileId;
        this.startTime = startTime;
        this.existingPipelineOptions = existingPipelineOptions;
    }

    @DoFn.ProcessElement
    public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized InitialPipelineState> receiver) throws @UnknownKeyFor @NonNull @Initialized IOException {
        LOG.info(this.daoFactory.getStreamTableDebugString());
        LOG.info(this.daoFactory.getMetadataTableDebugString());
        LOG.info("ChangeStreamName: " + this.daoFactory.getChangeStreamName());
        if (!this.daoFactory.getMetadataTableAdminDao().isAppProfileSingleClusterAndTransactional(this.metadataTableAppProfileId)) {
            LOG.error("App profile id '" + this.metadataTableAppProfileId + "' provided to access metadata table needs to use single-cluster routing policy and allow single-row transactions.");
            return;
        }
        if (this.daoFactory.getMetadataTableAdminDao().createMetadataTable()) {
            LOG.info("Created metadata table: " + this.daoFactory.getMetadataTableAdminDao().getTableId());
        } else {
            LOG.info("Reusing existing metadata table: " + this.daoFactory.getMetadataTableAdminDao().getTableId());
        }
        boolean resume = false;
        DetectNewPartitionsState detectNewPartitionsState = this.daoFactory.getMetadataTableDao().readDetectNewPartitionsState();
        switch (this.existingPipelineOptions) {
            case NEW: {
                LOG.info("Cleaning up an old pipeline with the same change stream name to start a new pipeline with the same name.");
                this.daoFactory.getMetadataTableAdminDao().cleanUpPrefix();
                break;
            }
            case RESUME_OR_NEW: {
                if (detectNewPartitionsState != null) {
                    resume = true;
                    this.startTime = detectNewPartitionsState.getWatermark();
                    LOG.info("Resuming from previous pipeline with low watermark of {}", (Object)this.startTime);
                    break;
                }
                LOG.info("Attempted to resume, but previous watermark does not exist, starting at {}", (Object)this.startTime);
                this.daoFactory.getMetadataTableAdminDao().cleanUpPrefix();
                break;
            }
            case RESUME_OR_FAIL: {
                if (detectNewPartitionsState != null) {
                    resume = true;
                    this.startTime = detectNewPartitionsState.getWatermark();
                    LOG.info("Resuming from previous pipeline with low watermark of {}", (Object)this.startTime);
                    break;
                }
                LOG.error("Previous pipeline with the same change stream name doesn't exist, stopping");
                return;
            }
            case FAIL_IF_EXISTS: {
                if (detectNewPartitionsState != null) {
                    LOG.error("A previous pipeline exists with the same change stream name and existingPipelineOption is set to FAIL_IF_EXISTS.");
                    return;
                }
                this.daoFactory.getMetadataTableAdminDao().cleanUpPrefix();
                break;
            }
            case SKIP_CLEANUP: {
                if (detectNewPartitionsState == null) break;
                LOG.error("A previous pipeline exists with the same change stream name and existingPipelineOption is set to SKIP_CLEANUP. This option should only be used in tests.");
                return;
            }
            default: {
                LOG.error("Unexpected existingPipelineOptions option.");
                return;
            }
        }
        this.daoFactory.getMetadataTableDao().writeDetectNewPartitionVersion();
        receiver.output((Object)new InitialPipelineState(this.startTime, resume));
    }
}

