/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_TableSchemaUpdateUtils_Result;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TableSchemaUpdateUtils {
    public static @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TableSchema> getUpdatedSchema(@UnknownKeyFor @NonNull @Initialized TableSchema oldSchema, @UnknownKeyFor @NonNull @Initialized TableSchema newSchema) {
        Result updatedFields = TableSchemaUpdateUtils.getUpdatedSchema(oldSchema.getFieldsList(), newSchema.getFieldsList());
        if (updatedFields.isEquivalent()) {
            return Optional.empty();
        }
        return updatedFields.getFields().map(tableFieldSchemas -> TableSchema.newBuilder().addAllFields((Iterable)tableFieldSchemas).build());
    }

    private static @UnknownKeyFor @NonNull @Initialized Result getUpdatedSchema(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> oldSchema, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> newSchema) {
        if (newSchema == null) {
            return Result.empty();
        }
        if (oldSchema == null) {
            return Result.of(newSchema, false);
        }
        Map<String, TableFieldSchema> newSchemaMap = newSchema.stream().collect(Collectors.toMap(TableFieldSchema::getName, x -> x));
        HashSet fieldNamesPopulated = Sets.newHashSet();
        ArrayList updatedSchema = Lists.newArrayList();
        boolean isEquivalent = oldSchema.size() == newSchema.size();
        for (TableFieldSchema tableFieldSchema : oldSchema) {
            TableFieldSchema newTableFieldSchema = newSchemaMap.get(tableFieldSchema.getName());
            if (newTableFieldSchema == null) {
                return Result.empty();
            }
            TableFieldSchema.Builder updatedTableFieldSchema = newTableFieldSchema.toBuilder();
            updatedTableFieldSchema.clearFields();
            if (tableFieldSchema.getType().equals((Object)TableFieldSchema.Type.STRUCT)) {
                Result updatedTableFields = TableSchemaUpdateUtils.getUpdatedSchema(tableFieldSchema.getFieldsList(), newTableFieldSchema.getFieldsList());
                if (!updatedTableFields.getFields().isPresent()) {
                    return updatedTableFields;
                }
                updatedTableFieldSchema.addAllFields((Iterable)updatedTableFields.getFields().get());
                isEquivalent = isEquivalent && updatedTableFields.isEquivalent();
                isEquivalent = isEquivalent && tableFieldSchema.toBuilder().clearFields().build().equals((Object)newTableFieldSchema.toBuilder().clearFields().build());
            } else {
                isEquivalent = isEquivalent && tableFieldSchema.equals((Object)newTableFieldSchema);
            }
            updatedSchema.add(updatedTableFieldSchema.build());
            fieldNamesPopulated.add(updatedTableFieldSchema.getName());
        }
        newSchema.stream().filter(f -> !fieldNamesPopulated.contains(f.getName())).forEach(updatedSchema::add);
        return Result.of(updatedSchema, isEquivalent);
    }

    @AutoValue
    static abstract class Result {
        Result() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema>> getFields();

        abstract @UnknownKeyFor @NonNull @Initialized boolean isEquivalent();

        static @UnknownKeyFor @NonNull @Initialized Result of(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fields, @UnknownKeyFor @NonNull @Initialized boolean isEquivalent) {
            return new AutoValue_TableSchemaUpdateUtils_Result(Optional.of(fields), isEquivalent);
        }

        static @UnknownKeyFor @NonNull @Initialized Result empty() {
            return new AutoValue_TableSchemaUpdateUtils_Result(Optional.empty(), false);
        }
    }
}

