/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.Status;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.AppendClientInfo;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.RetryManager;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiFinalizeWritesDoFn;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritesShardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.TableSchemaUpdateUtils;
import org.apache.beam.sdk.io.gcp.bigquery.TwoLevelMessageConverterCache;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageApiWriteUnshardedRecords<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<DestinationT, StorageApiWritePayload>>, PCollectionTuple> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(StorageApiWriteUnshardedRecords.class);
    private final @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsTag;
    private final @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> successfulRowsTag;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> finalizeTag = new TupleTag("finalizeTag");
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized TableRow> successfulRowsCoder;
    private final @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;
    private static final @UnknownKeyFor @NonNull @Initialized ExecutorService closeWriterExecutor = Executors.newCachedThreadPool();
    private static final @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AppendClientInfo> APPEND_CLIENTS = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).removalListener(removal -> {
        LOG.info("Expiring append client for " + (String)removal.getKey());
        @Nullable AppendClientInfo appendClientInfo = (AppendClientInfo)removal.getValue();
        if (appendClientInfo != null) {
            appendClientInfo.close();
        }
    }).build();

    static void clearCache() {
        APPEND_CLIENTS.invalidateAll();
    }

    private static void runAsyncIgnoreFailure(@UnknownKeyFor @NonNull @Initialized ExecutorService executor, @UnknownKeyFor @NonNull @Initialized ThrowingRunnable task) {
        executor.submit(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                String msg = e.toString() + "\n" + Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
                System.err.println("Exception happened while executing async task. Ignoring: " + msg);
            }
        });
    }

    public StorageApiWriteUnshardedRecords(@UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsTag, @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> successfulRowsTag, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized TableRow> successfulRowsCoder, @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues) {
        this.dynamicDestinations = dynamicDestinations;
        this.bqServices = bqServices;
        this.failedRowsTag = failedRowsTag;
        this.successfulRowsTag = successfulRowsTag;
        this.failedRowsCoder = failedRowsCoder;
        this.successfulRowsCoder = successfulRowsCoder;
        this.autoUpdateSchema = autoUpdateSchema;
        this.ignoreUnknownValues = ignoreUnknownValues;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> input) {
        String operationName = input.getName() + "/" + this.getName();
        BigQueryOptions options = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
        Preconditions.checkArgument((options.getUseStorageApiConnectionPool() == false ? 1 : 0) != 0, (Object)"useStorageApiConnectionPool only supported when using STORAGE_API_AT_LEAST_ONCE");
        TupleTagList tupleTagList = TupleTagList.of(this.failedRowsTag);
        if (this.successfulRowsTag != null) {
            tupleTagList = tupleTagList.and(this.successfulRowsTag);
        }
        PCollectionTuple writeResults = (PCollectionTuple)input.apply("Write Records", (PTransform)ParDo.of(new WriteRecordsDoFn<DestinationT, ElementT>(operationName, this.dynamicDestinations, this.bqServices, false, options.getStorageApiAppendThresholdBytes(), options.getStorageApiAppendThresholdRecordCount(), options.getNumStorageWriteApiStreamAppendClients(), this.finalizeTag, this.failedRowsTag, this.successfulRowsTag, this.autoUpdateSchema, this.ignoreUnknownValues)).withOutputTags(this.finalizeTag, tupleTagList).withSideInputs(this.dynamicDestinations.getSideInputs()));
        ((PCollection)writeResults.get(this.finalizeTag).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of())).apply("Reshuffle", (PTransform)Reshuffle.of())).apply("Finalize writes", (PTransform)ParDo.of((DoFn)new StorageApiFinalizeWritesDoFn(this.bqServices)));
        writeResults.get(this.failedRowsTag).setCoder(this.failedRowsCoder);
        if (this.successfulRowsTag != null) {
            writeResults.get(this.successfulRowsTag).setCoder(this.successfulRowsCoder);
        }
        return writeResults;
    }

    static class WriteRecordsDoFn<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
    extends DoFn<KV<DestinationT, StorageApiWritePayload>, KV<String, String>> {
        private final @UnknownKeyFor @NonNull @Initialized Counter forcedFlushes = Metrics.counter(WriteRecordsDoFn.class, (String)"forcedFlushes");
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> finalizeTag;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsTag;
        private final @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> successfulRowsTag;
        private final @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema;
        private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;
        private @Nullable @UnknownKeyFor @Initialized Map<DestinationT, @UnknownKeyFor @NonNull @Initialized WriteRecordsDoFn. @UnknownKeyFor @NonNull @Initialized DestinationState> destinations = Maps.newHashMap();
        private final @UnknownKeyFor @NonNull @Initialized TwoLevelMessageConverterCache<DestinationT, ElementT> messageConverters;
        private transient @Nullable @UnknownKeyFor @Initialized BigQueryServices.DatasetService maybeDatasetService;
        private @UnknownKeyFor @NonNull @Initialized int numPendingRecords = 0;
        private @UnknownKeyFor @NonNull @Initialized int numPendingRecordBytes = 0;
        private final @UnknownKeyFor @NonNull @Initialized int flushThresholdBytes;
        private final @UnknownKeyFor @NonNull @Initialized int flushThresholdCount;
        private final @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
        private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
        private final @UnknownKeyFor @NonNull @Initialized boolean useDefaultStream;
        private @UnknownKeyFor @NonNull @Initialized int streamAppendClientCount;

        WriteRecordsDoFn(@UnknownKeyFor @NonNull @Initialized String operationName, @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized boolean useDefaultStream, @UnknownKeyFor @NonNull @Initialized int flushThresholdBytes, @UnknownKeyFor @NonNull @Initialized int flushThresholdCount, @UnknownKeyFor @NonNull @Initialized int streamAppendClientCount, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> finalizeTag, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsTag, @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> successfulRowsTag, @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues) {
            this.messageConverters = new TwoLevelMessageConverterCache(operationName);
            this.dynamicDestinations = dynamicDestinations;
            this.bqServices = bqServices;
            this.useDefaultStream = useDefaultStream;
            this.flushThresholdBytes = flushThresholdBytes;
            this.flushThresholdCount = flushThresholdCount;
            this.streamAppendClientCount = streamAppendClientCount;
            this.finalizeTag = finalizeTag;
            this.failedRowsTag = failedRowsTag;
            this.successfulRowsTag = successfulRowsTag;
            this.autoUpdateSchema = autoUpdateSchema;
            this.ignoreUnknownValues = ignoreUnknownValues;
        }

        @UnknownKeyFor @NonNull @Initialized boolean shouldFlush() {
            return this.numPendingRecords > this.flushThresholdCount || this.numPendingRecordBytes > this.flushThresholdBytes;
        }

        void flushIfNecessary(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsReceiver, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable @UnknownKeyFor @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized TableRow> successfulRowsReceiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (this.shouldFlush()) {
                this.forcedFlushes.inc();
                this.flushAll(failedRowsReceiver, successfulRowsReceiver);
            }
        }

        void flushAll(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsReceiver, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable @UnknownKeyFor @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized TableRow> successfulRowsReceiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
            ArrayList retryManagers = Lists.newArrayListWithCapacity((int)((Map)org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.destinations)).size());
            long numRowsWritten = 0L;
            for (DestinationState destinationState : ((Map)org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.destinations)).values()) {
                RetryManager<AppendRowsResponse, AppendRowsContext> retryManager = new RetryManager<AppendRowsResponse, AppendRowsContext>(Duration.standardSeconds((long)1L), Duration.standardSeconds((long)10L), 1000);
                retryManagers.add(retryManager);
                numRowsWritten += destinationState.flush(retryManager, failedRowsReceiver, successfulRowsReceiver);
                retryManager.run(false);
            }
            if (numRowsWritten > 0L) {
                for (RetryManager retryManager : retryManagers) {
                    retryManager.await();
                }
            }
            for (DestinationState destinationState : ((Map)org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.destinations)).values()) {
                destinationState.postFlush();
            }
            this.numPendingRecords = 0;
            this.numPendingRecordBytes = 0;
        }

        private @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService initializeDatasetService(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            if (this.maybeDatasetService == null) {
                this.maybeDatasetService = this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
            }
            return this.maybeDatasetService;
        }

        @DoFn.StartBundle
        public void startBundle() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.destinations = Maps.newHashMap();
            this.numPendingRecords = 0;
            this.numPendingRecordBytes = 0;
        }

        @UnknownKeyFor @NonNull @Initialized WriteRecordsDoFn. @UnknownKeyFor @NonNull @Initialized DestinationState createDestinationState(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, DestinationT destination, @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService, @UnknownKeyFor @NonNull @Initialized BigQueryOptions bigQueryOptions) {
            TableDestination tableDestination1 = this.dynamicDestinations.getTable(destination);
            Preconditions.checkArgument((tableDestination1 != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may not return null, but %s returned null for destination %s", this.dynamicDestinations, destination);
            try {
                StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter = this.messageConverters.get(destination, this.dynamicDestinations, datasetService);
                return new DestinationState(tableDestination1.getTableUrn(bigQueryOptions), messageConverter, datasetService, this.useDefaultStream, this.streamAppendClientCount, bigQueryOptions.getUseStorageApiConnectionPool(), bigQueryOptions.getStorageWriteApiMaxRequestSize());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @DoFn.ProcessElement
        public void process(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized org.joda.time.Instant elementTs, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver o) throws @UnknownKeyFor @NonNull @Initialized Exception {
            BigQueryServices.DatasetService initializedDatasetService = this.initializeDatasetService(pipelineOptions);
            this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
            org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.destinations);
            DestinationState state = this.destinations.computeIfAbsent(element.getKey(), k -> this.createDestinationState(c, k, initializedDatasetService, (BigQueryOptions)pipelineOptions.as(BigQueryOptions.class)));
            DoFn.OutputReceiver failedRowsReceiver = o.get(this.failedRowsTag);
            DoFn.OutputReceiver successfulRowsReceiver = this.successfulRowsTag != null ? o.get(this.successfulRowsTag) : null;
            this.flushIfNecessary((DoFn.OutputReceiver<BigQueryStorageApiInsertError>)failedRowsReceiver, (DoFn.OutputReceiver<TableRow>)successfulRowsReceiver);
            state.addMessage((StorageApiWritePayload)element.getValue(), elementTs, (DoFn.OutputReceiver<BigQueryStorageApiInsertError>)failedRowsReceiver);
            ++this.numPendingRecords;
            this.numPendingRecordBytes += ((StorageApiWritePayload)element.getValue()).getPayload().length;
        }

        @DoFn.FinishBundle
        public void finishBundle(final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
            DoFn.OutputReceiver<BigQueryStorageApiInsertError> failedRowsReceiver = new DoFn.OutputReceiver<BigQueryStorageApiInsertError>(){

                public void output(@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError output) {
                    this.outputWithTimestamp(output, GlobalWindow.INSTANCE.maxTimestamp());
                }

                public void outputWithTimestamp(@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError output, @UnknownKeyFor @NonNull @Initialized org.joda.time.Instant timestamp) {
                    context.output(failedRowsTag, (Object)output, timestamp, (BoundedWindow)GlobalWindow.INSTANCE);
                }
            };
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable DoFn.OutputReceiver<TableRow> successfulRowsReceiver = null;
            if (this.successfulRowsTag != null) {
                successfulRowsReceiver = new DoFn.OutputReceiver<TableRow>(){

                    public void output(@UnknownKeyFor @NonNull @Initialized TableRow output) {
                        this.outputWithTimestamp(output, GlobalWindow.INSTANCE.maxTimestamp());
                    }

                    public void outputWithTimestamp(@UnknownKeyFor @NonNull @Initialized TableRow output, @UnknownKeyFor @NonNull @Initialized org.joda.time.Instant timestamp) {
                        context.output(successfulRowsTag, (Object)output, timestamp, (BoundedWindow)GlobalWindow.INSTANCE);
                    }
                };
            }
            this.flushAll(failedRowsReceiver, successfulRowsReceiver);
            Map destinations = (Map)org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.destinations);
            for (DestinationState state : destinations.values()) {
                if (!this.useDefaultStream && !Strings.isNullOrEmpty((String)state.streamName)) {
                    context.output(this.finalizeTag, (Object)KV.of((Object)state.tableUrn, (Object)state.streamName), GlobalWindow.INSTANCE.maxTimestamp(), (BoundedWindow)GlobalWindow.INSTANCE);
                }
                state.teardown();
            }
            destinations.clear();
            this.destinations = null;
        }

        @DoFn.Teardown
        public void teardown() {
            this.destinations = null;
            try {
                if (this.maybeDatasetService != null) {
                    this.maybeDatasetService.close();
                    this.maybeDatasetService = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        class DestinationState {
            private final @UnknownKeyFor @NonNull @Initialized String tableUrn;
            private @UnknownKeyFor @NonNull @Initialized String streamName = "";
            private @Nullable @UnknownKeyFor @Initialized AppendClientInfo appendClientInfo = null;
            private @UnknownKeyFor @NonNull @Initialized long currentOffset = 0L;
            private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteString> pendingMessages;
            private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized org.joda.time.Instant> pendingTimestamps;
            private transient @Nullable @UnknownKeyFor @Initialized BigQueryServices.DatasetService maybeDatasetService;
            private final @UnknownKeyFor @NonNull @Initialized Counter recordsAppended = Metrics.counter(WriteRecordsDoFn.class, (String)"recordsAppended");
            private final @UnknownKeyFor @NonNull @Initialized Counter appendFailures = Metrics.counter(WriteRecordsDoFn.class, (String)"appendFailures");
            private final @UnknownKeyFor @NonNull @Initialized Distribution inflightWaitSecondsDistribution = Metrics.distribution(WriteRecordsDoFn.class, (String)"streamWriterWaitSeconds");
            private final @UnknownKeyFor @NonNull @Initialized Counter rowsSentToFailedRowsCollection = Metrics.counter(StorageApiWritesShardedRecords.WriteRecordsDoFn.class, (String)"rowsSentToFailedRowsCollection");
            private final @UnknownKeyFor @NonNull @Initialized boolean useDefaultStream;
            private @UnknownKeyFor @NonNull @Initialized TableSchema initialTableSchema;
            private @UnknownKeyFor @NonNull @Initialized Instant nextCacheTickle = Instant.MAX;
            private final @UnknownKeyFor @NonNull @Initialized int clientNumber;
            private final @UnknownKeyFor @NonNull @Initialized boolean usingMultiplexing;
            private final @UnknownKeyFor @NonNull @Initialized long maxRequestSize;

            public DestinationState(@UnknownKeyFor @NonNull @Initialized String tableUrn, @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter, @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService, @UnknownKeyFor @NonNull @Initialized boolean useDefaultStream, @UnknownKeyFor @NonNull @Initialized int streamAppendClientCount, @UnknownKeyFor @NonNull @Initialized boolean usingMultiplexing, long maxRequestSize) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.tableUrn = tableUrn;
                this.pendingMessages = Lists.newArrayList();
                this.pendingTimestamps = Lists.newArrayList();
                this.maybeDatasetService = datasetService;
                this.useDefaultStream = useDefaultStream;
                this.initialTableSchema = messageConverter.getTableSchema();
                this.clientNumber = new Random().nextInt(streamAppendClientCount);
                this.usingMultiplexing = usingMultiplexing;
                this.maxRequestSize = maxRequestSize;
            }

            void teardown() {
                this.maybeTickleCache();
                if (this.appendClientInfo != null) {
                    BigQueryServices.StreamAppendClient client = this.appendClientInfo.getStreamAppendClient();
                    if (client != null) {
                        StorageApiWriteUnshardedRecords.runAsyncIgnoreFailure(closeWriterExecutor, client::unpin);
                    }
                    this.appendClientInfo = null;
                }
            }

            @UnknownKeyFor @NonNull @Initialized String getDefaultStreamName() {
                return BigQueryHelpers.stripPartitionDecorator(this.tableUrn) + "/streams/_default";
            }

            @UnknownKeyFor @NonNull @Initialized String getStreamAppendClientCacheEntryKey() {
                if (this.useDefaultStream) {
                    return this.getDefaultStreamName() + "-client" + this.clientNumber;
                }
                return this.streamName;
            }

            @UnknownKeyFor @NonNull @Initialized String getOrCreateStreamName() {
                if (Strings.isNullOrEmpty((String)this.streamName)) {
                    try {
                        if (!this.useDefaultStream) {
                            this.streamName = ((BigQueryServices.DatasetService)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.maybeDatasetService)).createWriteStream(this.tableUrn, WriteStream.Type.PENDING).getName();
                            this.currentOffset = 0L;
                        } else {
                            this.streamName = this.getDefaultStreamName();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.streamName;
            }

            @UnknownKeyFor @NonNull @Initialized AppendClientInfo generateClient(@Nullable @UnknownKeyFor @Initialized TableSchema updatedSchema) throws @UnknownKeyFor @NonNull @Initialized Exception {
                TableSchema tableSchema = updatedSchema != null ? updatedSchema : this.getCurrentTableSchema(this.streamName);
                AppendClientInfo appendClientInfo = AppendClientInfo.of(tableSchema, client -> StorageApiWriteUnshardedRecords.runAsyncIgnoreFailure(closeWriterExecutor, () -> {
                    Cache cache = APPEND_CLIENTS;
                    synchronized (cache) {
                        client.unpin();
                        client.close();
                    }
                }));
                appendClientInfo = appendClientInfo.withAppendClient((BigQueryServices.DatasetService)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.maybeDatasetService), () -> this.streamName, this.usingMultiplexing);
                ((BigQueryServices.StreamAppendClient)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)appendClientInfo.getStreamAppendClient())).pin();
                return appendClientInfo;
            }

            @UnknownKeyFor @NonNull @Initialized TableSchema getCurrentTableSchema(@UnknownKeyFor @NonNull @Initialized String stream) {
                WriteStream writeStream;
                TableSchema currentSchema = this.initialTableSchema;
                if (WriteRecordsDoFn.this.autoUpdateSchema && (writeStream = ((BigQueryServices.DatasetService)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.maybeDatasetService)).getWriteStream(this.streamName)) != null && writeStream.hasTableSchema()) {
                    currentSchema = writeStream.getTableSchema();
                }
                return currentSchema;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @UnknownKeyFor @NonNull @Initialized AppendClientInfo getAppendClientInfo(@UnknownKeyFor @NonNull @Initialized boolean lookupCache, @Nullable @UnknownKeyFor @Initialized TableSchema updatedSchema) {
                try {
                    if (this.appendClientInfo == null) {
                        AppendClientInfo newAppendClientInfo;
                        this.getOrCreateStreamName();
                        Cache cache = APPEND_CLIENTS;
                        synchronized (cache) {
                            if (lookupCache) {
                                newAppendClientInfo = (AppendClientInfo)APPEND_CLIENTS.get((Object)this.getStreamAppendClientCacheEntryKey(), () -> this.generateClient(updatedSchema));
                            } else {
                                newAppendClientInfo = this.generateClient(updatedSchema);
                                APPEND_CLIENTS.put((Object)this.getStreamAppendClientCacheEntryKey(), (Object)newAppendClientInfo);
                            }
                            ((BigQueryServices.StreamAppendClient)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)newAppendClientInfo.getStreamAppendClient())).pin();
                        }
                        this.nextCacheTickle = Instant.now().plus(java.time.Duration.ofMinutes(1L));
                        this.appendClientInfo = newAppendClientInfo;
                    }
                    return (AppendClientInfo)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.appendClientInfo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void maybeTickleCache() {
                if (this.appendClientInfo != null && Instant.now().isAfter(this.nextCacheTickle)) {
                    Cache cache = APPEND_CLIENTS;
                    synchronized (cache) {
                        APPEND_CLIENTS.getIfPresent((Object)this.getStreamAppendClientCacheEntryKey());
                    }
                    this.nextCacheTickle = Instant.now().plus(java.time.Duration.ofMinutes(1L));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void invalidateWriteStream() {
                if (this.appendClientInfo != null) {
                    Cache cache = APPEND_CLIENTS;
                    synchronized (cache) {
                        BigQueryServices.StreamAppendClient client = this.appendClientInfo.getStreamAppendClient();
                        if (client != null) {
                            StorageApiWriteUnshardedRecords.runAsyncIgnoreFailure(closeWriterExecutor, client::unpin);
                        }
                        String cacheEntryKey = this.getStreamAppendClientCacheEntryKey();
                        @Nullable AppendClientInfo cachedAppendClient = (AppendClientInfo)APPEND_CLIENTS.getIfPresent((Object)cacheEntryKey);
                        if (cachedAppendClient != null && System.identityHashCode(cachedAppendClient) == System.identityHashCode(this.appendClientInfo)) {
                            APPEND_CLIENTS.invalidate((Object)cacheEntryKey);
                        }
                    }
                    this.appendClientInfo = null;
                }
            }

            void addMessage(@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload payload, @UnknownKeyFor @NonNull @Initialized org.joda.time.Instant elementTs, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsReceiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.maybeTickleCache();
                ByteString payloadBytes = ByteString.copyFrom((byte[])payload.getPayload());
                if (WriteRecordsDoFn.this.autoUpdateSchema) {
                    TableRow unknownFields;
                    if (this.appendClientInfo == null) {
                        this.appendClientInfo = this.getAppendClientInfo(true, null);
                    }
                    if ((unknownFields = payload.getUnknownFields()) != null) {
                        try {
                            payloadBytes = payloadBytes.concat(((AppendClientInfo)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.appendClientInfo)).encodeUnknownFields(unknownFields, WriteRecordsDoFn.this.ignoreUnknownValues));
                        }
                        catch (TableRowToStorageApiProto.SchemaConversionException e) {
                            TableRow tableRow = this.appendClientInfo.toTableRow(payloadBytes);
                            org.joda.time.Instant timestamp = payload.getTimestamp();
                            this.rowsSentToFailedRowsCollection.inc();
                            failedRowsReceiver.outputWithTimestamp((Object)new BigQueryStorageApiInsertError(tableRow, e.toString()), timestamp != null ? timestamp : elementTs);
                            return;
                        }
                    }
                }
                this.pendingMessages.add(payloadBytes);
                org.joda.time.Instant timestamp = payload.getTimestamp();
                this.pendingTimestamps.add(timestamp != null ? timestamp : elementTs);
            }

            @UnknownKeyFor @NonNull @Initialized long flush(@UnknownKeyFor @NonNull @Initialized RetryManager<@UnknownKeyFor @NonNull @Initialized AppendRowsResponse, @UnknownKeyFor @NonNull @Initialized AppendRowsContext> retryManager, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsReceiver, // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable @UnknownKeyFor @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized TableRow> successfulRowsReceiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
                if (this.pendingMessages.isEmpty()) {
                    return 0L;
                }
                ProtoRows.Builder insertsBuilder = ProtoRows.newBuilder();
                insertsBuilder.addAllSerializedRows(this.pendingMessages);
                this.pendingMessages.clear();
                ProtoRows inserts = insertsBuilder.build();
                List<org.joda.time.Instant> insertTimestamps = this.pendingTimestamps;
                this.pendingTimestamps = Lists.newArrayList();
                if ((long)inserts.getSerializedSize() >= this.maxRequestSize) {
                    if (inserts.getSerializedRowsCount() > 1) {
                        LOG.error("A request containing more than one row is over the request size limit of {}. This is unexpected. All rows in the request will be sent to the failed-rows PCollection.", (Object)this.maxRequestSize);
                    }
                    for (int i = 0; i < inserts.getSerializedRowsCount(); ++i) {
                        ByteString rowBytes = inserts.getSerializedRows(i);
                        org.joda.time.Instant timestamp = insertTimestamps.get(i);
                        TableRow failedRow = TableRowToStorageApiProto.tableRowFromMessage((Message)DynamicMessage.parseFrom((Descriptors.Descriptor)this.getAppendClientInfo(true, null).getDescriptor(), (ByteString)rowBytes));
                        failedRowsReceiver.outputWithTimestamp((Object)new BigQueryStorageApiInsertError(failedRow, "Row payload too large. Maximum size " + this.maxRequestSize), timestamp);
                    }
                    this.rowsSentToFailedRowsCollection.inc((long)inserts.getSerializedRowsCount());
                    return 0L;
                }
                long offset = -1L;
                if (!this.useDefaultStream) {
                    this.getOrCreateStreamName();
                    offset = this.currentOffset;
                    this.currentOffset += (long)inserts.getSerializedRowsCount();
                }
                AppendRowsContext appendRowsContext = new AppendRowsContext(offset, inserts, insertTimestamps);
                retryManager.addOperation(c -> {
                    if (c.protoRows.getSerializedRowsCount() == 0) {
                        return ApiFutures.immediateFuture((Object)AppendRowsResponse.newBuilder().build());
                    }
                    try {
                        BigQueryServices.StreamAppendClient writeStream = (BigQueryServices.StreamAppendClient)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.getAppendClientInfo(true, null).getStreamAppendClient());
                        ApiFuture<AppendRowsResponse> response = writeStream.appendRows(c.offset, c.protoRows);
                        this.inflightWaitSecondsDistribution.update(writeStream.getInflightWaitSeconds());
                        if (!this.usingMultiplexing && writeStream.getInflightWaitSeconds() > 5L) {
                            LOG.warn("Storage Api write delay more than {} seconds.", (Object)writeStream.getInflightWaitSeconds());
                        }
                        return response;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, contexts -> {
                    boolean streamDoesNotExist;
                    AppendRowsContext failedContext = (AppendRowsContext)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)((AppendRowsContext)Iterables.getFirst((Iterable)contexts, null)));
                    if (failedContext.getError() != null && failedContext.getError() instanceof Exceptions.AppendSerializtionError) {
                        Exceptions.AppendSerializtionError error = (Exceptions.AppendSerializtionError)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)((Exceptions.AppendSerializtionError)failedContext.getError()));
                        Set failedRowIndices = error.getRowIndexToErrorMessage().keySet();
                        Iterator iterator = failedRowIndices.iterator();
                        while (iterator.hasNext()) {
                            int failedIndex = (Integer)iterator.next();
                            ByteString protoBytes = failedContext.protoRows.getSerializedRows(failedIndex);
                            org.joda.time.Instant timestamp = failedContext.timestamps.get(failedIndex);
                            try {
                                TableRow failedRow = TableRowToStorageApiProto.tableRowFromMessage((Message)DynamicMessage.parseFrom((Descriptors.Descriptor)((AppendClientInfo)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.appendClientInfo)).getDescriptor(), (ByteString)protoBytes));
                                failedRowsReceiver.outputWithTimestamp((Object)new BigQueryStorageApiInsertError(failedRow, (String)error.getRowIndexToErrorMessage().get(failedIndex)), timestamp);
                            }
                            catch (InvalidProtocolBufferException e) {
                                LOG.error("Failed to insert row and could not parse the result!", (Throwable)e);
                            }
                        }
                        this.rowsSentToFailedRowsCollection.inc((long)failedRowIndices.size());
                        ProtoRows.Builder retryRows = ProtoRows.newBuilder();
                        ArrayList retryTimestamps = Lists.newArrayList();
                        for (int i = 0; i < failedContext.protoRows.getSerializedRowsCount(); ++i) {
                            if (failedRowIndices.contains(i)) continue;
                            ByteString rowBytes = failedContext.protoRows.getSerializedRows(i);
                            retryRows.addSerializedRows(rowBytes);
                            retryTimestamps.add(failedContext.timestamps.get(i));
                        }
                        failedContext.protoRows = retryRows.build();
                        failedContext.timestamps = retryTimestamps;
                        long newOffset = failedContext.offset;
                        for (AppendRowsContext context : contexts) {
                            context.offset = newOffset;
                            newOffset += (long)context.protoRows.getSerializedRowsCount();
                        }
                        this.currentOffset = newOffset;
                        return RetryManager.RetryType.RETRY_ALL_OPERATIONS;
                    }
                    LOG.warn("Append to stream {} by client #{} failed with error, operations will be retried.\n{}", new Object[]{this.streamName, this.clientNumber, this.retrieveErrorDetails((Iterable<AppendRowsContext>)contexts)});
                    ++failedContext.failureCount;
                    this.invalidateWriteStream();
                    if (failedContext.failureCount > 5) {
                        throw new RuntimeException("More than 5 attempts to call AppendRows failed.");
                    }
                    Throwable error = (Throwable)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)failedContext.getError());
                    Status.Code statusCode = Status.fromThrowable((Throwable)error).getCode();
                    if (statusCode.equals((Object)Status.Code.OUT_OF_RANGE) || statusCode.equals((Object)Status.Code.ALREADY_EXISTS)) {
                        throw new RuntimeException("Append to stream " + this.streamName + " failed with invalid offset of " + failedContext.offset);
                    }
                    boolean bl = streamDoesNotExist = failedContext.getError() instanceof Exceptions.StreamFinalizedException || statusCode.equals((Object)Status.Code.INVALID_ARGUMENT) || statusCode.equals((Object)Status.Code.NOT_FOUND) || statusCode.equals((Object)Status.Code.FAILED_PRECONDITION);
                    if (streamDoesNotExist) {
                        throw new RuntimeException("Append to stream " + this.streamName + " failed with stream doesn't exist");
                    }
                    this.appendFailures.inc();
                    return RetryManager.RetryType.RETRY_ALL_OPERATIONS;
                }, c -> {
                    this.recordsAppended.inc((long)c.protoRows.getSerializedRowsCount());
                    if (successfulRowsReceiver != null) {
                        for (int i = 0; i < c.protoRows.getSerializedRowsCount(); ++i) {
                            ByteString rowBytes = (ByteString)c.protoRows.getSerializedRowsList().get(i);
                            try {
                                TableRow row = TableRowToStorageApiProto.tableRowFromMessage((Message)DynamicMessage.parseFrom((Descriptors.Descriptor)((AppendClientInfo)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.appendClientInfo)).getDescriptor(), (ByteString)rowBytes));
                                org.joda.time.Instant timestamp = c.timestamps.get(i);
                                successfulRowsReceiver.outputWithTimestamp((Object)row, timestamp);
                                continue;
                            }
                            catch (InvalidProtocolBufferException e) {
                                LOG.warn("Failure parsing TableRow", (Throwable)e);
                            }
                        }
                    }
                }, appendRowsContext);
                this.maybeTickleCache();
                return inserts.getSerializedRowsCount();
            }

            @UnknownKeyFor @NonNull @Initialized String retrieveErrorDetails(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized AppendRowsContext> failedContext) {
                return StreamSupport.stream(failedContext.spliterator(), false).map(RetryManager.Operation.Context::getError).filter(Objects::nonNull).map(thrw -> ((Throwable)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)thrw)).toString() + "\n" + Arrays.stream(((Throwable)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)thrw)).getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n"));
            }

            void postFlush() {
                if (this.appendClientInfo != null && WriteRecordsDoFn.this.autoUpdateSchema) {
                    Optional<TableSchema> updatedTableSchema;
                    TableSchema updatedTableSchemaReturned;
                    @Nullable BigQueryServices.StreamAppendClient streamAppendClient = this.appendClientInfo.getStreamAppendClient();
                    TableSchema tableSchema = updatedTableSchemaReturned = streamAppendClient != null ? streamAppendClient.getUpdatedSchema() : null;
                    if (updatedTableSchemaReturned != null && (updatedTableSchema = TableSchemaUpdateUtils.getUpdatedSchema(this.initialTableSchema, updatedTableSchemaReturned)).isPresent()) {
                        this.invalidateWriteStream();
                        this.appendClientInfo = (AppendClientInfo)org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.getAppendClientInfo(false, updatedTableSchema.get()));
                    }
                }
            }
        }

        static class AppendRowsContext
        extends RetryManager.Operation.Context<AppendRowsResponse> {
            @UnknownKeyFor @NonNull @Initialized long offset;
            @UnknownKeyFor @NonNull @Initialized ProtoRows protoRows;
            @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized org.joda.time.Instant> timestamps;
            @UnknownKeyFor @NonNull @Initialized int failureCount;

            public AppendRowsContext(@UnknownKeyFor @NonNull @Initialized long offset, @UnknownKeyFor @NonNull @Initialized ProtoRows protoRows, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized org.joda.time.Instant> timestamps) {
                this.offset = offset;
                this.protoRows = protoRows;
                this.timestamps = timestamps;
                this.failureCount = 0;
            }
        }
    }

    private static interface ThrowingRunnable {
        public void run() throws @UnknownKeyFor @NonNull @Initialized Exception;
    }
}

