/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.LoadingCache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.RemovalListener;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.RemovalNotification;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class DoFnLifecycleManager {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized Thread, @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outstanding;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized Thread, @UnknownKeyFor @NonNull @Initialized Exception> thrownOnTeardown;

    public static @UnknownKeyFor @NonNull @Initialized DoFnLifecycleManager of(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> original, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new DoFnLifecycleManager(original, options);
    }

    private DoFnLifecycleManager(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> original, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.outstanding = CacheBuilder.newBuilder().removalListener((RemovalListener)new TeardownRemovedFnListener()).build((CacheLoader)new DeserializingCacheLoader(original, options));
        this.thrownOnTeardown = new ConcurrentHashMap<Thread, Exception>();
    }

    public <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> get() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Thread currentThread = Thread.currentThread();
        return (DoFn)this.outstanding.get((Object)currentThread);
    }

    public void remove() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Thread currentThread = Thread.currentThread();
        this.outstanding.invalidate((Object)currentThread);
        this.outstanding.cleanUp();
        Exception thrown = (Exception)this.thrownOnTeardown.remove(currentThread);
        if (thrown != null) {
            throw thrown;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Exception> removeAll() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.outstanding.invalidateAll();
        this.outstanding.cleanUp();
        return this.thrownOnTeardown.values();
    }

    private class TeardownRemovedFnListener
    implements RemovalListener<Thread, DoFn<?, ?>> {
        private TeardownRemovedFnListener() {
        }

        public void onRemoval(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized RemovalNotification<@UnknownKeyFor @NonNull @Initialized Thread, @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> notification) {
            try {
                DoFnInvokers.invokerFor((DoFn)((DoFn)notification.getValue())).invokeTeardown();
            }
            catch (Exception e) {
                DoFnLifecycleManager.this.thrownOnTeardown.put((Thread)notification.getKey(), e);
            }
        }
    }

    private static class DeserializingCacheLoader
    extends CacheLoader<Thread, DoFn<?, ?>> {
        private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] original;
        private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;

        public DeserializingCacheLoader(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> original, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.original = SerializableUtils.serializeToByteArray(original);
            this.options = options;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> load(@UnknownKeyFor @NonNull @Initialized Thread key) throws @UnknownKeyFor @NonNull @Initialized Exception {
            DoFn fn = (DoFn)SerializableUtils.deserializeFromByteArray((byte[])this.original, (String)("DoFn Copy in thread " + key.getName()));
            DoFnInvokers.tryInvokeSetupFor((DoFn)fn, (PipelineOptions)this.options);
            return fn;
        }
    }
}

