/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.SideInputHandler;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.repackaged.direct_java.runners.core.construction.graph.SideInputReference;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.state.StateRequestHandlers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StreamingSideInputHandlerFactory
implements StateRequestHandlers.SideInputHandlerFactory {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.SideInputId, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputToCollection;
    private final @UnknownKeyFor @NonNull @Initialized SideInputHandler runnerHandler;

    public static @UnknownKeyFor @NonNull @Initialized StreamingSideInputHandlerFactory forStage(@UnknownKeyFor @NonNull @Initialized ExecutableStage stage, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.SideInputId, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> viewMapping, @UnknownKeyFor @NonNull @Initialized SideInputHandler runnerHandler) {
        ImmutableMap.Builder sideInputBuilder = ImmutableMap.builder();
        for (SideInputReference sideInput : stage.getSideInputs()) {
            RunnerApi.ExecutableStagePayload.SideInputId sideInputId = RunnerApi.ExecutableStagePayload.SideInputId.newBuilder().setTransformId(sideInput.transform().getId()).setLocalName(sideInput.localName()).build();
            sideInputBuilder.put((Object)sideInputId, (Object)((PCollectionView)Preconditions.checkNotNull(viewMapping.get(sideInputId), (String)"No side input for %s/%s", (Object)sideInputId.getTransformId(), (Object)sideInputId.getLocalName())));
        }
        StreamingSideInputHandlerFactory factory = new StreamingSideInputHandlerFactory((Map<RunnerApi.ExecutableStagePayload.SideInputId, PCollectionView<?>>)sideInputBuilder.build(), runnerHandler);
        return factory;
    }

    private StreamingSideInputHandlerFactory(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.SideInputId, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputToCollection, @UnknownKeyFor @NonNull @Initialized SideInputHandler runnerHandler) {
        this.sideInputToCollection = sideInputToCollection;
        this.runnerHandler = runnerHandler;
    }

    @Override
    public <V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized StateRequestHandlers.IterableSideInputHandler<V, W> forIterableSideInput(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String sideInputId, final @UnknownKeyFor @NonNull @Initialized Coder<V> elementCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
        final PCollectionView<?> collectionNode = this.sideInputToCollection.get(RunnerApi.ExecutableStagePayload.SideInputId.newBuilder().setTransformId(transformId).setLocalName(sideInputId).build());
        Preconditions.checkArgument((collectionNode != null ? 1 : 0) != 0, (String)"No side input for %s/%s", (Object)transformId, (Object)sideInputId);
        return new StateRequestHandlers.IterableSideInputHandler<V, W>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(W window) {
                return (Iterable)Preconditions.checkNotNull(StreamingSideInputHandlerFactory.this.runnerHandler.getIterable(collectionNode, (BoundedWindow)window), (Object)"Element processed by SDK before side input is ready");
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<V> elementCoder() {
                return elementCoder;
            }
        };
    }

    @Override
    public <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized StateRequestHandlers.MultimapSideInputHandler<K, V, W> forMultimapSideInput(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String sideInputId, final @UnknownKeyFor @NonNull @Initialized KvCoder<K, V> elementCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
        final PCollectionView<?> collectionNode = this.sideInputToCollection.get(RunnerApi.ExecutableStagePayload.SideInputId.newBuilder().setTransformId(transformId).setLocalName(sideInputId).build());
        Preconditions.checkArgument((collectionNode != null ? 1 : 0) != 0, (String)"No side input for %s/%s", (Object)transformId, (Object)sideInputId);
        return new StateRequestHandlers.MultimapSideInputHandler<K, V, W>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(K key, W window) {
                Iterable<?> values = StreamingSideInputHandlerFactory.this.runnerHandler.getIterable(collectionNode, (BoundedWindow)window);
                Object structuralK = this.keyCoder().structuralValue(key);
                ArrayList<Object> result = new ArrayList<Object>();
                for (KV kv : values) {
                    if (!structuralK.equals(this.keyCoder().structuralValue(kv.getKey()))) continue;
                    result.add(kv.getValue());
                }
                return Collections.unmodifiableList(result);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Iterable<K> get(W window) {
                Iterable<?> values = StreamingSideInputHandlerFactory.this.runnerHandler.getIterable(collectionNode, (BoundedWindow)window);
                HashMap<Object, Object> result = new HashMap<Object, Object>();
                for (KV kv : values) {
                    result.putIfAbsent(this.keyCoder().structuralValue(kv.getKey()), kv.getKey());
                }
                return Collections.unmodifiableCollection(result.values());
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder() {
                return elementCoder.getKeyCoder();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder() {
                return elementCoder.getValueCoder();
            }
        };
    }
}

