/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.timeline;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.util.StringHelper;

public final class TimelineEntityV2Converter {
    private TimelineEntityV2Converter() {
    }

    public static ContainerReport convertToContainerReport(TimelineEntity entity, String serverAddress, String user) {
        NavigableSet<TimelineEvent> events;
        int allocatedMem = 0;
        int allocatedVcore = 0;
        String allocatedHost = null;
        int allocatedPort = -1;
        int allocatedPriority = 0;
        long createdTime = 0L;
        long finishedTime = 0L;
        String diagnosticsInfo = null;
        int exitStatus = -1000;
        ContainerState state = null;
        String nodeHttpAddress = null;
        Map exposedPorts = null;
        Map<String, Object> entityInfo = entity.getInfo();
        if (entityInfo != null) {
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_MEMORY")) {
                allocatedMem = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_MEMORY");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_VCORE")) {
                allocatedVcore = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_VCORE");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_HOST")) {
                allocatedHost = entityInfo.get("YARN_CONTAINER_ALLOCATED_HOST").toString();
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_PORT")) {
                allocatedPort = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_PORT");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_PRIORITY")) {
                allocatedPriority = Integer.parseInt(entityInfo.get("YARN_CONTAINER_ALLOCATED_PRIORITY").toString());
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS")) {
                nodeHttpAddress = (String)entityInfo.get("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_EXPOSED_PORTS")) {
                exposedPorts = (Map)entityInfo.get("YARN_CONTAINER_ALLOCATED_EXPOSED_PORTS");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_DIAGNOSTICS_INFO")) {
                diagnosticsInfo = entityInfo.get("YARN_CONTAINER_DIAGNOSTICS_INFO").toString();
            }
            if (entityInfo.containsKey("YARN_CONTAINER_EXIT_STATUS")) {
                exitStatus = (Integer)entityInfo.get("YARN_CONTAINER_EXIT_STATUS");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_STATE")) {
                state = ContainerState.valueOf(entityInfo.get("YARN_CONTAINER_STATE").toString());
            }
        }
        if ((events = entity.getEvents()) != null) {
            for (TimelineEvent event : events) {
                if (event.getId().equals("YARN_RM_CONTAINER_CREATED")) {
                    createdTime = event.getTimestamp();
                    continue;
                }
                if (!event.getId().equals("YARN_RM_CONTAINER_FINISHED")) continue;
                finishedTime = event.getTimestamp();
            }
        }
        String logUrl = null;
        NodeId allocatedNode = null;
        String containerId = entity.getId();
        if (allocatedHost != null) {
            allocatedNode = NodeId.newInstance(allocatedHost, allocatedPort);
            if (serverAddress != null && user != null) {
                logUrl = StringHelper.PATH_JOINER.join((Object)serverAddress, (Object)"logs", new Object[]{allocatedNode, containerId, containerId, user});
            }
        }
        ContainerReport container = ContainerReport.newInstance(ContainerId.fromString(entity.getId()), Resource.newInstance(allocatedMem, allocatedVcore), allocatedNode, Priority.newInstance(allocatedPriority), createdTime, finishedTime, diagnosticsInfo, logUrl, exitStatus, state, nodeHttpAddress);
        container.setExposedPorts(exposedPorts);
        return container;
    }

    public static ApplicationAttemptReport convertToApplicationAttemptReport(TimelineEntity entity) {
        NavigableSet<TimelineEvent> events;
        String host = null;
        int rpcPort = -1;
        ContainerId amContainerId = null;
        String trackingUrl = null;
        String originalTrackingUrl = null;
        String diagnosticsInfo = null;
        YarnApplicationAttemptState state = null;
        Map<String, Object> entityInfo = entity.getInfo();
        long startTime = 0L;
        long finishTime = 0L;
        if (entityInfo != null) {
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_HOST")) {
                host = entityInfo.get("YARN_APPLICATION_ATTEMPT_HOST").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_RPC_PORT")) {
                rpcPort = (Integer)entityInfo.get("YARN_APPLICATION_ATTEMPT_RPC_PORT");
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER")) {
                amContainerId = ContainerId.fromString(entityInfo.get("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_TRACKING_URL")) {
                trackingUrl = entityInfo.get("YARN_APPLICATION_ATTEMPT_TRACKING_URL").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL")) {
                originalTrackingUrl = entityInfo.get("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO")) {
                diagnosticsInfo = entityInfo.get("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_STATE")) {
                state = YarnApplicationAttemptState.valueOf(entityInfo.get("YARN_APPLICATION_ATTEMPT_STATE").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER")) {
                amContainerId = ContainerId.fromString(entityInfo.get("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER").toString());
            }
        }
        if ((events = entity.getEvents()) != null) {
            for (TimelineEvent event : events) {
                if (event.getId().equals("YARN_APPLICATION_ATTEMPT_REGISTERED")) {
                    startTime = event.getTimestamp();
                    continue;
                }
                if (!event.getId().equals("YARN_APPLICATION_ATTEMPT_FINISHED")) continue;
                finishTime = event.getTimestamp();
            }
        }
        return ApplicationAttemptReport.newInstance(ApplicationAttemptId.fromString(entity.getId()), host, rpcPort, trackingUrl, originalTrackingUrl, diagnosticsInfo, state, amContainerId, startTime, finishTime);
    }

    public static ApplicationReport convertToApplicationReport(TimelineEntity entity) {
        Set<TimelineMetric> metrics;
        Map<String, String> configs;
        String user = null;
        String queue = null;
        String name = null;
        String type = null;
        boolean unmanagedApplication = false;
        long createdTime = 0L;
        long launchTime = 0L;
        long finishedTime = 0L;
        float progress = 0.0f;
        int applicationPriority = 0;
        ApplicationAttemptId latestApplicationAttemptId = null;
        String diagnosticsInfo = null;
        FinalApplicationStatus finalStatus = FinalApplicationStatus.UNDEFINED;
        YarnApplicationState state = YarnApplicationState.ACCEPTED;
        ApplicationResourceUsageReport appResources = null;
        HashSet<String> appTags = null;
        String appNodeLabelExpression = null;
        String amNodeLabelExpression = null;
        Map<String, Object> entityInfo = entity.getInfo();
        if (entityInfo != null) {
            if (entityInfo.containsKey("YARN_APPLICATION_USER")) {
                user = entityInfo.get("YARN_APPLICATION_USER").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_QUEUE")) {
                queue = entityInfo.get("YARN_APPLICATION_QUEUE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_NAME")) {
                name = entityInfo.get("YARN_APPLICATION_NAME").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TYPE")) {
                type = entityInfo.get("YARN_APPLICATION_TYPE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TYPE")) {
                type = entityInfo.get("YARN_APPLICATION_TYPE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_UNMANAGED_APPLICATION")) {
                unmanagedApplication = Boolean.parseBoolean(entityInfo.get("YARN_APPLICATION_UNMANAGED_APPLICATION").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_PRIORITY")) {
                applicationPriority = Integer.parseInt(entityInfo.get("YARN_APPLICATION_PRIORITY").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TAGS")) {
                appTags = new HashSet<String>();
                Object obj = entityInfo.get("YARN_APPLICATION_TAGS");
                if (obj != null && obj instanceof Collection) {
                    for (Object o : (Collection)obj) {
                        if (o == null) continue;
                        appTags.add(o.toString());
                    }
                }
            }
            if (entityInfo.containsKey("YARN_APPLICATION_LATEST_APP_ATTEMPT")) {
                latestApplicationAttemptId = ApplicationAttemptId.fromString(entityInfo.get("YARN_APPLICATION_LATEST_APP_ATTEMPT").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_DIAGNOSTICS_INFO")) {
                diagnosticsInfo = entityInfo.get("YARN_APPLICATION_DIAGNOSTICS_INFO").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_FINAL_STATUS")) {
                finalStatus = FinalApplicationStatus.valueOf(entityInfo.get("YARN_APPLICATION_FINAL_STATUS").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_STATE")) {
                state = YarnApplicationState.valueOf(entityInfo.get("YARN_APPLICATION_STATE").toString());
            }
        }
        if ((configs = entity.getConfigs()).containsKey("YARN_APP_NODE_LABEL_EXPRESSION")) {
            appNodeLabelExpression = configs.get("YARN_APP_NODE_LABEL_EXPRESSION");
        }
        if (configs.containsKey("YARN_AM_NODE_LABEL_EXPRESSION")) {
            amNodeLabelExpression = configs.get("YARN_AM_NODE_LABEL_EXPRESSION");
        }
        if ((metrics = entity.getMetrics()) != null) {
            long vcoreSeconds = 0L;
            long memorySeconds = 0L;
            long preemptedVcoreSeconds = 0L;
            long preemptedMemorySeconds = 0L;
            for (TimelineMetric metric : metrics) {
                switch (metric.getId()) {
                    case "YARN_APPLICATION_CPU": {
                        vcoreSeconds = TimelineEntityV2Converter.getAverageValue(metric.getValues().values());
                        break;
                    }
                    case "YARN_APPLICATION_MEMORY": {
                        memorySeconds = TimelineEntityV2Converter.getAverageValue(metric.getValues().values());
                        break;
                    }
                    case "YARN_APPLICATION_MEM_PREEMPT_METRIC": {
                        preemptedVcoreSeconds = TimelineEntityV2Converter.getAverageValue(metric.getValues().values());
                        break;
                    }
                    case "YARN_APPLICATION_CPU_PREEMPT_METRIC": {
                        preemptedVcoreSeconds = TimelineEntityV2Converter.getAverageValue(metric.getValues().values());
                        break;
                    }
                }
            }
            HashMap<String, Long> resourceSecondsMap = new HashMap<String, Long>();
            HashMap<String, Long> preemptedResoureSecondsMap = new HashMap<String, Long>();
            resourceSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), memorySeconds);
            resourceSecondsMap.put(ResourceInformation.VCORES.getName(), vcoreSeconds);
            preemptedResoureSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), preemptedMemorySeconds);
            preemptedResoureSecondsMap.put(ResourceInformation.VCORES.getName(), preemptedVcoreSeconds);
            appResources = ApplicationResourceUsageReport.newInstance(0, 0, null, null, null, resourceSecondsMap, 0.0f, 0.0f, preemptedResoureSecondsMap);
        }
        NavigableSet<TimelineEvent> events = entity.getEvents();
        long updatedTimeStamp = 0L;
        if (events != null) {
            for (TimelineEvent event : events) {
                if (event.getId().equals("YARN_APPLICATION_CREATED")) {
                    createdTime = event.getTimestamp();
                    continue;
                }
                if (event.getId().equals("YARN_APPLICATION_LAUNCHED")) {
                    launchTime = event.getTimestamp();
                    continue;
                }
                if (event.getId().equals("YARN_APPLICATION_UPDATED")) {
                    if (event.getTimestamp() <= updatedTimeStamp) continue;
                    updatedTimeStamp = event.getTimestamp();
                    continue;
                }
                if (event.getId().equals("YARN_APPLICATION_STATE_UPDATED")) {
                    Map<String, Object> eventInfo = event.getInfo();
                    if (eventInfo == null || !eventInfo.containsKey("YARN_APPLICATION_STATE") || state != YarnApplicationState.ACCEPTED) continue;
                    state = YarnApplicationState.valueOf(eventInfo.get("YARN_APPLICATION_STATE").toString());
                    continue;
                }
                if (!event.getId().equals("YARN_APPLICATION_FINISHED")) continue;
                progress = 1.0f;
                state = YarnApplicationState.FINISHED;
                finishedTime = event.getTimestamp();
            }
        }
        return ApplicationReport.newInstance(ApplicationId.fromString(entity.getId()), latestApplicationAttemptId, user, queue, name, null, -1, null, state, diagnosticsInfo, null, createdTime, launchTime, finishedTime, finalStatus, appResources, null, progress, type, null, appTags, unmanagedApplication, Priority.newInstance(applicationPriority), appNodeLabelExpression, amNodeLabelExpression);
    }

    private static long getAverageValue(Collection<Number> values) {
        if (values == null || values.isEmpty()) {
            return 0L;
        }
        long sum = 0L;
        for (Number value : values) {
            sum += value.longValue();
        }
        return sum / (long)values.size();
    }
}

