/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.service.AutoService;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.kafka.ConfluentSchemaRegistryDeserializerProvider;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaIOUtils;
import org.apache.beam.sdk.io.kafka.KafkaReadSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SchemaTransformProvider.class})
public class KafkaReadSchemaTransformProvider
extends TypedSchemaTransformProvider<KafkaReadSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KafkaReadSchemaTransformProvider.class);
    final @UnknownKeyFor @NonNull @Initialized Boolean isTest;
    final @UnknownKeyFor @NonNull @Initialized Integer testTimeoutSecs;

    public KafkaReadSchemaTransformProvider() {
        this(false, 0);
    }

    @VisibleForTesting
    KafkaReadSchemaTransformProvider(@UnknownKeyFor @NonNull @Initialized Boolean isTest, @UnknownKeyFor @NonNull @Initialized Integer testTimeoutSecs) {
        this.isTest = isTest;
        this.testTimeoutSecs = testTimeoutSecs;
    }

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized KafkaReadSchemaTransformConfiguration> configurationClass() {
        return KafkaReadSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized KafkaReadSchemaTransformConfiguration configuration) {
        return new KafkaReadSchemaTransform(configuration, this.isTest, this.testTimeoutSecs);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:kafka_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Lists.newArrayList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Lists.newArrayList((Object[])new String[]{"output"});
    }

    private static class ConsumerFactoryWithGcsTrustStores
    implements SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> {
        private ConsumerFactoryWithGcsTrustStores() {
        }

        public @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> apply(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> input) {
            return (Consumer)KafkaIOUtils.KAFKA_CONSUMER_FACTORY_FN.apply(input.entrySet().stream().map(entry -> Maps.immutableEntry((Object)((String)entry.getKey()), (Object)ConsumerFactoryWithGcsTrustStores.identityOrGcsToLocalFile(entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        private static @UnknownKeyFor @NonNull @Initialized Object identityOrGcsToLocalFile(@UnknownKeyFor @NonNull @Initialized Object configValue) {
            if (configValue instanceof String) {
                String configStr = (String)configValue;
                if (configStr.startsWith("gs://")) {
                    try {
                        Path localFile = Files.createTempFile("", "", new FileAttribute[0]);
                        LOG.info("Downloading {} into local filesystem ({})", (Object)configStr, (Object)localFile.toAbsolutePath());
                        ReadableByteChannel channel = FileSystems.open((ResourceId)((MatchResult.Metadata)FileSystems.match((String)configStr).metadata().get(0)).resourceId());
                        FileOutputStream outputStream = new FileOutputStream(localFile.toFile());
                        WritableByteChannel outputChannel = Channels.newChannel(outputStream);
                        ByteBuffer buffer = ByteBuffer.allocate(1024);
                        while (channel.read(buffer) != -1) {
                            buffer.flip();
                            outputChannel.write(buffer);
                            buffer.compact();
                        }
                        channel.close();
                        outputChannel.close();
                        outputStream.close();
                        return localFile.toAbsolutePath().toString();
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(String.format("Unable to fetch file %s to be used locally to create a Kafka Consumer.", configStr));
                    }
                }
                return configValue;
            }
            return configValue;
        }
    }

    private static class KafkaReadSchemaTransform
    implements SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized KafkaReadSchemaTransformConfiguration configuration;
        private final @UnknownKeyFor @NonNull @Initialized Boolean isTest;
        private final @UnknownKeyFor @NonNull @Initialized Integer testTimeoutSeconds;

        KafkaReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized KafkaReadSchemaTransformConfiguration configuration, @UnknownKeyFor @NonNull @Initialized Boolean isTest, @UnknownKeyFor @NonNull @Initialized Integer testTimeoutSeconds) {
            configuration.validate();
            this.configuration = configuration;
            this.isTest = isTest;
            this.testTimeoutSeconds = testTimeoutSeconds;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            String inputSchema = this.configuration.getSchema();
            Integer groupId = this.configuration.hashCode() % Integer.MAX_VALUE;
            String autoOffsetReset = (String)MoreObjects.firstNonNull((Object)this.configuration.getAutoOffsetResetConfig(), (Object)"latest");
            final HashMap<String, Object> consumerConfigs = new HashMap<String, Object>((Map)MoreObjects.firstNonNull(this.configuration.getConsumerConfigUpdates(), new HashMap()));
            consumerConfigs.put("group.id", "kafka-read-provider-" + groupId);
            consumerConfigs.put("enable.auto.commit", true);
            consumerConfigs.put("auto.commit.interval.ms", 100);
            consumerConfigs.put("auto.offset.reset", autoOffsetReset);
            if (inputSchema != null && !inputSchema.isEmpty()) {
                assert (Strings.isNullOrEmpty((String)this.configuration.getConfluentSchemaRegistryUrl())) : "To read from Kafka, a schema must be provided directly or though Confluent Schema Registry, but not both.";
                Schema beamSchema = Objects.equals(this.configuration.getFormat(), "JSON") ? JsonUtils.beamSchemaFromJsonSchema((String)inputSchema) : AvroUtils.toBeamSchema((org.apache.avro.Schema)new Schema.Parser().parse(inputSchema));
                SimpleFunction valueMapper = Objects.equals(this.configuration.getFormat(), "JSON") ? JsonUtils.getJsonBytesToRowFunction((Schema)beamSchema) : AvroUtils.getAvroBytesToRowFunction((Schema)beamSchema);
                return new PTransform<PCollectionRowTuple, PCollectionRowTuple>((SerializableFunction)valueMapper, beamSchema){
                    final /* synthetic */ SerializableFunction val$valueMapper;
                    final /* synthetic */ Schema val$beamSchema;
                    {
                        this.val$valueMapper = serializableFunction;
                        this.val$beamSchema = schema;
                    }

                    public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                        KafkaIO.Read<byte[], byte[]> kafkaRead = KafkaIO.readBytes().withConsumerConfigUpdates(consumerConfigs).withConsumerFactoryFn(new ConsumerFactoryWithGcsTrustStores()).withTopic(configuration.getTopic()).withBootstrapServers(configuration.getBootstrapServers());
                        if (isTest.booleanValue()) {
                            kafkaRead = kafkaRead.withMaxReadTime(Duration.standardSeconds((long)testTimeoutSeconds.intValue()));
                        }
                        return PCollectionRowTuple.of((String)"output", (PCollection)((PCollection)((PCollection)((PCollection)input.getPipeline().apply(kafkaRead.withoutMetadata())).apply((PTransform)Values.create())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via(this.val$valueMapper))).setRowSchema(this.val$beamSchema));
                    }
                };
            }
            assert (!Strings.isNullOrEmpty((String)this.configuration.getConfluentSchemaRegistryUrl())) : "To read from Kafka, a schema must be provided directly or though Confluent Schema Registry. Neither seems to have been provided.";
            return new PTransform<PCollectionRowTuple, PCollectionRowTuple>(){

                public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                    String confluentSchemaRegUrl = configuration.getConfluentSchemaRegistryUrl();
                    String confluentSchemaRegSubject = configuration.getConfluentSchemaRegistrySubject();
                    if (confluentSchemaRegUrl == null || confluentSchemaRegSubject == null) {
                        throw new IllegalArgumentException("To read from Kafka, a schema must be provided directly or though Confluent Schema Registry. Make sure you are providing one of these parameters.");
                    }
                    KafkaIO.Read kafkaRead = KafkaIO.read().withTopic(configuration.getTopic()).withConsumerFactoryFn(new ConsumerFactoryWithGcsTrustStores()).withBootstrapServers(configuration.getBootstrapServers()).withConsumerConfigUpdates(consumerConfigs).withKeyDeserializer(ByteArrayDeserializer.class).withValueDeserializer(ConfluentSchemaRegistryDeserializerProvider.of(confluentSchemaRegUrl, confluentSchemaRegSubject));
                    if (isTest.booleanValue()) {
                        kafkaRead = kafkaRead.withMaxReadTime(Duration.standardSeconds((long)testTimeoutSeconds.intValue()));
                    }
                    PCollection kafkaValues = (PCollection)((PCollection)input.getPipeline().apply(kafkaRead.withoutMetadata())).apply((PTransform)Values.create());
                    assert (kafkaValues.getCoder().getClass() == AvroCoder.class);
                    AvroCoder coder = (AvroCoder)kafkaValues.getCoder();
                    kafkaValues = kafkaValues.setCoder((Coder)AvroUtils.schemaCoder((org.apache.avro.Schema)coder.getSchema()));
                    return PCollectionRowTuple.of((String)"output", (PCollection)((PCollection)kafkaValues.apply(Convert.toRows())));
                }
            };
        }
    }
}

