/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.kinesis.CustomOptional;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.KinesisSource;
import org.apache.beam.sdk.io.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.kinesis.ShardReadersPool;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.apache.beam.sdk.io.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KinesisReader
extends UnboundedSource.UnboundedReader<KinesisRecord> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KinesisReader.class);
    private final @UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient kinesis;
    private final @UnknownKeyFor @NonNull @Initialized KinesisSource source;
    private final @UnknownKeyFor @NonNull @Initialized CheckpointGenerator initialCheckpointGenerator;
    private final @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory;
    private final @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory rateLimitPolicyFactory;
    private final @UnknownKeyFor @NonNull @Initialized Duration upToDateThreshold;
    private final @UnknownKeyFor @NonNull @Initialized Duration backlogBytesCheckThreshold;
    private @UnknownKeyFor @NonNull @Initialized CustomOptional<@UnknownKeyFor @NonNull @Initialized KinesisRecord> currentRecord = CustomOptional.absent();
    private @UnknownKeyFor @NonNull @Initialized long lastBacklogBytes;
    private @UnknownKeyFor @NonNull @Initialized Instant backlogBytesLastCheckTime = new Instant(0L);
    private @UnknownKeyFor @NonNull @Initialized ShardReadersPool shardReadersPool;
    private final @UnknownKeyFor @NonNull @Initialized Integer maxCapacityPerShard;

    KinesisReader(@UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient kinesis, @UnknownKeyFor @NonNull @Initialized CheckpointGenerator initialCheckpointGenerator, @UnknownKeyFor @NonNull @Initialized KinesisSource source, @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory, @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory rateLimitPolicyFactory, @UnknownKeyFor @NonNull @Initialized Duration upToDateThreshold, @UnknownKeyFor @NonNull @Initialized Integer maxCapacityPerShard) {
        this(kinesis, initialCheckpointGenerator, source, watermarkPolicyFactory, rateLimitPolicyFactory, upToDateThreshold, Duration.standardSeconds((long)30L), maxCapacityPerShard);
    }

    KinesisReader(@UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient kinesis, @UnknownKeyFor @NonNull @Initialized CheckpointGenerator initialCheckpointGenerator, @UnknownKeyFor @NonNull @Initialized KinesisSource source, @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory, @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory rateLimitPolicyFactory, @UnknownKeyFor @NonNull @Initialized Duration upToDateThreshold, @UnknownKeyFor @NonNull @Initialized Duration backlogBytesCheckThreshold, @UnknownKeyFor @NonNull @Initialized Integer maxCapacityPerShard) {
        this.kinesis = (SimplifiedKinesisClient)Preconditions.checkNotNull((Object)kinesis, (Object)"kinesis");
        this.initialCheckpointGenerator = (CheckpointGenerator)Preconditions.checkNotNull((Object)initialCheckpointGenerator, (Object)"initialCheckpointGenerator");
        this.watermarkPolicyFactory = watermarkPolicyFactory;
        this.rateLimitPolicyFactory = rateLimitPolicyFactory;
        this.source = source;
        this.upToDateThreshold = upToDateThreshold;
        this.backlogBytesCheckThreshold = backlogBytesCheckThreshold;
        this.maxCapacityPerShard = maxCapacityPerShard;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
        LOG.info("Starting reader using {}", (Object)this.initialCheckpointGenerator);
        try {
            this.shardReadersPool = this.createShardReadersPool();
            this.shardReadersPool.start();
        }
        catch (TransientKinesisException e) {
            throw new IOException(e);
        }
        return this.advance();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.currentRecord = this.shardReadersPool.nextRecord();
        return this.currentRecord.isPresent();
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getCurrentRecordId() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        return this.currentRecord.get().getUniqueId();
    }

    public @UnknownKeyFor @NonNull @Initialized KinesisRecord getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        return this.currentRecord.get();
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        return this.currentRecord.get().getApproximateArrivalTimestamp();
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.shardReadersPool.stop();
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
        return this.shardReadersPool.getWatermark();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
        return this.shardReadersPool.getCheckpointMark();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized KinesisRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentSource() {
        return this.source;
    }

    public @UnknownKeyFor @NonNull @Initialized long getSplitBacklogBytes() {
        Instant latestRecordTimestamp = this.shardReadersPool.getLatestRecordTimestamp();
        if (latestRecordTimestamp.equals((Object)BoundedWindow.TIMESTAMP_MIN_VALUE)) {
            LOG.debug("Split backlog bytes for stream {} unknown", (Object)this.source.getStreamName());
            return -1L;
        }
        if (latestRecordTimestamp.plus((ReadableDuration)this.upToDateThreshold).isAfterNow()) {
            LOG.debug("Split backlog bytes for stream {} with latest record timestamp {}: 0 (latest record timestamp is up-to-date with threshold of {})", new Object[]{this.source.getStreamName(), latestRecordTimestamp, this.upToDateThreshold});
            return 0L;
        }
        if (this.backlogBytesLastCheckTime.plus((ReadableDuration)this.backlogBytesCheckThreshold).isAfterNow()) {
            LOG.debug("Split backlog bytes for {} stream with latest record timestamp {}: {} (cached value)", new Object[]{this.source.getStreamName(), latestRecordTimestamp, this.lastBacklogBytes});
            return this.lastBacklogBytes;
        }
        try {
            this.lastBacklogBytes = this.kinesis.getBacklogBytes(this.source.getStreamName(), latestRecordTimestamp);
            this.backlogBytesLastCheckTime = Instant.now();
        }
        catch (TransientKinesisException e) {
            LOG.warn("Transient exception occurred during backlog estimation for stream {}.", (Object)this.source.getStreamName(), (Object)e);
        }
        LOG.info("Split backlog bytes for {} stream with {} latest record timestamp: {}", new Object[]{this.source.getStreamName(), latestRecordTimestamp, this.lastBacklogBytes});
        return this.lastBacklogBytes;
    }

    @UnknownKeyFor @NonNull @Initialized ShardReadersPool createShardReadersPool() throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return new ShardReadersPool(this.kinesis, this.initialCheckpointGenerator.generate(this.kinesis), this.watermarkPolicyFactory, this.rateLimitPolicyFactory, this.maxCapacityPerShard);
    }
}

