/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.kinesis.producer.IKinesisProducer;
import com.amazonaws.services.kinesis.producer.KinesisProducer;
import com.amazonaws.services.kinesis.producer.KinesisProducerConfiguration;
import java.net.URI;
import java.util.Objects;
import org.apache.beam.sdk.io.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.kinesis.serde.AwsSerializableUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

class BasicKinesisProvider
implements AWSClientsProvider {
    private final @UnknownKeyFor @NonNull @Initialized String awsCredentialsProviderSerialized;
    private final @UnknownKeyFor @NonNull @Initialized Regions region;
    private final @Nullable @UnknownKeyFor @Initialized String serviceEndpoint;
    private final @UnknownKeyFor @NonNull @Initialized boolean verifyCertificate;

    BasicKinesisProvider(@UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider awsCredentialsProvider, @UnknownKeyFor @NonNull @Initialized Regions region, @Nullable @UnknownKeyFor @Initialized String serviceEndpoint, @UnknownKeyFor @NonNull @Initialized boolean verifyCertificate) {
        Preconditions.checkArgument((awsCredentialsProvider != null ? 1 : 0) != 0, (Object)"awsCredentialsProvider can not be null");
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)"region can not be null");
        this.awsCredentialsProviderSerialized = AwsSerializableUtils.serialize(awsCredentialsProvider);
        Preconditions.checkNotNull((Object)this.awsCredentialsProviderSerialized, (Object)"awsCredentialsProviderString can not be null");
        this.region = region;
        this.serviceEndpoint = serviceEndpoint;
        this.verifyCertificate = verifyCertificate;
    }

    private @UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider getCredentialsProvider() {
        return AwsSerializableUtils.deserialize(this.awsCredentialsProviderSerialized);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized AmazonKinesis getKinesisClient() {
        AmazonKinesisClientBuilder clientBuilder = (AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials(this.getCredentialsProvider());
        if (this.serviceEndpoint == null) {
            clientBuilder.withRegion(this.region);
        } else {
            clientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.serviceEndpoint, this.region.getName()));
        }
        return (AmazonKinesis)clientBuilder.build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized AmazonCloudWatch getCloudWatchClient() {
        AmazonCloudWatchClientBuilder clientBuilder = (AmazonCloudWatchClientBuilder)AmazonCloudWatchClientBuilder.standard().withCredentials(this.getCredentialsProvider());
        if (this.serviceEndpoint == null) {
            clientBuilder.withRegion(this.region);
        } else {
            clientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.serviceEndpoint, this.region.getName()));
        }
        return (AmazonCloudWatch)clientBuilder.build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized IKinesisProducer createKinesisProducer(@UnknownKeyFor @NonNull @Initialized KinesisProducerConfiguration config) {
        config.setRegion(this.region.getName());
        config.setCredentialsProvider(this.getCredentialsProvider());
        if (this.serviceEndpoint != null) {
            URI uri = URI.create(this.serviceEndpoint);
            config.setKinesisEndpoint(uri.getHost());
            config.setKinesisPort((long)uri.getPort());
        }
        config.setVerifyCertificate(this.verifyCertificate);
        return new KinesisProducer(config);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicKinesisProvider that = (BasicKinesisProvider)o;
        return this.verifyCertificate == that.verifyCertificate && Objects.equals(this.awsCredentialsProviderSerialized, that.awsCredentialsProviderSerialized) && Objects.equals(this.region, that.region) && Objects.equals(this.serviceEndpoint, that.serviceEndpoint);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.awsCredentialsProviderSerialized, this.region, this.serviceEndpoint, this.verifyCertificate);
    }
}

