/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.tracing;

import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ResponseObserver;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.StreamController;
import net.snowflake.client.jdbc.internal.google.api.gax.tracing.ApiTracer;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.javax.annotation.Nonnull;

@InternalApi
class TracedResponseObserver<ResponseT>
implements ResponseObserver<ResponseT> {
    private final ApiTracer tracer;
    private final ResponseObserver<ResponseT> innerObserver;
    private AtomicBoolean wasCancelled;

    TracedResponseObserver(@Nonnull ApiTracer tracer, @Nonnull ResponseObserver<ResponseT> innerObserver) {
        this(tracer, innerObserver, new AtomicBoolean());
    }

    TracedResponseObserver(@Nonnull ApiTracer tracer, @Nonnull ResponseObserver<ResponseT> innerObserver, @Nonnull AtomicBoolean wasCancelled) {
        this.tracer = Preconditions.checkNotNull(tracer, "tracer");
        this.innerObserver = Preconditions.checkNotNull(innerObserver, "innerObserver");
        this.wasCancelled = Preconditions.checkNotNull(wasCancelled, "wasCancelled");
    }

    @Override
    public void onStart(final StreamController controller) {
        this.innerObserver.onStart(new StreamController(){

            @Override
            public void cancel() {
                TracedResponseObserver.this.wasCancelled.set(true);
                controller.cancel();
            }

            @Override
            public void disableAutoInboundFlowControl() {
                controller.disableAutoInboundFlowControl();
            }

            @Override
            public void request(int count) {
                controller.request(count);
            }
        });
    }

    @Override
    public void onResponse(ResponseT response) {
        this.tracer.responseReceived();
        this.innerObserver.onResponse(response);
    }

    @Override
    public void onError(Throwable t) {
        if (this.wasCancelled.get()) {
            this.tracer.operationCancelled();
        } else {
            this.tracer.operationFailed(t);
        }
        this.innerObserver.onError(t);
    }

    @Override
    public void onComplete() {
        this.tracer.operationSucceeded();
        this.innerObserver.onComplete();
    }
}

