/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.PeekingIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Bytes;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class GroupNonMergingWindowsFunctions {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GroupNonMergingWindowsFunctions.class);

    static @UnknownKeyFor @NonNull @Initialized boolean isEligibleForGroupByWindow(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
        return !windowingStrategy.needsMerge() && windowingStrategy.getTimestampCombiner() == TimestampCombiner.END_OF_WINDOW && windowingStrategy.getWindowFn().windowCoder().consistentWithEquals();
    }

    static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>> groupByKeyAndWindow(@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> rdd, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy, @UnknownKeyFor @NonNull @Initialized Partitioner partitioner) {
        Coder windowCoder = windowingStrategy.getWindowFn().windowCoder();
        WindowedValue.FullWindowedValueCoder windowedKvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)KvCoder.of(keyCoder, valueCoder), (Coder)windowCoder);
        JavaPairRDD windowInKey = GroupNonMergingWindowsFunctions.bringWindowToKey(rdd, keyCoder, windowCoder, (SerializableFunction & Serializable)wv -> CoderHelpers.toByteArray(wv, windowedKvCoder));
        return windowInKey.repartitionAndSortWithinPartitions(GroupNonMergingWindowsFunctions.getPartitioner(partitioner, rdd)).mapPartitions((FlatMapFunction & Serializable)it -> new GroupByKeyIterator((Iterator<Tuple2<ByteArray, byte[]>>)it, keyCoder, windowingStrategy, windowedKvCoder)).filter(Objects::nonNull);
    }

    static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized JavaPairRDD<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> bringWindowToKey(@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> rdd, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
        return GroupNonMergingWindowsFunctions.bringWindowToKey(rdd, keyCoder, windowCoder, (SerializableFunction & Serializable)e -> e);
    }

    static <K, V, OutputT, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized JavaPairRDD<@UnknownKeyFor @NonNull @Initialized ByteArray, OutputT> bringWindowToKey(@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> rdd, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, OutputT> mappingFn) {
        if (!GroupNonMergingWindowsFunctions.isKeyAndWindowCoderConsistentWithEquals(keyCoder, windowCoder)) {
            LOG.warn("Either coder {} or {} is not consistent with equals. That might cause issues on some runners.", keyCoder, windowCoder);
        }
        return rdd.flatMapToPair((PairFlatMapFunction & Serializable)windowedValue -> {
            byte[] keyBytes = CoderHelpers.toByteArray(((KV)windowedValue.getValue()).getKey(), keyCoder);
            return Iterators.transform(windowedValue.explodeWindows().iterator(), item -> {
                Objects.requireNonNull(item, "Exploded window can not be null.");
                BoundedWindow window = (BoundedWindow)Iterables.getOnlyElement((Iterable)item.getWindows());
                byte[] windowBytes = CoderHelpers.toByteArray(window, windowCoder);
                WindowedValue valueOut = WindowedValue.of((Object)((KV)item.getValue()), (Instant)item.getTimestamp(), (BoundedWindow)window, (PaneInfo)item.getPane());
                ByteArray windowedKey = new ByteArray(Bytes.concat((byte[][])new byte[][]{keyBytes, windowBytes}));
                return new Tuple2((Object)windowedKey, mappingFn.apply((Object)valueOut));
            });
        });
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isKeyAndWindowCoderConsistentWithEquals(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> windowCoder) {
        try {
            keyCoder.verifyDeterministic();
            windowCoder.verifyDeterministic();
            return keyCoder.consistentWithEquals() && windowCoder.consistentWithEquals();
        }
        catch (Coder.NonDeterministicException ex) {
            throw new IllegalArgumentException("Coder for both key " + keyCoder + " and " + windowCoder + " must be deterministic", ex);
        }
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized Partitioner getPartitioner(@UnknownKeyFor @NonNull @Initialized Partitioner partitioner, @UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> rdd) {
        return partitioner == null ? new HashPartitioner(rdd.getNumPartitions()) : partitioner;
    }

    static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>> groupByKeyInGlobalWindow(@UnknownKeyFor @NonNull @Initialized JavaRDD<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> rdd, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, @UnknownKeyFor @NonNull @Initialized Partitioner partitioner) {
        JavaPairRDD rawKeyValues = rdd.mapToPair((PairFunction & Serializable)wv -> new Tuple2((Object)new ByteArray(CoderHelpers.toByteArray(((KV)wv.getValue()).getKey(), keyCoder)), (Object)CoderHelpers.toByteArray(((KV)wv.getValue()).getValue(), valueCoder)));
        return rawKeyValues.groupByKey().map((Function & Serializable)kvs -> WindowedValue.timestampedValueInGlobalWindow((Object)KV.of(CoderHelpers.fromByteArray(((ByteArray)kvs._1).getValue(), keyCoder), (Object)Iterables.transform((Iterable)((Iterable)kvs._2), encodedValue -> CoderHelpers.fromByteArray(encodedValue, valueCoder))), (Instant)GlobalWindow.INSTANCE.maxTimestamp(), (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING));
    }

    static class GroupByKeyIterator<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    implements Iterator<WindowedValue<KV<K, Iterable<V>>>> {
        private final @UnknownKeyFor @NonNull @Initialized PeekingIterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> inner;
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized WindowedValue.FullWindowedValueCoder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> windowedValueCoder;
        private @UnknownKeyFor @NonNull @Initialized boolean hasNext = true;
        private @UnknownKeyFor @NonNull @Initialized ByteArray currentKey = null;

        GroupByKeyIterator(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> inner, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized WindowedValue.FullWindowedValueCoder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> windowedValueCoder) throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            this.inner = Iterators.peekingIterator(inner);
            this.keyCoder = keyCoder;
            this.windowingStrategy = windowingStrategy;
            this.windowedValueCoder = windowedValueCoder;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> next() {
            while (this.inner.hasNext()) {
                ByteArray nextKey = (ByteArray)((Tuple2)this.inner.peek())._1;
                if (nextKey.equals(this.currentKey)) {
                    this.inner.next();
                    continue;
                }
                this.currentKey = nextKey;
                WindowedValue<KV<K, V>> decodedItem = this.decodeItem((Tuple2<ByteArray, byte[]>)((Tuple2)this.inner.peek()));
                return decodedItem.withValue((Object)KV.of((Object)((KV)decodedItem.getValue()).getKey(), (Object)new ValueIterator(this.inner, this.currentKey)));
            }
            this.hasNext = false;
            return null;
        }

        private V decodeValue(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] windowedValueBytes) {
            WindowedValue windowedValue = (WindowedValue)CoderHelpers.fromByteArray(windowedValueBytes, this.windowedValueCoder);
            return (V)((KV)windowedValue.getValue()).getValue();
        }

        private @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>> decodeItem(@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> item) {
            K key = CoderHelpers.fromByteArray(((ByteArray)item._1).getValue(), this.keyCoder);
            WindowedValue windowedValue = (WindowedValue)CoderHelpers.fromByteArray((byte[])item._2, this.windowedValueCoder);
            Object value = ((KV)windowedValue.getValue()).getValue();
            BoundedWindow window = (BoundedWindow)Iterables.getOnlyElement((Iterable)windowedValue.getWindows());
            Instant timestamp = this.windowingStrategy.getTimestampCombiner().assign(window, windowedValue.getTimestamp());
            return WindowedValue.of((Object)KV.of(key, (Object)value), (Instant)timestamp, (BoundedWindow)window, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING);
        }

        class ValueIterator
        implements Iterable<V> {
            @UnknownKeyFor @NonNull @Initialized boolean consumed = false;
            private final @UnknownKeyFor @NonNull @Initialized PeekingIterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> inner;
            private final @UnknownKeyFor @NonNull @Initialized ByteArray currentKey;

            ValueIterator(@UnknownKeyFor @NonNull @Initialized PeekingIterator<Tuple2<ByteArray, byte[]>> inner, ByteArray currentKey) {
                this.inner = inner;
                this.currentKey = currentKey;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Iterator<V> iterator() {
                if (this.consumed) {
                    throw new IllegalStateException("ValueIterator can't be iterated more than once,otherwise there could be data lost");
                }
                this.consumed = true;
                return new AbstractIterator<V>(){

                    protected V computeNext() {
                        if (ValueIterator.this.inner.hasNext() && ValueIterator.this.currentKey.equals(((Tuple2)((ValueIterator)ValueIterator.this).inner.peek())._1)) {
                            return GroupByKeyIterator.this.decodeValue((byte[])((Tuple2)((ValueIterator)ValueIterator.this).inner.next())._2);
                        }
                        return this.endOfData();
                    }
                };
            }
        }
    }
}

