/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.api.client.util.Strings;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.common.base.Preconditions;
import java.io.Serializable;

@InternalExtensionOnly
public class BigtableInstanceName
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BIGTABLE_V2_INSTANCE_FMT = "projects/%s/instances/%s";
    public static final String TABLE_SEPARATOR = "/tables/";
    private final String instanceName;
    private final String projectId;
    private final String instanceId;

    @InternalApi(value="For internal usage only")
    public BigtableInstanceName(String projectId, String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"projectId must be supplied");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"instanceId must be supplied");
        this.instanceName = String.format(BIGTABLE_V2_INSTANCE_FMT, projectId, instanceId);
        this.projectId = projectId;
        this.instanceId = instanceId;
    }

    public String toString() {
        return this.instanceName;
    }

    public String toTableId(String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"Table name cannot be null");
        String tablesPrefix = this.instanceName + TABLE_SEPARATOR;
        Preconditions.checkState((boolean)tableName.startsWith(tablesPrefix), (String)"'%s' does not start with '%s'", (Object)tableName, (Object)tablesPrefix);
        String tableId = tableName.substring(tablesPrefix.length()).trim();
        Preconditions.checkState((!tableId.isEmpty() ? 1 : 0) != 0, (Object)"Table id is blank");
        return tableId;
    }

    public String toTableNameStr(String tableId) {
        return this.instanceName + TABLE_SEPARATOR + tableId;
    }

    public BigtableTableName toTableName(String tableId) {
        return new BigtableTableName(this.toTableNameStr(tableId));
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public BigtableClusterName toClusterName(String clusterId) {
        return new BigtableClusterName(this.instanceName + "/clusters/" + clusterId);
    }
}

