/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.InternalOperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;

@Internal
public class InternalOperatorIOMetricGroup
extends ProxyMetricGroup<InternalOperatorMetricGroup>
implements OperatorIOMetricGroup {
    private final Counter numRecordsIn;
    private final Counter numRecordsOut;
    private final Meter numRecordsInRate;
    private final Meter numRecordsOutRate;
    private final Counter numBytesIn;
    private final Counter numBytesOut;

    public InternalOperatorIOMetricGroup(InternalOperatorMetricGroup parentMetricGroup) {
        super(parentMetricGroup);
        this.numRecordsIn = parentMetricGroup.counter("numRecordsIn");
        this.numRecordsOut = parentMetricGroup.counter("numRecordsOut");
        this.numRecordsInRate = parentMetricGroup.meter("numRecordsInPerSecond", new MeterView(this.numRecordsIn));
        this.numRecordsOutRate = parentMetricGroup.meter("numRecordsOutPerSecond", new MeterView(this.numRecordsOut));
        this.numBytesIn = parentMetricGroup.counter("numBytesIn");
        this.numBytesOut = parentMetricGroup.counter("numBytesOut");
        parentMetricGroup.meter("numBytesInPerSecond", new MeterView(this.numBytesIn));
        parentMetricGroup.meter("numBytesOutPerSecond", new MeterView(this.numBytesOut));
    }

    public Counter getNumRecordsInCounter() {
        return this.numRecordsIn;
    }

    public Counter getNumRecordsOutCounter() {
        return this.numRecordsOut;
    }

    public Meter getNumRecordsInRateMeter() {
        return this.numRecordsInRate;
    }

    public Meter getNumRecordsOutRate() {
        return this.numRecordsOutRate;
    }

    public Counter getNumBytesInCounter() {
        return this.numBytesIn;
    }

    public Counter getNumBytesOutCounter() {
        return this.numBytesOut;
    }

    public void reuseInputMetricsForTask() {
        TaskIOMetricGroup taskIO = ((InternalOperatorMetricGroup)this.parentMetricGroup).getTaskIOMetricGroup();
        taskIO.reuseRecordsInputCounter(this.numRecordsIn);
    }

    public void reuseOutputMetricsForTask() {
        TaskIOMetricGroup taskIO = ((InternalOperatorMetricGroup)this.parentMetricGroup).getTaskIOMetricGroup();
        taskIO.reuseRecordsOutputCounter(this.numRecordsOut);
    }
}

