/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import org.apache.beam.runners.core.construction.resources.PipelineResources;
import org.apache.beam.runners.flink.FlinkBatchPipelineTranslator;
import org.apache.beam.runners.flink.FlinkExecutionEnvironments;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineTranslator;
import org.apache.beam.runners.flink.FlinkStreamingPipelineTranslator;
import org.apache.beam.runners.flink.FlinkTransformOverrides;
import org.apache.beam.runners.flink.PipelineTranslationModeOptimizer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlinkPipelineExecutionEnvironment {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkPipelineExecutionEnvironment.class);
    private final @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options;
    private @UnknownKeyFor @NonNull @Initialized ExecutionEnvironment flinkBatchEnv;
    private @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment flinkStreamEnv;

    FlinkPipelineExecutionEnvironment(@UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options) {
        this.options = (FlinkPipelineOptions)Preconditions.checkNotNull((Object)options);
    }

    public void translate(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        FlinkPipelineTranslator translator;
        this.flinkBatchEnv = null;
        this.flinkStreamEnv = null;
        boolean hasUnboundedOutput = PipelineTranslationModeOptimizer.hasUnboundedOutput(pipeline);
        if (hasUnboundedOutput) {
            LOG.info("Found unbounded PCollection. Switching to streaming execution.");
            this.options.setStreaming(true);
        }
        FlinkPipelineExecutionEnvironment.prepareFilesToStageForRemoteClusterExecution(this.options);
        if (this.options.isStreaming()) {
            this.flinkStreamEnv = FlinkExecutionEnvironments.createStreamExecutionEnvironment(this.options);
            if (hasUnboundedOutput && !this.flinkStreamEnv.getCheckpointConfig().isCheckpointingEnabled()) {
                LOG.warn("UnboundedSources present which rely on checkpointing, but checkpointing is disabled.");
            }
            translator = new FlinkStreamingPipelineTranslator(this.flinkStreamEnv, this.options);
        } else {
            this.flinkBatchEnv = FlinkExecutionEnvironments.createBatchExecutionEnvironment(this.options);
            translator = new FlinkBatchPipelineTranslator(this.flinkBatchEnv, this.options);
        }
        pipeline.replaceAll(FlinkTransformOverrides.getDefaultOverrides(this.options));
        translator.translate(pipeline);
    }

    private static void prepareFilesToStageForRemoteClusterExecution(@UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options) {
        if (!options.getFlinkMaster().matches("\\[auto\\]|\\[collection\\]|\\[local\\]")) {
            PipelineResources.prepareFilesForStaging((FileStagingOptions)options);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized JobExecutionResult executePipeline() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String jobName = this.options.getJobName();
        if (this.flinkBatchEnv != null) {
            return this.flinkBatchEnv.execute(jobName);
        }
        if (this.flinkStreamEnv != null) {
            return this.flinkStreamEnv.execute(jobName);
        }
        throw new IllegalStateException("The Pipeline has not yet been translated.");
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized JobGraph getJobGraph(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        this.translate(p);
        StreamGraph streamGraph = this.flinkStreamEnv.getStreamGraph();
        streamGraph.setJobName(p.getOptions().getJobName());
        return streamGraph.getJobGraph();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized ExecutionEnvironment getBatchExecutionEnvironment() {
        return this.flinkBatchEnv;
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment getStreamExecutionEnvironment() {
        return this.flinkStreamEnv;
    }
}

