/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.io;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
public final class Providers {
    private Providers() {
    }

    public static <T extends Identifyable> @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> loadProviders(@UnknownKeyFor @NonNull @Initialized Class<T> klass) {
        HashMap<String, Identifyable> providers = new HashMap<String, Identifyable>();
        for (Identifyable provider : ServiceLoader.load(klass)) {
            if (provider.identifier().equals("avro")) {
                if (provider.getClass().getName().startsWith("org.apache.beam.sdk.extensions.avro")) {
                    providers.put(provider.identifier(), provider);
                    continue;
                }
                providers.putIfAbsent(provider.identifier(), provider);
                continue;
            }
            Preconditions.checkState((!providers.containsKey(provider.identifier()) ? 1 : 0) != 0, (String)"Duplicate providers exist with identifier `%s` for class %s.", (Object)provider.identifier(), klass);
            providers.put(provider.identifier(), provider);
        }
        return providers;
    }

    public static interface Identifyable {
        public @UnknownKeyFor @NonNull @Initialized String identifier();
    }
}

