/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PrintableString;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Ls
extends FsCommand {
    private static final String OPTION_PATHONLY = "C";
    private static final String OPTION_DIRECTORY = "d";
    private static final String OPTION_HUMAN = "h";
    private static final String OPTION_HIDENONPRINTABLE = "q";
    private static final String OPTION_RECURSIVE = "R";
    private static final String OPTION_REVERSE = "r";
    private static final String OPTION_MTIME = "t";
    private static final String OPTION_ATIME = "u";
    private static final String OPTION_SIZE = "S";
    private static final String OPTION_ECPOLICY = "e";
    public static final String NAME = "ls";
    public static final String USAGE = "[-C] [-d] [-h] [-q] [-R] [-t] [-S] [-r] [-u] [-e] [<path> ...]";
    public static final String DESCRIPTION = "List the contents that match the specified file pattern. If path is not specified, the contents of /user/<currentUser> will be listed. For a directory a list of its direct children is returned (unless -d option is specified).\n\nDirectory entries are of the form:\n\tpermissions - userId groupId sizeOfDirectory(in bytes) modificationDate(yyyy-MM-dd HH:mm) directoryName\n\nand file entries are of the form:\n\tpermissions numberOfReplicas userId groupId sizeOfFile(in bytes) modificationDate(yyyy-MM-dd HH:mm) fileName\n\n  -C  Display the paths of files and directories only.\n  -d  Directories are listed as plain files.\n  -h  Formats the sizes of files in a human-readable fashion\n      rather than a number of bytes.\n  -q  Print ? instead of non-printable characters.\n  -R  Recursively list the contents of directories.\n  -t  Sort files by modification time (most recent first).\n  -S  Sort files by size.\n  -r  Reverse the order of the sort.\n  -u  Use time of last access instead of modification for\n      display and sorting.\n  -e  Display the erasure coding policy of files and directories.\n";
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    protected int maxRepl = 3;
    protected int maxLen = 10;
    protected int maxOwner = 0;
    protected int maxGroup = 0;
    protected String lineFormat;
    private boolean pathOnly;
    protected boolean dirRecurse;
    private boolean orderReverse;
    private boolean orderTime;
    private boolean orderSize;
    private boolean useAtime;
    private boolean displayECPolicy;
    private Comparator<PathData> orderComparator;
    protected boolean humanReadable = false;
    private boolean hideNonPrintable = false;

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Ls.class, "-ls");
        factory.addClass(Lsr.class, "-lsr");
    }

    protected Ls() {
    }

    protected Ls(Configuration conf) {
        super(conf);
    }

    protected String formatSize(long size) {
        return this.humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String(size, "", 1) : String.valueOf(size);
    }

    @Override
    protected void processOptions(LinkedList<String> args) throws IOException {
        CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, OPTION_PATHONLY, OPTION_DIRECTORY, OPTION_HUMAN, OPTION_HIDENONPRINTABLE, OPTION_RECURSIVE, OPTION_REVERSE, OPTION_MTIME, OPTION_SIZE, OPTION_ATIME, OPTION_ECPOLICY);
        cf.parse(args);
        this.pathOnly = cf.getOpt(OPTION_PATHONLY);
        this.dirRecurse = !cf.getOpt(OPTION_DIRECTORY);
        this.setRecursive(cf.getOpt(OPTION_RECURSIVE) && this.dirRecurse);
        this.humanReadable = cf.getOpt(OPTION_HUMAN);
        this.hideNonPrintable = cf.getOpt(OPTION_HIDENONPRINTABLE);
        this.orderReverse = cf.getOpt(OPTION_REVERSE);
        this.orderTime = cf.getOpt(OPTION_MTIME);
        this.orderSize = !this.orderTime && cf.getOpt(OPTION_SIZE);
        this.useAtime = cf.getOpt(OPTION_ATIME);
        this.displayECPolicy = cf.getOpt(OPTION_ECPOLICY);
        if (args.isEmpty()) {
            args.add(".");
        }
        this.initialiseOrderComparator();
    }

    @VisibleForTesting
    boolean isPathOnly() {
        return this.pathOnly;
    }

    @VisibleForTesting
    boolean isDirRecurse() {
        return this.dirRecurse;
    }

    @VisibleForTesting
    boolean isHumanReadable() {
        return this.humanReadable;
    }

    @VisibleForTesting
    private boolean isHideNonPrintable() {
        return this.hideNonPrintable;
    }

    @VisibleForTesting
    boolean isOrderReverse() {
        return this.orderReverse;
    }

    @VisibleForTesting
    boolean isOrderTime() {
        return this.orderTime;
    }

    @VisibleForTesting
    boolean isOrderSize() {
        return this.orderSize;
    }

    @VisibleForTesting
    boolean isUseAtime() {
        return this.useAtime;
    }

    @VisibleForTesting
    boolean isDisplayECPolicy() {
        return this.displayECPolicy;
    }

    @Override
    protected void processPathArgument(PathData item) throws IOException {
        if (this.isDisplayECPolicy() && item.fs.getContentSummary(item.path).getErasureCodingPolicy() == null) {
            throw new UnsupportedOperationException("FileSystem " + item.fs.getUri() + " does not support Erasure Coding");
        }
        if (this.dirRecurse && item.stat.isDirectory()) {
            this.recursePath(item);
        } else {
            super.processPathArgument(item);
        }
    }

    @Override
    protected boolean isSorted() {
        return !this.isRecursive() || this.isOrderTime() || this.isOrderSize() || this.isOrderReverse();
    }

    @Override
    protected int getListingGroupSize() {
        if (this.pathOnly) {
            return 0;
        }
        return 100;
    }

    @Override
    protected void processPaths(PathData parent, PathData ... items) throws IOException {
        if (parent != null && !this.isRecursive() && items.length != 0) {
            if (!this.pathOnly) {
                this.out.println("Found " + items.length + " items");
            }
            Arrays.sort(items, this.getOrderComparator());
        }
        if (!this.pathOnly) {
            this.adjustColumnWidths(items);
        }
        super.processPaths(parent, items);
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        if (this.pathOnly) {
            this.out.println(item.toString());
            return;
        }
        FileStatus stat = item.stat;
        if (this.displayECPolicy) {
            ContentSummary contentSummary = item.fs.getContentSummary(item.path);
            String line = String.format(this.lineFormat, stat.isDirectory() ? OPTION_DIRECTORY : "-", stat.getPermission() + (stat.hasAcl() ? "+" : " "), stat.isFile() ? Short.valueOf(stat.getReplication()) : "-", stat.getOwner(), stat.getGroup(), contentSummary.getErasureCodingPolicy(), this.formatSize(stat.getLen()), this.dateFormat.format(new Date(this.isUseAtime() ? stat.getAccessTime() : stat.getModificationTime())), this.isHideNonPrintable() ? new PrintableString(item.toString()) : item);
            this.out.println(line);
        } else {
            String line = String.format(this.lineFormat, stat.isDirectory() ? OPTION_DIRECTORY : "-", stat.getPermission() + (stat.hasAcl() ? "+" : " "), stat.isFile() ? Short.valueOf(stat.getReplication()) : "-", stat.getOwner(), stat.getGroup(), this.formatSize(stat.getLen()), this.dateFormat.format(new Date(this.isUseAtime() ? stat.getAccessTime() : stat.getModificationTime())), this.isHideNonPrintable() ? new PrintableString(item.toString()) : item);
            this.out.println(line);
        }
    }

    private void adjustColumnWidths(PathData[] items) throws IOException {
        for (PathData item : items) {
            FileStatus stat = item.stat;
            this.maxRepl = this.maxLength(this.maxRepl, stat.getReplication());
            this.maxLen = this.maxLength(this.maxLen, stat.getLen());
            this.maxOwner = this.maxLength(this.maxOwner, stat.getOwner());
            this.maxGroup = this.maxLength(this.maxGroup, stat.getGroup());
        }
        StringBuilder fmt = new StringBuilder();
        fmt.append("%s%s").append("%" + this.maxRepl + "s ").append(this.maxOwner > 0 ? "%-" + this.maxOwner + "s " : "%s").append(this.maxGroup > 0 ? "%-" + this.maxGroup + "s " : "%s");
        if (this.displayECPolicy) {
            int maxEC = 0;
            for (PathData item : items) {
                ContentSummary contentSummary = item.fs.getContentSummary(item.path);
                maxEC = this.maxLength(maxEC, contentSummary.getErasureCodingPolicy());
            }
            fmt.append(maxEC > 0 ? "%-" + maxEC + "s " : "%s");
        }
        fmt.append("%" + this.maxLen + "s ");
        fmt.append("%s %s");
        this.lineFormat = fmt.toString();
    }

    private int maxLength(int n, Object value) {
        return Math.max(n, value != null ? String.valueOf(value).length() : 0);
    }

    private Comparator<PathData> getOrderComparator() {
        return this.orderComparator;
    }

    private void initialiseOrderComparator() {
        this.orderComparator = this.isOrderTime() ? new Comparator<PathData>(){

            @Override
            public int compare(PathData o1, PathData o2) {
                Long o1Time = Ls.this.isUseAtime() ? o1.stat.getAccessTime() : o1.stat.getModificationTime();
                Long o2Time = Ls.this.isUseAtime() ? o2.stat.getAccessTime() : o2.stat.getModificationTime();
                return o2Time.compareTo(o1Time) * (Ls.this.isOrderReverse() ? -1 : 1);
            }
        } : (this.isOrderSize() ? new Comparator<PathData>(){

            @Override
            public int compare(PathData o1, PathData o2) {
                Long o1Length = o1.stat.getLen();
                Long o2Length = o2.stat.getLen();
                return o2Length.compareTo(o1Length) * (Ls.this.isOrderReverse() ? -1 : 1);
            }
        } : new Comparator<PathData>(){

            @Override
            public int compare(PathData o1, PathData o2) {
                return o1.compareTo(o2) * (Ls.this.isOrderReverse() ? -1 : 1);
            }
        });
    }

    public static class Lsr
    extends Ls {
        public static final String NAME = "lsr";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            args.addFirst("-R");
            super.processOptions(args);
        }

        @Override
        public String getReplacementCommand() {
            return "ls -R";
        }
    }
}

