/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.ExceptionMethod;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.Throw;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Opcodes;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokerFactory;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.reflect.OnTimerInvoker;
import org.apache.beam.sdk.transforms.reflect.OnTimerInvokers;
import org.apache.beam.sdk.transforms.reflect.StableInvokerNamingStrategy;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultTracker;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Primitives;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

class ByteBuddyDoFnInvokerFactory
implements DoFnInvokerFactory {
    public static final String SETUP_CONTEXT_PARAMETER_METHOD = "setupContext";
    public static final String START_BUNDLE_CONTEXT_PARAMETER_METHOD = "startBundleContext";
    public static final String FINISH_BUNDLE_CONTEXT_PARAMETER_METHOD = "finishBundleContext";
    public static final String PROCESS_CONTEXT_PARAMETER_METHOD = "processContext";
    public static final String ELEMENT_PARAMETER_METHOD = "element";
    public static final String SCHEMA_ELEMENT_PARAMETER_METHOD = "schemaElement";
    public static final String TIMESTAMP_PARAMETER_METHOD = "timestamp";
    public static final String BUNDLE_FINALIZER_PARAMETER_METHOD = "bundleFinalizer";
    public static final String OUTPUT_ROW_RECEIVER_METHOD = "outputRowReceiver";
    public static final String TIME_DOMAIN_PARAMETER_METHOD = "timeDomain";
    public static final String OUTPUT_PARAMETER_METHOD = "outputReceiver";
    public static final String TAGGED_OUTPUT_PARAMETER_METHOD = "taggedOutputReceiver";
    public static final String ON_TIMER_CONTEXT_PARAMETER_METHOD = "onTimerContext";
    public static final String WINDOW_PARAMETER_METHOD = "window";
    public static final String PANE_INFO_PARAMETER_METHOD = "paneInfo";
    public static final String PIPELINE_OPTIONS_PARAMETER_METHOD = "pipelineOptions";
    public static final String RESTRICTION_PARAMETER_METHOD = "restriction";
    public static final String RESTRICTION_TRACKER_PARAMETER_METHOD = "restrictionTracker";
    public static final String WATERMARK_ESTIMATOR_PARAMETER_METHOD = "watermarkEstimator";
    public static final String WATERMARK_ESTIMATOR_STATE_PARAMETER_METHOD = "watermarkEstimatorState";
    public static final String STATE_PARAMETER_METHOD = "state";
    public static final String TIMER_PARAMETER_METHOD = "timer";
    public static final String SIDE_INPUT_PARAMETER_METHOD = "sideInput";
    public static final String TIMER_FAMILY_PARAMETER_METHOD = "timerFamily";
    public static final String TIMER_ID_PARAMETER_METHOD = "timerId";
    public static final String KEY_PARAMETER_METHOD = "key";
    private static final ByteBuddyDoFnInvokerFactory INSTANCE = new ByteBuddyDoFnInvokerFactory();
    private static final String FN_DELEGATE_FIELD_NAME = "delegate";
    private final Map<Class<?>, Constructor<?>> byteBuddyInvokerConstructorCache = new ConcurrentHashMap();

    public static ByteBuddyDoFnInvokerFactory only() {
        return INSTANCE;
    }

    @Override
    public <InputT, OutputT> DoFnInvoker<InputT, OutputT> invokerFor(DoFn<InputT, OutputT> fn) {
        return this.newByteBuddyInvoker(fn);
    }

    private ByteBuddyDoFnInvokerFactory() {
    }

    public <InputT, OutputT> DoFnInvoker<InputT, OutputT> newByteBuddyInvoker(DoFn<InputT, OutputT> fn) {
        return this.newByteBuddyInvoker(DoFnSignatures.getSignature(fn.getClass()), fn);
    }

    public <InputT, OutputT> DoFnInvoker<InputT, OutputT> newByteBuddyInvoker(DoFnSignature signature, DoFn<InputT, OutputT> fn) {
        Preconditions.checkArgument((boolean)signature.fnClass().equals(fn.getClass()), (String)"Signature is for class %s, but fn is of class %s", signature.fnClass(), fn.getClass());
        try {
            DoFnInvokerBase invoker = (DoFnInvokerBase)this.getByteBuddyInvokerConstructor(signature).newInstance(fn);
            for (DoFnSignature.OnTimerMethod onTimerMethod : signature.onTimerMethods().values()) {
                invoker.addOnTimerInvoker(onTimerMethod.id(), OnTimerInvokers.forTimer(fn, onTimerMethod.id()));
            }
            for (DoFnSignature.OnTimerFamilyMethod onTimerFamilyMethod : signature.onTimerFamilyMethods().values()) {
                invoker.addOnTimerFamilyInvoker(onTimerFamilyMethod.id(), OnTimerInvokers.forTimerFamily(fn, onTimerFamilyMethod.id()));
            }
            return invoker;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Unable to bind invoker for " + fn.getClass(), e);
        }
    }

    private Constructor<?> getByteBuddyInvokerConstructor(DoFnSignature signature) {
        Class<? extends DoFn<?, ?>> fnClass = signature.fnClass();
        return this.byteBuddyInvokerConstructorCache.computeIfAbsent(fnClass, clazz -> {
            Class<DoFnInvoker<?, ?>> invokerClass = ByteBuddyDoFnInvokerFactory.generateInvokerClass(signature);
            try {
                return invokerClass.getConstructor((Class<?>)clazz);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Class<? extends DoFnInvoker<?, ?>> generateInvokerClass(DoFnSignature signature) {
        Class<DoFn<?, ?>> fnClass = signature.fnClass();
        TypeDescription.ForLoadedType clazzDescription = new TypeDescription.ForLoadedType(fnClass);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().with((NamingStrategy)StableInvokerNamingStrategy.forDoFnClass(fnClass).withSuffix(DoFnInvoker.class.getSimpleName())).subclass(DoFnInvokerBase.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameter(fnClass).intercept((Implementation)new InvokerConstructor(DoFnInvokerBase.class)).method((ElementMatcher)ElementMatchers.named((String)"invokeProcessElement")).intercept((Implementation)new ProcessElementDelegation((TypeDescription)clazzDescription, signature.processElement())).method((ElementMatcher)ElementMatchers.named((String)"invokeStartBundle")).intercept(ByteBuddyDoFnInvokerFactory.delegateMethodWithExtraParametersOrNoop((TypeDescription)clazzDescription, signature.startBundle())).method((ElementMatcher)ElementMatchers.named((String)"invokeFinishBundle")).intercept(ByteBuddyDoFnInvokerFactory.delegateMethodWithExtraParametersOrNoop((TypeDescription)clazzDescription, signature.finishBundle())).method((ElementMatcher)ElementMatchers.named((String)"invokeSetup")).intercept(ByteBuddyDoFnInvokerFactory.delegateMethodWithExtraParametersOrNoop((TypeDescription)clazzDescription, signature.setup())).method((ElementMatcher)ElementMatchers.named((String)"invokeTeardown")).intercept(ByteBuddyDoFnInvokerFactory.delegateOrNoop((TypeDescription)clazzDescription, signature.teardown())).method((ElementMatcher)ElementMatchers.named((String)"invokeOnWindowExpiration")).intercept(ByteBuddyDoFnInvokerFactory.delegateMethodWithExtraParametersOrNoop((TypeDescription)clazzDescription, signature.onWindowExpiration())).method((ElementMatcher)ElementMatchers.named((String)"invokeGetInitialRestriction")).intercept(ByteBuddyDoFnInvokerFactory.delegateMethodWithExtraParametersOrThrow((TypeDescription)clazzDescription, signature.getInitialRestriction())).method((ElementMatcher)ElementMatchers.named((String)"invokeSplitRestriction")).intercept(ByteBuddyDoFnInvokerFactory.splitRestrictionDelegation((TypeDescription)clazzDescription, signature.splitRestriction())).method((ElementMatcher)ElementMatchers.named((String)"invokeTruncateRestriction")).intercept(ByteBuddyDoFnInvokerFactory.truncateRestrictionDelegation((TypeDescription)clazzDescription, signature.truncateRestriction())).method((ElementMatcher)ElementMatchers.named((String)"invokeGetRestrictionCoder")).intercept(ByteBuddyDoFnInvokerFactory.getRestrictionCoderDelegation((TypeDescription)clazzDescription, signature)).method((ElementMatcher)ElementMatchers.named((String)"invokeNewTracker")).intercept(ByteBuddyDoFnInvokerFactory.newTrackerDelegation((TypeDescription)clazzDescription, signature.newTracker())).method((ElementMatcher)ElementMatchers.named((String)"invokeGetSize")).intercept(ByteBuddyDoFnInvokerFactory.getSizeDelegation((TypeDescription)clazzDescription, signature.getSize())).method((ElementMatcher)ElementMatchers.named((String)"invokeGetWatermarkEstimatorStateCoder")).intercept(ByteBuddyDoFnInvokerFactory.getWatermarkEstimatorStateCoderDelegation((TypeDescription)clazzDescription, signature)).method((ElementMatcher)ElementMatchers.named((String)"invokeGetInitialWatermarkEstimatorState")).intercept(ByteBuddyDoFnInvokerFactory.getInitialWatermarkEstimatorStateDelegation((TypeDescription)clazzDescription, signature.getInitialWatermarkEstimatorState())).method((ElementMatcher)ElementMatchers.named((String)"invokeNewWatermarkEstimator")).intercept(ByteBuddyDoFnInvokerFactory.newWatermarkEstimatorDelegation((TypeDescription)clazzDescription, signature.newWatermarkEstimator()));
        DynamicType.Unloaded unloaded = builder.make();
        Class res = unloaded.load(ReflectHelpers.findClassLoader(fnClass.getClassLoader()), ByteBuddyDoFnInvokerFactory.getClassLoadingStrategy(fnClass)).getLoaded();
        return res;
    }

    private static ClassLoadingStrategy<ClassLoader> getClassLoadingStrategy(Class<?> targetClass) {
        try {
            ClassLoadingStrategy.Default strategy;
            if (ClassInjector.UsingLookup.isAvailable()) {
                Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
                Object lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
                Method privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
                Object privateLookup = privateLookupIn.invoke(null, targetClass, lookup);
                strategy = ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
            } else if (ClassInjector.UsingReflection.isAvailable()) {
                strategy = ClassLoadingStrategy.Default.INJECTION;
            } else {
                throw new IllegalStateException("No code generation strategy available");
            }
            return strategy;
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static Implementation getRestrictionCoderDelegation(TypeDescription doFnType, DoFnSignature signature) {
        if (signature.processElement().isSplittable()) {
            if (signature.getRestrictionCoder() == null) {
                return MethodDelegation.to((Object)new DefaultRestrictionCoder(signature.getInitialRestriction().restrictionT()));
            }
            return new DowncastingParametersMethodDelegation(doFnType, signature.getRestrictionCoder().targetMethod());
        }
        return ExceptionMethod.throwing(UnsupportedOperationException.class);
    }

    private static Implementation getWatermarkEstimatorStateCoderDelegation(TypeDescription doFnType, DoFnSignature signature) {
        if (signature.processElement().isSplittable()) {
            if (signature.getWatermarkEstimatorStateCoder() == null) {
                return MethodDelegation.to((Object)new DefaultWatermarkEstimatorStateCoder(signature.getInitialWatermarkEstimatorState() == null ? TypeDescriptors.voids() : signature.getInitialWatermarkEstimatorState().watermarkEstimatorStateT()));
            }
            return new DowncastingParametersMethodDelegation(doFnType, signature.getWatermarkEstimatorStateCoder().targetMethod());
        }
        return ExceptionMethod.throwing(UnsupportedOperationException.class);
    }

    private static Implementation splitRestrictionDelegation(TypeDescription doFnType, DoFnSignature.SplitRestrictionMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultSplitRestriction.class);
        }
        return new DoFnMethodWithExtraParametersDelegation(doFnType, signature);
    }

    private static Implementation truncateRestrictionDelegation(TypeDescription doFnType, DoFnSignature.TruncateRestrictionMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultTruncateRestriction.class);
        }
        return new DoFnMethodWithExtraParametersDelegation(doFnType, signature);
    }

    private static Implementation getInitialWatermarkEstimatorStateDelegation(TypeDescription doFnType, @Nullable DoFnSignature.GetInitialWatermarkEstimatorStateMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultGetInitialWatermarkEstimatorState.class);
        }
        return new DoFnMethodWithExtraParametersDelegation(doFnType, signature);
    }

    private static Implementation newWatermarkEstimatorDelegation(TypeDescription doFnType, @Nullable DoFnSignature.NewWatermarkEstimatorMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultNewWatermarkEstimator.class);
        }
        return new DoFnMethodWithExtraParametersDelegation(doFnType, signature);
    }

    private static Implementation newTrackerDelegation(TypeDescription doFnType, @Nullable DoFnSignature.NewTrackerMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultNewTracker.class);
        }
        return new DoFnMethodWithExtraParametersDelegation(doFnType, signature);
    }

    private static Implementation getSizeDelegation(TypeDescription doFnType, @Nullable DoFnSignature.GetSizeMethod signature) {
        if (signature == null) {
            return MethodDelegation.to(DefaultGetSize.class);
        }
        return new GetSizeDelegation(doFnType, signature);
    }

    private static Implementation delegateOrNoop(TypeDescription doFnType, DoFnSignature.DoFnMethod method) {
        return method == null ? FixedValue.originType() : new DoFnMethodDelegation(doFnType, method.targetMethod());
    }

    private static Implementation delegateMethodWithExtraParametersOrNoop(TypeDescription doFnType, DoFnSignature.MethodWithExtraParameters method) {
        return method == null ? FixedValue.originType() : new DoFnMethodWithExtraParametersDelegation(doFnType, method);
    }

    private static Implementation delegateMethodWithExtraParametersOrThrow(TypeDescription doFnType, DoFnSignature.MethodWithExtraParameters method) {
        return method == null ? ExceptionMethod.throwing(UnsupportedOperationException.class) : new DoFnMethodWithExtraParametersDelegation(doFnType, method);
    }

    private static MethodDescription getExtraContextFactoryMethodDescription(String methodName, Class<?> ... parameterTypes) {
        try {
            return new MethodDescription.ForLoadedMethod(DoFnInvoker.ArgumentProvider.class.getMethod(methodName, parameterTypes));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to locate required method %s.%s", DoFnInvoker.ArgumentProvider.class.getSimpleName(), methodName), e);
        }
    }

    private static StackManipulation simpleExtraContextParameter(String methodName) {
        return new StackManipulation.Compound(new StackManipulation[]{MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(methodName, new Class[0]))});
    }

    static StackManipulation getExtraContextParameter(DoFnSignature.Parameter parameter, final StackManipulation pushDelegate) {
        return parameter.match(new DoFnSignature.Parameter.Cases<StackManipulation>(){

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.StartBundleContextParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.START_BUNDLE_CONTEXT_PARAMETER_METHOD, new Class[]{DoFn.class}))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.FinishBundleContextParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.FINISH_BUNDLE_CONTEXT_PARAMETER_METHOD, new Class[]{DoFn.class}))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.ProcessContextParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.PROCESS_CONTEXT_PARAMETER_METHOD, new Class[]{DoFn.class}))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.ElementParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.ELEMENT_PARAMETER_METHOD, new Class[]{DoFn.class})), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(p.elementT().getRawType()))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.SchemaElementParameter p) {
                TypeDescription.ForLoadedType elementType = new TypeDescription.ForLoadedType(p.elementT().getRawType());
                TypeDescription.ForLoadedType castType = elementType.isPrimitive() ? new TypeDescription.ForLoadedType(Primitives.wrap(p.elementT().getRawType())) : elementType;
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{IntegerConstant.forValue((int)p.index()), MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.SCHEMA_ELEMENT_PARAMETER_METHOD, new Class[]{Integer.TYPE})), TypeCasting.to((TypeDefinition)castType)});
                if (elementType.isPrimitive()) {
                    stackManipulation = new StackManipulation.Compound(new StackManipulation[]{stackManipulation, Assigner.DEFAULT.assign(elementType.asBoxed().asGenericType(), elementType.asUnboxed().asGenericType(), Assigner.Typing.STATIC)});
                }
                return stackManipulation;
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TimestampParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TIMESTAMP_PARAMETER_METHOD, new Class[]{DoFn.class}))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.BundleFinalizerParameter p) {
                return ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.BUNDLE_FINALIZER_PARAMETER_METHOD);
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TimeDomainParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TIME_DOMAIN_PARAMETER_METHOD, new Class[]{DoFn.class}))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.OutputReceiverParameter p) {
                String method = p.isRowReceiver() ? ByteBuddyDoFnInvokerFactory.OUTPUT_ROW_RECEIVER_METHOD : ByteBuddyDoFnInvokerFactory.OUTPUT_PARAMETER_METHOD;
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(method, new Class[]{DoFn.class}))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TaggedOutputReceiverParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TAGGED_OUTPUT_PARAMETER_METHOD, new Class[]{DoFn.class}))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.OnTimerContextParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.ON_TIMER_CONTEXT_PARAMETER_METHOD, new Class[]{DoFn.class}))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.WindowParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.WINDOW_PARAMETER_METHOD), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(p.windowT().getRawType()))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.PaneInfoParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.PANE_INFO_PARAMETER_METHOD, new Class[]{DoFn.class}))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.RestrictionParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.RESTRICTION_PARAMETER_METHOD), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(p.restrictionT().getRawType()))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.RestrictionTrackerParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.RESTRICTION_TRACKER_PARAMETER_METHOD), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(p.trackerT().getRawType()))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.WatermarkEstimatorParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.WATERMARK_ESTIMATOR_PARAMETER_METHOD), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(p.estimatorT().getRawType()))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.WatermarkEstimatorStateParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.WATERMARK_ESTIMATOR_STATE_PARAMETER_METHOD), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(p.estimatorStateT().getRawType()))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.StateParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{new TextConstant(p.referent().id()), IntegerConstant.forValue((boolean)p.alwaysFetched()), MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.STATE_PARAMETER_METHOD, new Class[]{String.class, Boolean.TYPE})), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(p.referent().stateType().getRawType()))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TimerParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{new TextConstant(p.referent().id()), MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TIMER_PARAMETER_METHOD, new Class[]{String.class})), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(Timer.class))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TimerFamilyParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{new TextConstant(p.referent().id()), MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TIMER_FAMILY_PARAMETER_METHOD, new Class[]{String.class})), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(TimerMap.class))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.PipelineOptionsParameter p) {
                return ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.PIPELINE_OPTIONS_PARAMETER_METHOD);
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.SideInputParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{new TextConstant(p.sideInputId()), MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.SIDE_INPUT_PARAMETER_METHOD, new Class[]{String.class})), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(p.elementT().getRawType()))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.TimerIdParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{pushDelegate, MethodInvocation.invoke((MethodDescription)ByteBuddyDoFnInvokerFactory.getExtraContextFactoryMethodDescription(ByteBuddyDoFnInvokerFactory.TIMER_ID_PARAMETER_METHOD, new Class[]{DoFn.class}))});
            }

            @Override
            public StackManipulation dispatch(DoFnSignature.Parameter.KeyParameter p) {
                return new StackManipulation.Compound(new StackManipulation[]{ByteBuddyDoFnInvokerFactory.simpleExtraContextParameter(ByteBuddyDoFnInvokerFactory.KEY_PARAMETER_METHOD), TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(p.keyT().getRawType()))});
            }
        });
    }

    private static final class InvokerConstructor
    implements Implementation {
        Class<? extends DoFnInvoker> clazz;

        InvokerConstructor(Class<? extends DoFnInvoker> clazz) {
            this.clazz = clazz;
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                StackManipulation.Size size = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(0), MethodVariableAccess.REFERENCE.loadFrom(1), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(this.clazz).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{DoFn.class})))).getOnly())), MethodReturn.VOID}).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            };
        }
    }

    private static class UserCodeMethodInvocation
    implements StackManipulation {
        private final @Nullable Integer returnVarIndex;
        private final MethodDescription targetMethod;
        private final MethodDescription instrumentedMethod;
        private final TypeDescription returnType;
        private final Label wrapStart = new Label();
        private final Label wrapEnd = new Label();
        private final Label tryBlockStart = new Label();
        private final Label tryBlockEnd = new Label();
        private final Label catchBlockStart = new Label();
        private final Label catchBlockEnd = new Label();
        private final MethodDescription createUserCodeException;

        UserCodeMethodInvocation(@Nullable Integer returnVarIndex, MethodDescription targetMethod, MethodDescription instrumentedMethod) {
            this.returnVarIndex = returnVarIndex;
            this.targetMethod = targetMethod;
            this.instrumentedMethod = instrumentedMethod;
            this.returnType = targetMethod.getReturnType().asErasure();
            boolean targetMethodReturnsVoid = TypeDescription.VOID.equals(this.returnType);
            Preconditions.checkArgument((returnVarIndex == null == targetMethodReturnsVoid ? 1 : 0) != 0, (Object)"returnVarIndex should be defined if and only if the target method has a return value");
            try {
                this.createUserCodeException = new MethodDescription.ForLoadedMethod(UserCodeException.class.getDeclaredMethod("wrap", Throwable.class));
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException("Unable to find UserCodeException.wrap", e);
            }
        }

        public boolean isValid() {
            return true;
        }

        private Object describeType(Type type) {
            switch (type.getSort()) {
                case 10: {
                    return type.getInternalName();
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return Opcodes.INTEGER;
                }
                case 7: {
                    return Opcodes.LONG;
                }
                case 8: {
                    return Opcodes.DOUBLE;
                }
                case 6: {
                    return Opcodes.FLOAT;
                }
            }
            throw new IllegalArgumentException("Unhandled type as method argument: " + type);
        }

        private void visitFrame(MethodVisitor mv, boolean localsIncludeReturn, @Nullable String stackTop) {
            Object[] objectArray;
            boolean hasReturnLocal = this.returnVarIndex != null && localsIncludeReturn;
            Type[] localTypes = Type.getArgumentTypes((String)this.instrumentedMethod.getDescriptor());
            Object[] locals = new Object[1 + localTypes.length + (hasReturnLocal ? 1 : 0)];
            locals[0] = this.instrumentedMethod.getReceiverType().asErasure().getInternalName();
            for (int i = 0; i < localTypes.length; ++i) {
                locals[i + 1] = this.describeType(localTypes[i]);
            }
            if (hasReturnLocal) {
                locals[locals.length - 1] = this.describeType(Type.getReturnType((String)this.targetMethod.getDescriptor()));
            }
            if (stackTop == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = stackTop;
            }
            Object[] stack = objectArray;
            mv.visitFrame(-1, locals.length, locals, stack.length, stack);
        }

        public StackManipulation.Size apply(MethodVisitor mv, Implementation.Context context) {
            Type returnType;
            StackManipulation.Size size = new StackManipulation.Size(0, 0);
            mv.visitLabel(this.wrapStart);
            String throwableName = new TypeDescription.ForLoadedType(Throwable.class).getInternalName();
            mv.visitTryCatchBlock(this.tryBlockStart, this.tryBlockEnd, this.catchBlockStart, throwableName);
            mv.visitLabel(this.tryBlockStart);
            size = size.aggregate(MethodInvocation.invoke((MethodDescription)this.targetMethod).apply(mv, context));
            if (this.returnVarIndex != null) {
                returnType = Type.getReturnType((String)this.targetMethod.getDescriptor());
                mv.visitVarInsn(returnType.getOpcode(54), this.returnVarIndex.intValue());
                size = size.aggregate(new StackManipulation.Size(-1, 0));
            }
            mv.visitJumpInsn(167, this.catchBlockEnd);
            mv.visitLabel(this.tryBlockEnd);
            mv.visitLabel(this.catchBlockStart);
            this.visitFrame(mv, false, throwableName);
            size = size.aggregate(new StackManipulation.Compound(new StackManipulation[]{MethodInvocation.invoke((MethodDescription)this.createUserCodeException), Throw.INSTANCE}).apply(mv, context));
            mv.visitLabel(this.catchBlockEnd);
            this.visitFrame(mv, true, null);
            if (this.returnVarIndex != null) {
                returnType = Type.getReturnType((String)this.targetMethod.getDescriptor());
                mv.visitVarInsn(returnType.getOpcode(21), this.returnVarIndex.intValue());
                size = size.aggregate(new StackManipulation.Size(1, 0));
            }
            mv.visitLabel(this.wrapEnd);
            if (this.returnVarIndex != null) {
                mv.visitLocalVariable("res", this.returnType.getDescriptor(), this.returnType.getGenericSignature(), this.wrapStart, this.wrapEnd, this.returnVarIndex.intValue());
            }
            return size;
        }
    }

    private static final class GetSizeDelegation
    extends DoFnMethodWithExtraParametersDelegation {
        private static final MethodDescription VALIDATE_SIZE_METHOD;

        private GetSizeDelegation(TypeDescription doFnType, DoFnSignature.GetSizeMethod signature) {
            super(doFnType, signature);
        }

        @Override
        protected StackManipulation afterDelegation(MethodDescription instrumentedMethod) {
            return new StackManipulation.Compound(new StackManipulation[]{MethodInvocation.invoke((MethodDescription)VALIDATE_SIZE_METHOD), MethodReturn.DOUBLE});
        }

        static {
            try {
                VALIDATE_SIZE_METHOD = new MethodDescription.ForLoadedMethod(DefaultGetSize.class.getMethod("validateSize", Double.TYPE));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to locate DefaultGetSize.validateSize()");
            }
        }
    }

    private static final class ProcessElementDelegation
    extends DoFnMethodWithExtraParametersDelegation {
        private static final MethodDescription PROCESS_CONTINUATION_STOP_METHOD;

        private ProcessElementDelegation(TypeDescription doFnType, DoFnSignature.ProcessElementMethod signature) {
            super(doFnType, signature);
        }

        @Override
        protected StackManipulation afterDelegation(MethodDescription instrumentedMethod) {
            if (TypeDescription.VOID.equals(this.targetMethod.getReturnType().asErasure())) {
                return new StackManipulation.Compound(new StackManipulation[]{MethodInvocation.invoke((MethodDescription)PROCESS_CONTINUATION_STOP_METHOD), MethodReturn.REFERENCE});
            }
            return MethodReturn.of((TypeDefinition)this.targetMethod.getReturnType().asErasure());
        }

        static {
            try {
                PROCESS_CONTINUATION_STOP_METHOD = new MethodDescription.ForLoadedMethod(DoFn.ProcessContinuation.class.getMethod("stop", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to locate ProcessContinuation.stop()");
            }
        }
    }

    private static class DowncastingParametersMethodDelegation
    extends DoFnMethodDelegation {
        DowncastingParametersMethodDelegation(TypeDescription doFnType, Method method) {
            super(doFnType, method);
        }

        @Override
        protected StackManipulation beforeDelegation(MethodDescription instrumentedMethod) {
            ArrayList<StackManipulation> pushParameters = new ArrayList<StackManipulation>();
            TypeList.Generic paramTypes = this.targetMethod.getParameters().asTypeList();
            for (int i = 0; i < paramTypes.size(); ++i) {
                TypeDescription.Generic paramT = (TypeDescription.Generic)paramTypes.get(i);
                pushParameters.add(MethodVariableAccess.of((TypeDefinition)paramT).loadFrom(i + 1));
                if (paramT.isPrimitive()) continue;
                pushParameters.add(TypeCasting.to((TypeDefinition)paramT));
            }
            return new StackManipulation.Compound(pushParameters);
        }
    }

    static class DoFnMethodWithExtraParametersDelegation
    extends DoFnMethodDelegation {
        private final DoFnSignature.MethodWithExtraParameters signature;

        public DoFnMethodWithExtraParametersDelegation(TypeDescription clazzDescription, DoFnSignature.MethodWithExtraParameters signature) {
            super(clazzDescription, signature.targetMethod());
            this.signature = signature;
        }

        @Override
        protected StackManipulation beforeDelegation(MethodDescription instrumentedMethod) {
            ArrayList<StackManipulation.Compound> parameters = new ArrayList<StackManipulation.Compound>();
            StackManipulation.Compound pushDelegate = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(0), FieldAccess.forField((FieldDescription)this.delegateField).read()});
            StackManipulation pushExtraContextFactory = MethodVariableAccess.REFERENCE.loadFrom(1);
            for (DoFnSignature.Parameter param : this.signature.extraParameters()) {
                parameters.add(new StackManipulation.Compound(new StackManipulation[]{pushExtraContextFactory, ByteBuddyDoFnInvokerFactory.getExtraContextParameter(param, (StackManipulation)pushDelegate)}));
            }
            return new StackManipulation.Compound(parameters);
        }
    }

    static class DoFnMethodDelegation
    implements Implementation {
        protected final MethodDescription targetMethod;
        private final boolean targetHasReturn;
        protected @Nullable FieldDescription delegateField;
        private final TypeDescription doFnType;

        public DoFnMethodDelegation(TypeDescription doFnType, Method targetMethod) {
            this.doFnType = doFnType;
            this.targetMethod = new MethodDescription.ForLoadedMethod(targetMethod);
            this.targetHasReturn = !TypeDescription.VOID.equals(this.targetMethod.getReturnType().asErasure());
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            this.delegateField = (FieldDescription)((FieldList)instrumentedType.getSuperClass().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)ByteBuddyDoFnInvokerFactory.FN_DELEGATE_FIELD_NAME))).getOnly();
            return instrumentedType;
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new ByteCodeAppender(){

                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                    int numLocals = 1 + instrumentedMethod.getParameters().size() + (targetHasReturn ? Type.getReturnType((String)instrumentedMethod.getDescriptor()).getSize() : 0);
                    Integer returnVarIndex = null;
                    if (targetHasReturn) {
                        returnVarIndex = 1;
                        for (Type param : Type.getArgumentTypes((String)instrumentedMethod.getDescriptor())) {
                            returnVarIndex = returnVarIndex + param.getSize();
                        }
                    }
                    StackManipulation.Compound manipulation = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(0), FieldAccess.forField((FieldDescription)delegateField).read(), TypeCasting.to((TypeDefinition)doFnType), this.beforeDelegation(instrumentedMethod), new UserCodeMethodInvocation(returnVarIndex, targetMethod, instrumentedMethod), this.afterDelegation(instrumentedMethod)});
                    StackManipulation.Size size = manipulation.apply(methodVisitor, implementationContext);
                    return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
                }
            };
        }

        protected StackManipulation beforeDelegation(MethodDescription instrumentedMethod) {
            return MethodVariableAccess.allArgumentsOf((MethodDescription)this.targetMethod);
        }

        protected StackManipulation afterDelegation(MethodDescription instrumentedMethod) {
            return new StackManipulation.Compound(new StackManipulation[]{Assigner.DEFAULT.assign(this.targetMethod.getReturnType(), instrumentedMethod.getReturnType(), Assigner.Typing.STATIC), MethodReturn.of((TypeDefinition)instrumentedMethod.getReturnType())});
        }
    }

    public static class DefaultGetSize {
        public static <InputT, OutputT> double invokeGetSize(DoFnInvoker.ArgumentProvider<InputT, OutputT> argumentProvider) {
            if (argumentProvider.restrictionTracker() instanceof RestrictionTracker.HasProgress) {
                return ((RestrictionTracker.HasProgress)((Object)argumentProvider.restrictionTracker())).getProgress().getWorkRemaining();
            }
            return 1.0;
        }

        public static double validateSize(double size) {
            if (size < 0.0) {
                throw new IllegalArgumentException(String.format("Expected size >= 0 but received %s.", size));
            }
            return size;
        }
    }

    public static class DefaultNewTracker {
        public static <InputT, OutputT, RestrictionT, PositionT> RestrictionTracker<RestrictionT, PositionT> invokeNewTracker(DoFnInvoker.ArgumentProvider<InputT, OutputT> argumentProvider) {
            return ((HasDefaultTracker)argumentProvider.restriction()).newTracker();
        }
    }

    public static class DefaultNewWatermarkEstimator {
        public static <InputT, OutputT, WatermarkEstimatorStateT> WatermarkEstimator<WatermarkEstimatorStateT> invokeNewWatermarkEstimator(DoFnInvoker.ArgumentProvider<InputT, OutputT> argumentProvider) {
            if (argumentProvider.watermarkEstimatorState() instanceof HasDefaultWatermarkEstimator) {
                return ((HasDefaultWatermarkEstimator)argumentProvider.watermarkEstimatorState()).newWatermarkEstimator();
            }
            return new WatermarkEstimator<WatermarkEstimatorStateT>(){

                @Override
                public Instant currentWatermark() {
                    return GlobalWindow.TIMESTAMP_MIN_VALUE;
                }

                @Override
                public WatermarkEstimatorStateT getState() {
                    return null;
                }
            };
        }
    }

    public static class DefaultGetInitialWatermarkEstimatorState {
        public static <InputT, OutputT, WatermarkEstimatorStateT> WatermarkEstimator<WatermarkEstimatorStateT> invokeNewWatermarkEstimator(DoFnInvoker.ArgumentProvider<InputT, OutputT> argumentProvider) {
            return null;
        }
    }

    public static class DefaultWatermarkEstimatorStateCoder {
        private final TypeDescriptor<?> watermarkEstimatorStateType;

        DefaultWatermarkEstimatorStateCoder(TypeDescriptor<?> watermarkEstimatorStateType) {
            this.watermarkEstimatorStateType = watermarkEstimatorStateType;
        }

        public <WatermarkEstimatorStateT> Coder<WatermarkEstimatorStateT> invokeGetWatermarkEstimatorStateCoder(CoderRegistry registry) throws CannotProvideCoderException {
            return registry.getCoder(this.watermarkEstimatorStateType);
        }
    }

    public static class DefaultRestrictionCoder {
        private final TypeDescriptor<?> restrictionType;

        DefaultRestrictionCoder(TypeDescriptor<?> restrictionType) {
            this.restrictionType = restrictionType;
        }

        public <RestrictionT> Coder<RestrictionT> invokeGetRestrictionCoder(CoderRegistry registry) throws CannotProvideCoderException {
            return registry.getCoder(this.restrictionType);
        }
    }

    public static class DefaultTruncateRestriction {
        public static RestrictionTracker.TruncateResult<?> invokeTruncateRestriction(DoFnInvoker.ArgumentProvider argumentProvider) {
            if (argumentProvider.restrictionTracker().isBounded() == RestrictionTracker.IsBounded.BOUNDED) {
                return RestrictionTracker.TruncateResult.of(argumentProvider.restriction());
            }
            return null;
        }
    }

    public static class DefaultSplitRestriction {
        public static void invokeSplitRestriction(DoFnInvoker.ArgumentProvider argumentProvider) {
            argumentProvider.outputReceiver(null).output(argumentProvider.restriction());
        }
    }

    public static abstract class DoFnInvokerBase<InputT, OutputT, DoFnT extends DoFn<InputT, OutputT>>
    implements DoFnInvoker<InputT, OutputT> {
        protected DoFnT delegate;
        private Map<String, OnTimerInvoker> onTimerInvokers = Maps.newHashMap();
        private Map<String, OnTimerInvoker> onTimerFamilyInvokers = Maps.newHashMap();

        public DoFnInvokerBase(DoFnT delegate) {
            this.delegate = delegate;
        }

        void addOnTimerInvoker(String timerId, OnTimerInvoker onTimerInvoker) {
            this.onTimerInvokers.put(timerId, onTimerInvoker);
        }

        void addOnTimerFamilyInvoker(String timerFamilyId, OnTimerInvoker onTimerInvoker) {
            this.onTimerFamilyInvokers.put(timerFamilyId, onTimerInvoker);
        }

        @Override
        public void invokeOnTimer(String timerId, String timerFamilyId, DoFnInvoker.ArgumentProvider<InputT, OutputT> arguments) {
            OnTimerInvoker onTimerInvoker;
            OnTimerInvoker onTimerInvoker2 = onTimerInvoker = timerFamilyId.isEmpty() ? this.onTimerInvokers.get(timerId) : this.onTimerFamilyInvokers.get(timerFamilyId);
            if (onTimerInvoker == null) {
                throw new IllegalArgumentException(String.format("Attempted to invoke timer %s on %s, but that timer is not registered. This is the responsibility of the runner, which must only deliver registered timers.", timerId, this.delegate.getClass().getName()));
            }
            onTimerInvoker.invokeOnTimer(arguments);
        }

        @Override
        public DoFn<InputT, OutputT> getFn() {
            return this.delegate;
        }
    }
}

