/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MetadataCoder;

@Experimental(value=Experimental.Kind.FILESYSTEM)
public class MetadataCoderV2
extends AtomicCoder<MatchResult.Metadata> {
    private static final MetadataCoderV2 INSTANCE = new MetadataCoderV2();
    private static final MetadataCoder V1_CODER = MetadataCoder.of();
    private static final VarLongCoder LONG_CODER = VarLongCoder.of();

    private MetadataCoderV2() {
    }

    public static MetadataCoderV2 of() {
        return INSTANCE;
    }

    @Override
    public void encode(MatchResult.Metadata value, OutputStream os) throws IOException {
        V1_CODER.encode(value, os);
        LONG_CODER.encode(value.lastModifiedMillis(), os);
    }

    @Override
    public MatchResult.Metadata decode(InputStream is) throws IOException {
        MatchResult.Metadata.Builder builder = V1_CODER.decodeBuilder(is);
        long lastModifiedMillis = LONG_CODER.decode(is);
        return builder.setLastModifiedMillis(lastModifiedMillis).build();
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }
}

