/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BitConverters;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.values.TypeDescriptor;

public class FloatCoder
extends AtomicCoder<Float> {
    private static final FloatCoder INSTANCE = new FloatCoder();
    private static final TypeDescriptor<Float> TYPE_DESCRIPTOR = new TypeDescriptor<Float>(){};

    public static FloatCoder of() {
        return INSTANCE;
    }

    private FloatCoder() {
    }

    @Override
    public void encode(Float value, OutputStream outStream) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Float");
        }
        new DataOutputStream(outStream).writeFloat(value.floatValue());
    }

    @Override
    public Float decode(InputStream inStream) throws IOException, CoderException {
        try {
            return Float.valueOf(Float.intBitsToFloat(BitConverters.readBigEndianInt(inStream)));
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Floating point encodings are not guaranteed to be deterministic.");
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Float value) {
        return true;
    }

    @Override
    public TypeDescriptor<Float> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected long getEncodedElementByteSize(Float value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Float");
        }
        return 4L;
    }
}

