/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.checkerframework.checker.nullness.qual.Nullable;

class ProducerSpEL {
    private static @Nullable TransactionsImplementation transactionsImplementation;
    static final String ENABLE_IDEMPOTENCE_CONFIG = "enable.idempotence";
    static final String TRANSACTIONAL_ID_CONFIG = "transactional.id";

    ProducerSpEL() {
    }

    static boolean supportsTransactions() {
        return transactionsImplementation != null;
    }

    private static TransactionsImplementation getTransactionsImplementation() {
        return (TransactionsImplementation)Preconditions.checkStateNotNull((Object)transactionsImplementation, (Object)"This version of Kafka client library does not support transactions. Please used version 0.11 or later.");
    }

    static void initTransactions(Producer<?, ?> producer) {
        ProducerSpEL.getTransactionsImplementation().initTransactions(producer);
    }

    static void beginTransaction(Producer<?, ?> producer) {
        ProducerSpEL.getTransactionsImplementation().beginTransaction(producer);
    }

    static void commitTransaction(Producer<?, ?> producer) {
        ProducerSpEL.getTransactionsImplementation().commitTransaction(producer);
    }

    static void abortTransaction(Producer<?, ?> producer) {
        ProducerSpEL.getTransactionsImplementation().abortTransaction(producer);
    }

    static void sendOffsetsToTransaction(Producer<?, ?> producer, Map<TopicPartition, OffsetAndMetadata> offsets, @Nullable String consumerGroupId) {
        ProducerSpEL.getTransactionsImplementation().sendOffsetsToTransaction(producer, offsets, consumerGroupId);
    }

    static {
        try {
            transactionsImplementation = new TransactionsImplementation();
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            transactionsImplementation = null;
        }
    }

    static class UnrecoverableProducerException
    extends ApiException {
        UnrecoverableProducerException(ApiException cause) {
            super((Throwable)cause);
        }
    }

    private static class TransactionsImplementation {
        private Method initTransactionsMethod = Producer.class.getMethod("initTransactions", new Class[0]);
        private Method beginTransactionMethod = Producer.class.getMethod("beginTransaction", new Class[0]);
        private Method commitTransactionMethod = Producer.class.getMethod("commitTransaction", new Class[0]);
        private Method abortTransactionMethod = Producer.class.getMethod("abortTransaction", new Class[0]);
        private Method sendOffsetsToTransactionMethod = Producer.class.getMethod("sendOffsetsToTransaction", Map.class, String.class);
        private Class<?> producerFencedExceptionClass = Class.forName("org.apache.kafka.common.errors.ProducerFencedException");
        private Class<?> outOfOrderSequenceExceptionClass = Class.forName("org.apache.kafka.common.errors.OutOfOrderSequenceException");

        private TransactionsImplementation() throws NoSuchMethodException, ClassNotFoundException {
        }

        private void initTransactions(Producer<?, ?> producer) {
            this.invoke(this.initTransactionsMethod, producer, new Object[0]);
        }

        private void beginTransaction(Producer<?, ?> producer) {
            this.invoke(this.beginTransactionMethod, producer, new Object[0]);
        }

        private void commitTransaction(Producer<?, ?> producer) {
            this.invoke(this.commitTransactionMethod, producer, new Object[0]);
        }

        private void abortTransaction(Producer<?, ?> producer) {
            this.invoke(this.abortTransactionMethod, producer, new Object[0]);
        }

        private void sendOffsetsToTransaction(Producer<?, ?> producer, Map<TopicPartition, OffsetAndMetadata> offsets, @Nullable String consumerGroupId) {
            this.invoke(this.sendOffsetsToTransactionMethod, producer, offsets, consumerGroupId);
        }

        private void invoke(Method method, Object obj, Object ... args) {
            try {
                Object object = method.invoke(obj, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (ApiException e) {
                Class<?> eClass = ((Object)((Object)e)).getClass();
                if (this.producerFencedExceptionClass.isAssignableFrom(eClass) || this.outOfOrderSequenceExceptionClass.isAssignableFrom(eClass) || AuthorizationException.class.isAssignableFrom(eClass)) {
                    throw new UnrecoverableProducerException(e);
                }
                throw e;
            }
        }
    }
}

