/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.MessageUtilities;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class QueuedMessagePropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String dateText_ = ResourceLoader.getText("MESSAGE_DATE") + ":";
    private static final String fromJobText_ = ResourceLoader.getText("MESSAGE_FROM_JOB") + ":";
    private static final String fromJobNumberText_ = ResourceLoader.getText("MESSAGE_FROM_JOB_NUMBER") + ":";
    private static final String fromProgramText_ = ResourceLoader.getText("MESSAGE_FROM_PROGRAM") + ":";
    private static final String fromUserText_ = ResourceLoader.getText("MESSAGE_FROM_USER") + ":";
    private static final String generalTabText_ = ResourceLoader.getText("TAB_GENERAL");
    private static final String messageQueueText_ = ResourceLoader.getText("MESSAGE_QUEUE") + ":";
    private static final String severityText_ = ResourceLoader.getText("MESSAGE_SEVERITY") + ":";
    private static final String typeText_ = ResourceLoader.getText("MESSAGE_TYPE") + ":";
    private static DateFormat dateFormat_ = DateFormat.getDateTimeInstance();
    private QueuedMessage message_;
    private VObject object_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public QueuedMessagePropertiesPane(VObject vObject, QueuedMessage queuedMessage) {
        this.object_ = vObject;
        this.message_ = queuedMessage;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.addChangeListener(changeListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public void applyChanges() throws Exception {
    }

    public Component getComponent() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), jPanel, gridBagLayout, 0, n++, 2, 1);
        JTextArea jTextArea = new JTextArea(this.message_.getText());
        jTextArea.setEditable(false);
        jTextArea.setBackground(jPanel.getBackground());
        jTextArea.setColumns(40);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        VUtilities.constrain(jTextArea, jPanel, gridBagLayout, 0, n++, 2, 1);
        String string = this.message_.getHelp();
        if (string != null && string.length() > 0) {
            serializable = new JTextArea(string);
            serializable.setEditable(false);
            serializable.setBackground(jPanel.getBackground());
            serializable.setColumns(40);
            serializable.setLineWrap(true);
            serializable.setWrapStyleWord(true);
            VUtilities.constrain(serializable, jPanel, gridBagLayout, 0, n++, 2, 1);
        }
        VUtilities.constrain(new JSeparator(), jPanel, gridBagLayout, 0, n++, 2, 1);
        VUtilities.constrain(new JLabel(severityText_), jPanel, gridBagLayout, 0, n, 1, 1);
        VUtilities.constrain(new JLabel(Integer.toString(this.message_.getSeverity())), jPanel, gridBagLayout, 1, n, 1, 1);
        VUtilities.constrain(new JLabel(typeText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        VUtilities.constrain(new JLabel(MessageUtilities.getTypeText(this.message_.getType())), jPanel, gridBagLayout, 1, n, 1, 1);
        VUtilities.constrain(new JLabel(dateText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        serializable = this.message_.getDate().getTime();
        if (serializable != null) {
            VUtilities.constrain(new JLabel(dateFormat_.format((Date)serializable)), jPanel, gridBagLayout, 1, n, 1, 1);
        }
        int n2 = ++n;
        VUtilities.constrain(new JSeparator(), jPanel, gridBagLayout, 0, n2, 2, 1);
        VUtilities.constrain(new JLabel(fromJobText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        VUtilities.constrain(new JLabel(this.message_.getFromJobName()), jPanel, gridBagLayout, 1, n, 1, 1);
        VUtilities.constrain(new JLabel(fromUserText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        VUtilities.constrain(new JLabel(this.message_.getUser()), jPanel, gridBagLayout, 1, n, 1, 1);
        VUtilities.constrain(new JLabel(fromJobNumberText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        VUtilities.constrain(new JLabel(this.message_.getFromJobNumber()), jPanel, gridBagLayout, 1, n, 1, 1);
        int n3 = ++n;
        VUtilities.constrain(new JSeparator(), jPanel, gridBagLayout, 0, n3, 2, 1);
        VUtilities.constrain(new JLabel(fromProgramText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        VUtilities.constrain(new JLabel(this.message_.getFromProgram()), jPanel, gridBagLayout, 1, n, 1, 1);
        int n4 = ++n;
        VUtilities.constrain(new JSeparator(), jPanel, gridBagLayout, 0, n4, 2, 1);
        VUtilities.constrain(new JLabel(messageQueueText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        MessageQueue messageQueue = this.message_.getQueue();
        String string2 = messageQueue == null ? "" : messageQueue.getPath();
        VUtilities.constrain(new JLabel(string2), jPanel, gridBagLayout, 1, n, 1, 1);
        ++n;
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(generalTabText_, null, jPanel);
        jTabbedPane.setSelectedIndex(0);
        return jTabbedPane;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.removeChangeListener(changeListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    static {
        dateFormat_.setTimeZone(TimeZone.getDefault());
    }
}

