/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.fn.CancellableQueue;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.stub.CallStreamObserver;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.NonNull;

@ThreadSafe
public final class BufferingStreamObserver<T>
implements StreamObserver<T> {
    private static final Object POISON_PILL = new Object();
    private final CancellableQueue<T> queue;
    private final Phaser phaser;
    private final CallStreamObserver<T> outboundObserver;
    private final Future<?> queueDrainer;
    private final int bufferSize;

    public BufferingStreamObserver(Phaser phaser, CallStreamObserver<T> outboundObserver, ExecutorService executor, int bufferSize) {
        this.phaser = phaser;
        this.bufferSize = bufferSize;
        this.queue = new CancellableQueue(bufferSize);
        this.outboundObserver = outboundObserver;
        this.queueDrainer = executor.submit(this::drainQueue);
    }

    private void drainQueue() {
        try {
            while (true) {
                int currentPhase = this.phaser.getPhase();
                while (this.outboundObserver.isReady()) {
                    T value = this.queue.take();
                    if (value != POISON_PILL) {
                        this.outboundObserver.onNext(value);
                        continue;
                    }
                    this.outboundObserver.onCompleted();
                    return;
                }
                this.phaser.awaitAdvance(currentPhase);
            }
        }
        catch (OnErrorException e) {
            this.outboundObserver.onError(e.getCause());
        }
        catch (Exception e) {
            this.queue.cancel(e);
            this.outboundObserver.onError((Throwable)e);
        }
    }

    public void onNext(T value) {
        try {
            this.queue.put(value);
        }
        catch (InterruptedException e) {
            this.queue.cancel(e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onError(Throwable t) {
        this.queue.cancel(new OnErrorException(t));
        try {
            this.queueDrainer.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onCompleted() {
        try {
            this.queue.put(POISON_PILL);
            this.queueDrainer.get();
        }
        catch (Exception e) {
            this.queue.cancel(e);
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public int getBufferSize() {
        return this.bufferSize;
    }

    private static class OnErrorException
    extends Exception {
        public OnErrorException(@NonNull Throwable throwable) {
            super(throwable);
        }

        @Override
        public synchronized @NonNull Throwable getCause() {
            return super.getCause();
        }
    }
}

