/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.utils;

import java.util.concurrent.ExecutionException;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.SideInputStorage;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.spark.util.SizeEstimator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSideInputReader
implements SideInputReader {
    private static final Logger LOG = LoggerFactory.getLogger(CachedSideInputReader.class);
    private final SideInputReader delegate;

    public static CachedSideInputReader of(SideInputReader delegate) {
        return new CachedSideInputReader(delegate);
    }

    private CachedSideInputReader(SideInputReader delegate) {
        this.delegate = delegate;
    }

    public <T> @Nullable T get(PCollectionView<T> view, BoundedWindow window) {
        Cache<SideInputStorage.Key<?>, SideInputStorage.Value<?>> materializedCasted = SideInputStorage.getMaterializedSideInputs();
        SideInputStorage.Key sideInputKey = new SideInputStorage.Key(view, window);
        try {
            SideInputStorage.Value cachedResult = (SideInputStorage.Value)materializedCasted.get(sideInputKey, () -> {
                Object result = this.delegate.get(view, window);
                LOG.debug("Caching de-serialized side input for {} of size [{}B] in memory.", (Object)sideInputKey, (Object)SizeEstimator.estimate((Object)result));
                return new SideInputStorage.Value<Object>(result);
            });
            return cachedResult.getValue();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public <T> boolean contains(PCollectionView<T> view) {
        return this.delegate.contains(view);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }
}

