/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.io.IOException;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.internal.SQLConf;

public class ReshuffleTranslatorBatch<K, V>
extends TransformTranslator<PCollection<KV<K, V>>, PCollection<KV<K, V>>, Reshuffle<K, V>> {
    @Override
    protected void translate(Reshuffle<K, V> transform, TransformTranslator.Context cxt) throws IOException {
        Dataset input = cxt.getDataset((PCollection)cxt.getInput());
        cxt.putDataset((PCollection)cxt.getOutput(), input.repartition(new Column[]{functions.col((String)"value.key")}));
    }

    public static class ViaRandomKey<V>
    extends TransformTranslator<PCollection<V>, PCollection<V>, Reshuffle.ViaRandomKey<V>> {
        @Override
        protected void translate(Reshuffle.ViaRandomKey<V> transform, TransformTranslator.Context cxt) throws IOException {
            Dataset input = cxt.getDataset((PCollection)cxt.getInput());
            cxt.putDataset((PCollection)cxt.getOutput(), input.repartition(SQLConf.get().numShufflePartitions()));
        }
    }
}

