/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.Collection;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Instant;
import scala.Tuple2;
import scala.collection.TraversableOnce;

class GroupByKeyHelpers {
    private GroupByKeyHelpers() {
    }

    static boolean eligibleForGroupByWindow(WindowingStrategy<?, ?> windowing, boolean endOfWindowOnly) {
        return !windowing.needsMerge() && (!endOfWindowOnly || windowing.getTimestampCombiner() == TimestampCombiner.END_OF_WINDOW) && windowing.getWindowFn().windowCoder().consistentWithEquals();
    }

    static boolean eligibleForGlobalGroupBy(WindowingStrategy<?, ?> windowing, boolean endOfWindowOnly) {
        return windowing.getWindowFn() instanceof GlobalWindows && (!endOfWindowOnly || windowing.getTimestampCombiner() == TimestampCombiner.END_OF_WINDOW);
    }

    static <K, V, T> ScalaInterop.Fun1<WindowedValue<KV<K, V>>, TraversableOnce<Tuple2<Tuple2<BoundedWindow, K>, T>>> explodeWindowedKey(ScalaInterop.Fun1<WindowedValue<KV<K, V>>, T> valueFn) {
        return v -> {
            Object value = valueFn.apply(v);
            Object key = ((KV)v.getValue()).getKey();
            Collection windows = v.getWindows();
            return ScalaInterop.scalaIterator(windows).map(w -> ScalaInterop.tuple(ScalaInterop.tuple(w, key), value));
        };
    }

    static <K, V> ScalaInterop.Fun1<Tuple2<Tuple2<BoundedWindow, K>, V>, WindowedValue<KV<K, V>>> windowedKV() {
        return t -> GroupByKeyHelpers.windowedKV((Tuple2)t._1, t._2);
    }

    static <K, V> WindowedValue<KV<K, V>> windowedKV(Tuple2<BoundedWindow, K> key, V value) {
        return WindowedValue.of((Object)KV.of((Object)key._2, value), (Instant)((BoundedWindow)key._1).maxTimestamp(), (BoundedWindow)((BoundedWindow)key._1), (PaneInfo)PaneInfo.NO_FIRING);
    }

    static <V> ScalaInterop.Fun1<WindowedValue<V>, V> value() {
        return v -> v.getValue();
    }

    static <K, V> ScalaInterop.Fun1<WindowedValue<KV<K, V>>, V> valueValue() {
        return v -> ((KV)v.getValue()).getValue();
    }

    static <K, V> ScalaInterop.Fun1<WindowedValue<KV<K, V>>, K> valueKey() {
        return v -> ((KV)v.getValue()).getKey();
    }
}

