/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBiMap;

public class ShortIdMap {
    private int counter = 0;
    private BiMap<String, MetricsApi.MonitoringInfo> monitoringInfoMap = HashBiMap.create();

    public synchronized String getOrCreateShortId(MetricsApi.MonitoringInfo info) {
        Preconditions.checkNotNull((Object)info);
        Preconditions.checkArgument((boolean)info.getPayload().isEmpty());
        Preconditions.checkArgument((!info.hasStartTime() ? 1 : 0) != 0);
        String shortId = (String)this.monitoringInfoMap.inverse().get((Object)info);
        if (shortId == null) {
            shortId = "metric" + this.counter++;
            this.monitoringInfoMap.put((Object)shortId, (Object)info);
        }
        return shortId;
    }

    public synchronized MetricsApi.MonitoringInfo get(String shortId) {
        MetricsApi.MonitoringInfo monitoringInfo = (MetricsApi.MonitoringInfo)this.monitoringInfoMap.get((Object)shortId);
        if (monitoringInfo == null) {
            throw new NoSuchElementException(shortId);
        }
        return monitoringInfo;
    }

    public synchronized Map<String, MetricsApi.MonitoringInfo> get(List<String> shortIds) {
        HashMap<String, MetricsApi.MonitoringInfo> monitoringInfos = new HashMap<String, MetricsApi.MonitoringInfo>(shortIds.size());
        for (String shortId : shortIds) {
            MetricsApi.MonitoringInfo info = (MetricsApi.MonitoringInfo)this.monitoringInfoMap.get((Object)shortId);
            if (info == null) {
                throw new NoSuchElementException(shortId);
            }
            monitoringInfos.put(shortId, info);
        }
        return monitoringInfos;
    }

    public synchronized Iterable<MetricsApi.MonitoringInfo> toMonitoringInfo(Map<String, ByteString> shortIdToData) {
        ArrayList<MetricsApi.MonitoringInfo> monitoringInfos = new ArrayList<MetricsApi.MonitoringInfo>(shortIdToData.size());
        for (Map.Entry<String, ByteString> entry : shortIdToData.entrySet()) {
            String shortId = entry.getKey();
            MetricsApi.MonitoringInfo info = (MetricsApi.MonitoringInfo)this.monitoringInfoMap.get((Object)shortId);
            if (info == null) {
                throw new NoSuchElementException(shortId);
            }
            monitoringInfos.add(info.toBuilder().setPayload(entry.getValue()).build());
        }
        return monitoringInfos;
    }
}

