/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.shuffle.ShuffleDataIOUtils$;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.shuffle.sort.PackedRecordPointer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.mutable.ArrayOps;

public final class SortShuffleManager$
implements Logging {
    public static SortShuffleManager$ MODULE$;
    private final int MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE;
    private final String FETCH_SHUFFLE_BLOCKS_IN_BATCH_ENABLED_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SortShuffleManager$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE() {
        return this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE;
    }

    public String FETCH_SHUFFLE_BLOCKS_IN_BATCH_ENABLED_KEY() {
        return this.FETCH_SHUFFLE_BLOCKS_IN_BATCH_ENABLED_KEY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseBatchFetch(int startPartition, int endPartition, TaskContext context) {
        if (endPartition - startPartition <= 1) return false;
        boolean bl = true;
        boolean fetchMultiPartitions = bl;
        if (!fetchMultiPartitions) return false;
        String string = context.getLocalProperty(this.FETCH_SHUFFLE_BLOCKS_IN_BATCH_ENABLED_KEY());
        String string2 = "true";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean canUseSerializedShuffle(ShuffleDependency<?, ?, ?> dependency) {
        boolean bl;
        int shufId = dependency.shuffleId();
        int numPartitions = dependency.partitioner().numPartitions();
        if (!dependency.serializer().supportsRelocationOfSerializedObjects()) {
            this.log().debug(new StringBuilder(102).append("Can't use serialized shuffle for shuffle ").append(shufId).append(" because the serializer, ").append(dependency.serializer().getClass().getName()).append(", does not support object relocation").toString());
            bl = false;
        } else if (dependency.mapSideCombine()) {
            this.log().debug(new StringBuilder(84).append("Can't use serialized shuffle for shuffle ").append(shufId).append(" because we need to do ").append("map-side aggregation").toString());
            bl = false;
        } else if (numPartitions > this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE()) {
            this.log().debug(new StringBuilder(78).append("Can't use serialized shuffle for shuffle ").append(shufId).append(" because it has more than ").append(this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE()).append(" partitions").toString());
            bl = false;
        } else {
            this.log().debug(new StringBuilder(39).append("Can use serialized shuffle for shuffle ").append(shufId).toString());
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public ShuffleExecutorComponents org$apache$spark$shuffle$sort$SortShuffleManager$$loadShuffleExecutorComponents(SparkConf conf) {
        void var2_2;
        ShuffleExecutorComponents executorComponents = ShuffleDataIOUtils$.MODULE$.loadShuffleDataIO(conf).executor();
        scala.collection.immutable.Map extraConfigs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAllWithPrefix(ShuffleDataIOUtils$.MODULE$.SHUFFLE_SPARK_CONF_PREFIX()))).toMap(Predef$.MODULE$.$conforms());
        executorComponents.initializeExecutor(conf.getAppId(), SparkEnv$.MODULE$.get().executorId(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraConfigs).asJava());
        return var2_2;
    }

    private SortShuffleManager$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE = PackedRecordPointer.MAXIMUM_PARTITION_ID + 1;
        this.FETCH_SHUFFLE_BLOCKS_IN_BATCH_ENABLED_KEY = "__fetch_continuous_blocks_in_batch_enabled";
    }
}

