/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.api.client.util.Clock;
import com.google.api.client.util.Strings;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.BigtableVersionInfo;
import com.google.cloud.bigtable.config.BulkOptions;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.core.IBigtableDataClient;
import com.google.cloud.bigtable.core.IBigtableTableAdminClient;
import com.google.cloud.bigtable.core.IBulkMutation;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.cloud.bigtable.grpc.BigtableClusterUtilities;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.BigtableDataClientWrapper;
import com.google.cloud.bigtable.grpc.BigtableDataGrpcClient;
import com.google.cloud.bigtable.grpc.BigtableInstanceClient;
import com.google.cloud.bigtable.grpc.BigtableInstanceGrpcClient;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.cloud.bigtable.grpc.BigtableSessionSharedThreadPools;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClientWrapper;
import com.google.cloud.bigtable.grpc.BigtableTableAdminGrpcClient;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.grpc.ConfiguredDeadlineGeneratorFactory;
import com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.cloud.bigtable.grpc.async.BulkMutationWrapper;
import com.google.cloud.bigtable.grpc.async.BulkRead;
import com.google.cloud.bigtable.grpc.async.ResourceLimiter;
import com.google.cloud.bigtable.grpc.async.ResourceLimiterStats;
import com.google.cloud.bigtable.grpc.async.ThrottlingClientInterceptor;
import com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.cloud.bigtable.grpc.io.CredentialInterceptorCache;
import com.google.cloud.bigtable.grpc.io.GoogleCloudResourcePrefixInterceptor;
import com.google.cloud.bigtable.grpc.io.HeaderInterceptor;
import com.google.cloud.bigtable.grpc.io.Watchdog;
import com.google.cloud.bigtable.grpc.io.WatchdogInterceptor;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.util.DirectPathUtil;
import com.google.cloud.bigtable.util.ThreadUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.alts.ComputeEngineChannelBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

@InternalExtensionOnly
public class BigtableSession
implements Closeable {
    private static final Logger LOG = new Logger(BigtableSession.class);
    private static Map<String, ManagedChannel> cachedDataChannelPools = new HashMap<String, ManagedChannel>();
    private static final Map<String, ResourceLimiter> resourceLimiterMap = new HashMap<String, ResourceLimiter>();
    private static final int MAX_MESSAGE_SIZE = 0x10000000;
    static final long CHANNEL_KEEP_ALIVE_TIME_SECONDS = 30L;
    static final long CHANNEL_KEEP_ALIVE_TIMEOUT_SECONDS = 10L;
    static final long DIRECT_PATH_KEEP_ALIVE_TIME_SECONDS = 3600L;
    static final long DIRECT_PATH_KEEP_ALIVE_TIMEOUT_SECONDS = 20L;
    @VisibleForTesting
    static final String PROJECT_ID_EMPTY_OR_NULL = "ProjectId must not be empty or null.";
    @VisibleForTesting
    static final String INSTANCE_ID_EMPTY_OR_NULL = "InstanceId must not be empty or null.";
    @VisibleForTesting
    static final String USER_AGENT_EMPTY_OR_NULL = "UserAgent must not be empty or null";
    private Watchdog watchdog;
    private final BigtableOptions options;
    private final List<ManagedChannel> managedChannels;
    private final BigtableDataClient dataClient;
    private final RequestContext dataRequestContext;
    private final BigtableDataClient throttlingDataClient;
    private BigtableTableAdminClient tableAdminClient;
    private BigtableInstanceGrpcClient instanceAdminClient;
    private BigtableTableAdminClientWrapper adminClientWrapper;
    private BigtableClusterName clusterName;

    private static void performWarmup() {
        ExecutorService connectionStartupExecutor = Executors.newCachedThreadPool(ThreadUtil.getThreadFactory("BigtableSession-startup-%d", true));
        connectionStartupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                BigtableSessionSharedThreadPools.getInstance();
            }
        });
        for (final String host : Arrays.asList("bigtable.googleapis.com", "bigtableadmin.googleapis.com")) {
            connectionStartupExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        InetAddress.getByName(host);
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
            });
        }
        connectionStartupExecutor.shutdown();
    }

    private static synchronized ResourceLimiter initializeResourceLimiter(BigtableOptions options) {
        BigtableInstanceName instanceName = options.getInstanceName();
        String key = instanceName.toString();
        ResourceLimiter resourceLimiter = resourceLimiterMap.get(key);
        if (resourceLimiter == null) {
            int maxInflightRpcs = options.getBulkOptions().getMaxInflightRpcs();
            long maxMemory = options.getBulkOptions().getMaxMemory();
            ResourceLimiterStats stats = ResourceLimiterStats.getInstance(instanceName);
            resourceLimiter = new ResourceLimiter(stats, maxMemory, maxInflightRpcs);
            BulkOptions bulkOptions = options.getBulkOptions();
            if (bulkOptions.isEnableBulkMutationThrottling()) {
                resourceLimiter.throttle(bulkOptions.getBulkMutationRpcTargetMs());
            }
            resourceLimiterMap.put(key, resourceLimiter);
        }
        return resourceLimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigtableSession(BigtableOptions opts) throws IOException {
        ChannelPool rawDataChannelPool;
        boolean useDirectPath;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)opts.getProjectId()) ? 1 : 0) != 0, (Object)PROJECT_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)opts.getInstanceId()) ? 1 : 0) != 0, (Object)INSTANCE_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)opts.getUserAgent()) ? 1 : 0) != 0, (Object)USER_AGENT_EMPTY_OR_NULL);
        LOG.info("Opening session for projectId %s, instanceId %s, on data host %s, admin host %s.", opts.getProjectId(), opts.getInstanceId(), opts.getDataHost(), opts.getAdminHost());
        LOG.info("Bigtable options: %s.", opts);
        this.options = opts;
        this.managedChannels = new ArrayList<ManagedChannel>();
        boolean bl = useDirectPath = this.options.isDirectPathAllowed() && DirectPathUtil.shouldAttemptDirectPath(this.options.getDataHost(), this.options.getPort(), this.options.getCredentialOptions());
        if (this.options.useCachedChannel()) {
            Class<BigtableSession> clazz = BigtableSession.class;
            synchronized (BigtableSession.class) {
                String key = String.format("%s:%s:%d", useDirectPath, this.options.getDataHost(), this.options.getPort());
                rawDataChannelPool = cachedDataChannelPools.get(key);
                if (rawDataChannelPool == null) {
                    rawDataChannelPool = BigtableSession.createRawDataChannelPool(this.options, useDirectPath);
                    cachedDataChannelPools.put(key, rawDataChannelPool);
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
            }
        } else {
            rawDataChannelPool = BigtableSession.createRawDataChannelPool(this.options, useDirectPath);
            this.managedChannels.add(rawDataChannelPool);
        }
        {
            Channel dataChannel = ClientInterceptors.intercept((Channel)rawDataChannelPool, this.createDataApiInterceptors(this.options, useDirectPath));
            this.dataRequestContext = RequestContext.create((String)this.options.getProjectId(), (String)this.options.getInstanceId(), (String)this.options.getAppProfileId());
            BigtableSessionSharedThreadPools sharedPools = BigtableSessionSharedThreadPools.getInstance();
            ConfiguredDeadlineGeneratorFactory callOptionsFactory = new ConfiguredDeadlineGeneratorFactory(this.options.getCallOptionsConfig());
            this.dataClient = new BigtableDataGrpcClient(dataChannel, sharedPools.getRetryExecutor(), this.options);
            this.dataClient.setDeadlineGeneratorFactory(callOptionsFactory);
            ResourceLimiter resourceLimiter = BigtableSession.initializeResourceLimiter(this.options);
            Channel asyncDataChannel = ClientInterceptors.intercept((Channel)dataChannel, (ClientInterceptor[])new ClientInterceptor[]{new ThrottlingClientInterceptor(resourceLimiter)});
            this.throttlingDataClient = new BigtableDataGrpcClient(asyncDataChannel, sharedPools.getRetryExecutor(), this.options);
            this.throttlingDataClient.setDeadlineGeneratorFactory(callOptionsFactory);
            ManagedChannel rawAdminChannel = BigtableSession.createNettyChannel(this.options.getAdminHost(), this.options, false, new ClientInterceptor[0]);
            this.managedChannels.add(rawAdminChannel);
            Channel adminChannel = ClientInterceptors.intercept((Channel)rawAdminChannel, BigtableSession.createAdminApiInterceptors(this.options));
            this.instanceAdminClient = new BigtableInstanceGrpcClient(adminChannel);
            this.tableAdminClient = new BigtableTableAdminGrpcClient(adminChannel, sharedPools.getRetryExecutor(), this.options);
            BigtableClientMetrics.counter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"sessions.active").inc();
            return;
        }
    }

    static List<ClientInterceptor> createAdminApiInterceptors(BigtableOptions options) throws IOException {
        ImmutableList.Builder interceptors = ImmutableList.builder();
        if (options.getInstanceName() != null) {
            interceptors.add((Object)new GoogleCloudResourcePrefixInterceptor(options.getInstanceName().toString()));
        }
        interceptors.add((Object)BigtableSession.createGaxHeaderInterceptor());
        ClientInterceptor authInterceptor = BigtableSession.createAuthInterceptor(options);
        if (authInterceptor != null) {
            interceptors.add((Object)authInterceptor);
        }
        if (options.getTracingCookie() != null) {
            HeaderInterceptor tracingCookieInterceptor = new HeaderInterceptor((Metadata.Key<String>)Metadata.Key.of((String)"cookie", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), options.getTracingCookie());
            interceptors.add((Object)tracingCookieInterceptor);
        }
        return interceptors.build();
    }

    private List<ClientInterceptor> createDataApiInterceptors(BigtableOptions options, boolean useDirectPath) throws IOException {
        ClientInterceptor authInterceptor;
        ImmutableList.Builder interceptors = ImmutableList.builder();
        if (options.getInstanceName() != null) {
            interceptors.add((Object)new GoogleCloudResourcePrefixInterceptor(options.getInstanceName().toString()));
        }
        interceptors.add((Object)BigtableSession.createGaxHeaderInterceptor());
        interceptors.add((Object)this.setupWatchdog());
        if (!useDirectPath && (authInterceptor = BigtableSession.createAuthInterceptor(options)) != null) {
            interceptors.add((Object)authInterceptor);
        }
        if (options.getTracingCookie() != null) {
            HeaderInterceptor tracingCookieInterceptor = new HeaderInterceptor((Metadata.Key<String>)Metadata.Key.of((String)"cookie", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), options.getTracingCookie());
            interceptors.add((Object)tracingCookieInterceptor);
        }
        return interceptors.build();
    }

    private static ClientInterceptor createGaxHeaderInterceptor() {
        return new HeaderInterceptor((Metadata.Key<String>)Metadata.Key.of((String)ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), String.format("gl-java/%s %s/%s cbt/%s", BigtableVersionInfo.JDK_VERSION, GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion(), BigtableVersionInfo.getVersion()));
    }

    private WatchdogInterceptor setupWatchdog() {
        Preconditions.checkState((this.watchdog == null ? 1 : 0) != 0, (Object)"Watchdog already setup");
        this.watchdog = new Watchdog(Clock.SYSTEM, this.options.getRetryOptions().getReadPartialRowTimeoutMillis());
        this.watchdog.start(BigtableSessionSharedThreadPools.getInstance().getRetryExecutor());
        return new WatchdogInterceptor((Set<MethodDescriptor<?, ?>>)ImmutableSet.of((Object)BigtableGrpc.getReadRowsMethod()), this.watchdog);
    }

    @Nullable
    private static ClientInterceptor createAuthInterceptor(BigtableOptions options) throws IOException {
        CredentialInterceptorCache credentialsCache = CredentialInterceptorCache.getInstance();
        CredentialOptions credentialOptions = options.getCredentialOptions();
        try {
            return credentialsCache.getCredentialsInterceptor(credentialOptions);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Could not initialize credentials.", e);
        }
    }

    private static ChannelPool createRawDataChannelPool(final BigtableOptions options, final boolean useDirectPath) throws IOException {
        ChannelPool.ChannelFactory channelFactory = new ChannelPool.ChannelFactory(){

            @Override
            public ManagedChannel create() throws IOException {
                return BigtableSession.createNettyChannel(options.getDataHost(), options, useDirectPath, new ClientInterceptor[0]);
            }
        };
        return new ChannelPool(channelFactory, options.getChannelCount());
    }

    @InternalApi(value="For internal usage only")
    public static ManagedChannel createNettyChannel(String host, BigtableOptions options, boolean useDirectPath, ClientInterceptor ... interceptors) throws SSLException {
        ComputeEngineChannelBuilder builder;
        LOG.info("Creating new channel for %s", host);
        if (LOG.getLog().isTraceEnabled()) {
            LOG.trace(Throwables.getStackTraceAsString((Throwable)new Throwable()), new Object[0]);
        }
        if (useDirectPath) {
            builder = ComputeEngineChannelBuilder.forAddress((String)host, (int)options.getPort());
            ImmutableMap pickFirstStrategy = ImmutableMap.of((Object)"pick_first", (Object)ImmutableMap.of());
            ImmutableMap childPolicy = ImmutableMap.of((Object)"childPolicy", (Object)ImmutableList.of((Object)pickFirstStrategy));
            ImmutableMap grpcLbPolicy = ImmutableMap.of((Object)"grpclb", (Object)childPolicy);
            ImmutableMap loadBalancingConfig = ImmutableMap.of((Object)"loadBalancingConfig", (Object)ImmutableList.of((Object)grpcLbPolicy));
            builder.defaultServiceConfig((Map)loadBalancingConfig).keepAliveTime(3600L, TimeUnit.SECONDS).keepAliveTimeout(20L, TimeUnit.SECONDS);
        } else {
            builder = ManagedChannelBuilder.forAddress((String)host, (int)options.getPort());
            if (options.usePlaintextNegotiation()) {
                builder.usePlaintext();
            }
            builder.keepAliveTime(30L, TimeUnit.SECONDS).keepAliveTimeout(10L, TimeUnit.SECONDS);
        }
        if (options.getChannelConfigurator() != null) {
            builder = options.getChannelConfigurator().configureChannel((ManagedChannelBuilder)builder, host);
        }
        return builder.disableServiceConfigLookUp().idleTimeout(Long.MAX_VALUE, TimeUnit.SECONDS).maxInboundMessageSize(0x10000000).userAgent(BigtableVersionInfo.CORE_USER_AGENT + "," + options.getUserAgent()).intercept(interceptors).build();
    }

    public synchronized BigtableClusterName getClusterName() throws IOException {
        if (this.clusterName == null) {
            try (BigtableClusterUtilities util = new BigtableClusterUtilities(this.options);){
                ListClustersResponse clusters = util.getClusters();
                Preconditions.checkState((clusters.getClustersCount() == 1 ? 1 : 0) != 0, (Object)String.format("Project '%s' / Instance '%s' has %d clusters. There must be exactly 1 for this operation to work.", this.options.getProjectId(), this.options.getInstanceId(), clusters.getClustersCount()));
                this.clusterName = new BigtableClusterName(clusters.getClusters(0).getName());
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Could not get cluster Id.", e);
            }
        }
        return this.clusterName;
    }

    public BigtableDataClient getDataClient() {
        return this.dataClient;
    }

    @InternalApi(value="For internal usage only")
    public IBigtableDataClient getDataClientWrapper() {
        return new BigtableDataClientWrapper(this.dataClient, this.dataRequestContext);
    }

    public BulkMutation createBulkMutation(BigtableTableName tableName) {
        return new BulkMutation(tableName, this.throttlingDataClient, BigtableSessionSharedThreadPools.getInstance().getRetryExecutor(), this.options.getBulkOptions());
    }

    @InternalApi(value="For internal usage only")
    public IBulkMutation createBulkMutationWrapper(BigtableTableName tableName) {
        return new BulkMutationWrapper(this.createBulkMutation(tableName));
    }

    public BulkRead createBulkRead(BigtableTableName tableName) {
        return new BulkRead(this.getDataClientWrapper(), tableName, this.options.getBulkOptions().getBulkMaxRowKeyCount(), BigtableSessionSharedThreadPools.getInstance().getBatchThreadPool());
    }

    public BigtableTableAdminClient getTableAdminClient() throws IOException {
        return this.tableAdminClient;
    }

    @InternalApi(value="For internal usage only")
    public synchronized IBigtableTableAdminClient getTableAdminClientWrapper() throws IOException {
        if (this.adminClientWrapper == null) {
            this.adminClientWrapper = new BigtableTableAdminClientWrapper(this.getTableAdminClient(), this.options);
        }
        return this.adminClientWrapper;
    }

    public BigtableInstanceClient getInstanceAdminClient() throws IOException {
        return this.instanceAdminClient;
    }

    @Deprecated
    @InternalApi(value="For internal usage only")
    public static BigtableInstanceClient createInstanceClient(BigtableOptions options) throws IOException, GeneralSecurityException {
        ManagedChannel rawAdminChannel = BigtableSession.createNettyChannel(options.getAdminHost(), options, false, new ClientInterceptor[0]);
        Channel adminChannel = ClientInterceptors.intercept((Channel)rawAdminChannel, BigtableSession.createAdminApiInterceptors(options));
        return new BigtableInstanceGrpcClient(adminChannel);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.watchdog != null) {
            this.watchdog.stop();
        }
        long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
        long endTimeNanos = System.nanoTime() + timeoutNanos;
        for (ManagedChannel channel : this.managedChannels) {
            channel.shutdown();
        }
        for (ManagedChannel channel : this.managedChannels) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            try {
                channel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while closing the channelPools");
            }
        }
        for (ManagedChannel channel : this.managedChannels) {
            if (channel.isTerminated()) continue;
            LOG.info("Could not close %s after 10 seconds.", channel.getClass().getName());
            break;
        }
        this.managedChannels.clear();
        BigtableClientMetrics.counter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"sessions.active").dec();
    }

    public BigtableOptions getOptions() {
        return this.options;
    }

    static {
        if (!System.getProperty("BIGTABLE_SESSION_SKIP_WARMUP", "").equalsIgnoreCase("true")) {
            BigtableSession.performWarmup();
        }
    }
}

