/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.delay;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="DELAY", name="i18n::ActionDelay.Name", description="i18n::ActionDelay.Description", image="Delay.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionDelay.keyword"}, documentationUrl="/workflow/actions/delay.html")
public class ActionDelay
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionDelay.class;
    private static final String DEFAULT_MAXIMUM_TIMEOUT = "0";
    @HopMetadataProperty(key="maximumTimeout")
    private String maximumTimeout;
    @HopMetadataProperty(key="scaletime")
    public int scaleTime;

    public ActionDelay(String n) {
        super(n, "");
    }

    public ActionDelay() {
        this("");
    }

    public ActionDelay(ActionDelay other) {
        super(other.getName(), other.getDescription(), other.getPluginId());
        this.maximumTimeout = other.maximumTimeout;
        this.scaleTime = other.scaleTime;
    }

    public Object clone() {
        return new ActionDelay(this);
    }

    public Result execute(Result previousResult, int nr) {
        Result result;
        block11: {
            String waitscale;
            int multiple;
            result = previousResult;
            result.setResult(false);
            switch (this.scaleTime) {
                case 0: {
                    multiple = 1000;
                    waitscale = BaseMessages.getString(PKG, (String)"ActionDelay.SScaleTime.Label", (String[])new String[0]);
                    break;
                }
                case 1: {
                    multiple = 60000;
                    waitscale = BaseMessages.getString(PKG, (String)"ActionDelay.MnScaleTime.Label", (String[])new String[0]);
                    break;
                }
                default: {
                    multiple = 3600000;
                    waitscale = BaseMessages.getString(PKG, (String)"ActionDelay.HrScaleTime.Label", (String[])new String[0]);
                }
            }
            try {
                double timeStart = (double)System.currentTimeMillis() / (double)multiple;
                double iMaximumTimeout = Const.toInt((String)this.getRealMaximumTimeout(), (int)Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0));
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDelay.LetsWaitFor.Label", (Object[])new Object[]{iMaximumTimeout, waitscale}));
                }
                boolean continueLoop = true;
                if (iMaximumTimeout < 0.0) {
                    iMaximumTimeout = Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0);
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionDelay.MaximumTimeReset.Label", (String[])new String[]{String.valueOf(iMaximumTimeout), String.valueOf(waitscale)}));
                }
                while (continueLoop && !this.parentWorkflow.isStopped()) {
                    double now = (double)System.currentTimeMillis() / (double)multiple;
                    if (iMaximumTimeout >= 0.0 && now >= timeStart + iMaximumTimeout) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDelay.WaitTimeIsElapsed.Label", (String[])new String[0]));
                        }
                        continueLoop = false;
                        result.setResult(true);
                        continue;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                result.setResult(false);
                this.logError("Error  : " + e.getMessage());
                if (!Thread.currentThread().isInterrupted()) break block11;
                Thread.currentThread().interrupt();
            }
        }
        return result;
    }

    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public String getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public String getRealMaximumTimeout() {
        return Const.trim((String)this.resolve(this.getMaximumTimeout()));
    }

    public void setMaximumTimeout(String s) {
        this.maximumTimeout = s;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "maximumTimeout", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.longValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "scaleTime", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }

    public int getScaleTime() {
        return this.scaleTime;
    }

    public void setScaleTime(int scaleTime) {
        this.scaleTime = scaleTime;
    }
}

