/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs;

import com.google.cloud.ReadChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ReadChannelInputStream
extends InputStream {
    ReadChannel channel;
    ByteBuffer bytes = ByteBuffer.allocate(65536);

    public ReadChannelInputStream(ReadChannel channel) {
        this.channel = channel;
    }

    @Override
    public int read() throws IOException {
        if (this.channel == null) {
            return -1;
        }
        byte[] b = new byte[1];
        int r = this.read(b);
        if (r > 0) {
            return b[0] & 0xFF;
        }
        return r;
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int res;
        if (this.channel == null) {
            return -1;
        }
        int limit = this.bytes.limit();
        if (len < this.bytes.remaining()) {
            this.bytes.limit(len);
        }
        if ((res = this.channel.read(this.bytes)) < 0) {
            this.close();
            return -1;
        }
        this.bytes.flip();
        int read = Math.min(this.bytes.remaining(), len);
        this.bytes.get(buf, off, read);
        this.bytes.compact();
        this.bytes.limit(limit);
        return read;
    }

    @Override
    public synchronized void close() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }
}

