/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.util.Arrays;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class FixedBytes
implements Schema.LogicalType<byte[], byte[]> {
    public static final String IDENTIFIER = "FixedBytes";
    private final int byteArraySize;

    private FixedBytes(int byteArraySize) {
        this.byteArraySize = byteArraySize;
    }

    public static FixedBytes of(int byteArraySize) {
        return new FixedBytes(byteArraySize);
    }

    public int getLength() {
        return this.byteArraySize;
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Schema.FieldType getArgumentType() {
        return Schema.FieldType.INT32;
    }

    @Override
    public Integer getArgument() {
        return this.byteArraySize;
    }

    @Override
    public Schema.FieldType getBaseType() {
        return Schema.FieldType.BYTES;
    }

    @Override
    public byte[] toBaseType(byte[] input) {
        Preconditions.checkArgument((input.length == this.byteArraySize ? 1 : 0) != 0);
        return input;
    }

    @Override
    public byte[] toInputType(byte[] base) {
        Preconditions.checkArgument((base.length <= this.byteArraySize ? 1 : 0) != 0);
        if (base.length == this.byteArraySize) {
            return base;
        }
        return Arrays.copyOf(base, this.byteArraySize);
    }

    public String toString() {
        return "FixedBytes: " + this.byteArraySize;
    }
}

