/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueSetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.SetterBasedCreatorFactory;
import org.apache.beam.sdk.schemas.annotations.SchemaCaseFormat;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldNumber;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class JavaBeanSchema
extends GetterBasedSchemaProvider {
    @Override
    public <T> Schema schemaFor(TypeDescriptor<T> typeDescriptor) {
        Schema schema = JavaBeanUtils.schemaFromJavaBeanClass(typeDescriptor.getRawType(), GetterTypeSupplier.INSTANCE);
        if (ReflectUtils.getAnnotatedCreateMethod(typeDescriptor.getRawType()) == null && ReflectUtils.getAnnotatedConstructor(typeDescriptor.getRawType()) == null) {
            JavaBeanUtils.validateJavaBean(GetterTypeSupplier.INSTANCE.get(typeDescriptor.getRawType(), schema), SetterTypeSupplier.INSTANCE.get(typeDescriptor.getRawType(), schema), schema);
        }
        return schema;
    }

    @Override
    public List<FieldValueGetter> fieldValueGetters(Class<?> targetClass, Schema schema) {
        return JavaBeanUtils.getGetters(targetClass, schema, GetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
    }

    @Override
    public List<FieldValueTypeInformation> fieldValueTypeInformations(Class<?> targetClass, Schema schema) {
        return JavaBeanUtils.getFieldTypes(targetClass, schema, GetterTypeSupplier.INSTANCE);
    }

    @Override
    public SchemaUserTypeCreator schemaTypeCreator(Class<?> targetClass, Schema schema) {
        Method annotated = ReflectUtils.getAnnotatedCreateMethod(targetClass);
        if (annotated != null) {
            return JavaBeanUtils.getStaticCreator(targetClass, annotated, schema, GetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
        }
        Constructor constructor = ReflectUtils.getAnnotatedConstructor(targetClass);
        if (constructor != null) {
            return JavaBeanUtils.getConstructorCreator(targetClass, constructor, schema, GetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
        }
        SetterBasedCreatorFactory setterBasedFactory = new SetterBasedCreatorFactory(new JavaBeanSetterFactory());
        return (SchemaUserTypeCreator)setterBasedFactory.create(targetClass, schema);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    private static class JavaBeanSetterFactory
    implements Factory<List<FieldValueSetter>> {
        private JavaBeanSetterFactory() {
        }

        @Override
        public List<FieldValueSetter> create(Class<?> targetClass, Schema schema) {
            return JavaBeanUtils.getSetters(targetClass, schema, SetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
        }
    }

    @VisibleForTesting
    public static class SetterTypeSupplier
    implements FieldValueTypeSupplier {
        private static final SetterTypeSupplier INSTANCE = new SetterTypeSupplier();

        @Override
        public List<FieldValueTypeInformation> get(Class<?> clazz) {
            return ReflectUtils.getMethods(clazz).stream().filter(ReflectUtils::isSetter).filter(m -> !m.isAnnotationPresent(SchemaIgnore.class)).map(FieldValueTypeInformation::forSetter).map(t -> {
                if (t.getMethod().getAnnotation(SchemaFieldNumber.class) != null) {
                    throw new RuntimeException(String.format("@SchemaFieldNumber can only be used on getters in Java Beans. Found on setter '%s'", t.getMethod().getName()));
                }
                if (t.getMethod().getAnnotation(SchemaFieldName.class) != null) {
                    throw new RuntimeException(String.format("@SchemaFieldName can only be used on getters in Java Beans. Found on setter '%s'", t.getMethod().getName()));
                }
                if (t.getMethod().getAnnotation(SchemaCaseFormat.class) != null) {
                    throw new RuntimeException(String.format("@SchemaCaseFormat can only be used on getters in Java Beans. Found on setter '%s'", t.getMethod().getName()));
                }
                return t;
            }).collect(Collectors.toList());
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(@Nullable Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }
    }

    @VisibleForTesting
    public static class GetterTypeSupplier
    implements FieldValueTypeSupplier {
        public static final GetterTypeSupplier INSTANCE = new GetterTypeSupplier();

        @Override
        public List<FieldValueTypeInformation> get(Class<?> clazz) {
            List methods = ReflectUtils.getMethods(clazz).stream().filter(ReflectUtils::isGetter).filter(m -> !m.isAnnotationPresent(SchemaIgnore.class)).collect(Collectors.toList());
            ArrayList types = Lists.newArrayListWithCapacity((int)methods.size());
            for (int i = 0; i < methods.size(); ++i) {
                types.add(FieldValueTypeInformation.forGetter((Method)methods.get(i), i));
            }
            types.sort(Comparator.comparing(FieldValueTypeInformation::getNumber));
            GetterTypeSupplier.validateFieldNumbers(types);
            return types;
        }

        private static void validateFieldNumbers(List<FieldValueTypeInformation> types) {
            for (int i = 0; i < types.size(); ++i) {
                FieldValueTypeInformation type = types.get(i);
                Integer number = type.getNumber();
                if (number == null) {
                    throw new RuntimeException("Unexpected null number for " + type.getName());
                }
                Preconditions.checkState((number == i ? 1 : 0) != 0, (Object)("Expected field number " + i + " for field: " + type.getName() + " instead got " + number));
            }
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(@Nullable Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }
    }
}

